/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.azure;

import com.nuix.automate.utils.api.script.RestException;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.WsRsRestClientFactory;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.security.SecurityUtils;
import com.nuix.automate.workflow.core.utils.azure.AzureStorageAccountInfo;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FileUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class AzureStorageAccountRestClient
implements AutoCloseable {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(AzureStorageAccountRestClient.class);
    private static final InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"WorkflowText");
    private final String accountUrl;
    private final String accountName;
    private final String accountKey;
    private final String sasToken;
    private final Client client;
    private Path logFilePath;

    public AzureStorageAccountRestClient(String accountUrl, String accountName, String accountKey) throws GeneralSecurityException, UnsupportedEncodingException {
        this.accountUrl = accountUrl;
        this.accountName = accountName;
        this.accountKey = accountKey;
        this.sasToken = this.generateAccountSasToken(3600);
        this.client = WsRsRestClientFactory.getClientWithWhitelistValidation((String)(this.getClass().getSimpleName() + ":" + accountName), new HashSet(), (boolean)true);
        String logFileName = System.getProperty("automate.azureStorageAccount.log");
        if (logFileName != null) {
            this.logFilePath = Paths.get(logFileName, new String[0]);
        }
    }

    @Override
    public void close() {
        block2: {
            try {
                this.client.close();
            }
            catch (Exception e) {
                if (!LOGGER.isDebugEnabled()) break block2;
                LOGGER.debug("Cannot close client", (Throwable)e);
            }
        }
        WsRsRestClientFactory.remove((String)(this.getClass().getSimpleName() + ":" + this.accountName));
    }

    public AzureStorageAccountInfo getAccountInfo() throws RestException {
        String endpoint = "/?restype=account&comp=properties";
        try (Response response = this.callApi("GET", endpoint);){
            AzureStorageAccountInfo azureStorageAccountInfo = new AzureStorageAccountInfo((MultivaluedMap<String, Object>)response.getHeaders());
            return azureStorageAccountInfo;
        }
    }

    public void createContainer(String containerName) throws RestException {
        String endpoint = "/" + containerName + "?restype=container";
        this.callApi("PUT", endpoint).close();
    }

    public void deleteContainer(String containerName) throws RestException {
        String endpoint = "/" + containerName + "?restype=container";
        this.callApi("DELETE", endpoint).close();
    }

    public String generateAccountSasToken(int expirationInSeconds) throws UnsupportedEncodingException, NoSuchAlgorithmException, InvalidKeyException {
        String version = "2021-10-04";
        String services = "bqtf";
        String resourceTypes = "sco";
        String protocol = "https";
        String permissions = "rwdxlacuptfi";
        String ip = "";
        DateTime startDateTime = DateTime.now((DateTimeZone)DateTimeZone.UTC);
        String start = FormattingUtils.dateTimeToIsoString((DateTime)startDateTime);
        DateTime expiryDateTime = startDateTime.plusSeconds(expirationInSeconds);
        String expiry = FormattingUtils.dateTimeToIsoString((DateTime)expiryDateTime);
        String signatureValues = String.join((CharSequence)"\n", this.accountName, permissions, services, resourceTypes, start, expiry, ip, protocol, version, "", "");
        byte[] signatureBytes = SecurityUtils.computeHmac256((byte[])signatureValues.getBytes(StandardCharsets.UTF_8), (byte[])Base64.getDecoder().decode(this.accountKey));
        String signature = Base64.getEncoder().encodeToString(signatureBytes);
        return "sv=" + version + "&ss=" + services + "&srt=" + resourceTypes + "&sp=" + permissions + "&st=" + URLEncoder.encode(start, "UTF-8") + "&se=" + URLEncoder.encode(expiry, "UTF-8") + "&spr=" + protocol + "&sig=" + URLEncoder.encode(signature, "UTF-8");
    }

    private Response callApi(String method, String endpoint) throws RestException {
        Response response;
        Object url = this.accountUrl;
        url = !endpoint.startsWith("/") ? (String)url + "/" + endpoint : (String)url + endpoint;
        String logEntry = "------- " + FormattingUtils.dateTimeToGMTString((DateTime)DateTime.now((DateTimeZone)DateTimeZone.UTC)) + "\n" + method + " " + (String)url + "\n";
        this.writeToLogFile(logEntry);
        url = !((String)url).contains("?") ? (String)url + "?" : (String)url + "&";
        url = (String)url + this.sasToken;
        Invocation.Builder builder = this.client.target((String)url).request();
        switch (method) {
            case "GET": {
                response = builder.get();
                break;
            }
            case "PUT": {
                response = builder.put(Entity.json(new HashMap()));
                break;
            }
            case "DELETE": {
                response = builder.delete();
                break;
            }
            default: {
                throw new IllegalArgumentException("Method not implemented for Azure storage account REST API: " + method);
            }
        }
        this.writeToLogFile("Response HTTP/" + response.getStatus());
        if (response.getStatus() >= 400 && response.getStatus() < 600) {
            response.bufferEntity();
            String errorString = (String)response.readEntity(String.class);
            String errorMessage = "HTTP/" + response.getStatus() + " " + errorString;
            this.writeToLogFile(errorMessage);
            throw new RestException(errorMessage);
        }
        return response;
    }

    private void writeToLogFile(String entry) {
        if (this.logFilePath != null) {
            try {
                FileUtils.writeStringToFile((File)this.logFilePath.toFile(), (String)("\n" + entry), (Charset)StandardCharsets.UTF_8, (boolean)true);
            }
            catch (IOException e) {
                LOGGER.error("Error writing to Purview log", (Throwable)e);
            }
        }
    }
}

