/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.brainspace;

import com.google.gson.Gson;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.general.WsRsRestClientFactory;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.workflow.core.execution.options.usebrainspacedataset.BrainspaceIdentifierType;
import com.nuix.automate.workflow.core.utils.brainspace.BrainspaceDatasetDoesNotExistException;
import com.nuix.automate.workflow.core.utils.brainspace.BrainspaceFieldsMapping;
import com.nuix.automate.workflow.core.utils.brainspace.BrainspaceGroupDoesNotExistException;
import com.nuix.automate.workflow.core.utils.brainspace.BrainspaceNotebookDoesNotExistException;
import com.nuix.automate.workflow.core.utils.brainspace.BrainspaceObject;
import com.nuix.automate.workflow.core.utils.brainspace.BrainspaceSearchResponse;
import com.nuix.automate.workflow.core.utils.brainspace.BrainspaceTagChoice;
import com.nuix.automate.workflow.core.utils.brainspace.BrainspaceTagDefinition;
import com.nuix.automate.workflow.core.utils.brainspace.BrainspaceTypedSearchResponse;
import com.nuix.automate.workflow.core.utils.brainspace.BrainspaceUpdateTagChoice;
import com.nuix.automate.workflow.core.utils.brainspace.BrainspaceUpdateTagDefinition;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.invoke.CallSite;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.http.MethodNotSupportedException;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.file.StreamDataBodyPart;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BrainspaceRestClient {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(BrainspaceRestClient.class);
    protected transient InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"WorkflowText");
    private String apiUrl;
    private String apiKey;
    private String fingerprint;
    private Client client;
    private Gson gson;

    public BrainspaceRestClient(String apiUrl, String apiKey, String fingerprint) throws GeneralSecurityException {
        this.apiUrl = apiUrl + "/rest";
        this.apiKey = apiKey;
        this.fingerprint = fingerprint;
        HashSet<String> fingerprints = new HashSet<String>();
        if (fingerprint != null && fingerprint.length() > 0) {
            fingerprints.add(fingerprint.trim());
        }
        this.client = WsRsRestClientFactory.getClientWithWhitelistValidation((String)"brainspace-api", fingerprints, (boolean)true);
        this.gson = new Gson();
    }

    public <ResponseType, RequestType> ResponseType callApiFile(String url, String method, String data, String fileExtension, GenericType<ResponseType> entityType) throws IOException {
        LOGGER.info(method + " " + url);
        try (Response response = null;){
            String stringResponse;
            WebTarget webTarget = this.client.target(url);
            Invocation.Builder invocationBuilder = webTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("APIKey " + this.apiKey)).header("Accept", (Object)"application/json");
            String logFileName = System.getProperty("automate.brainspace.log");
            File logFile = null;
            if (logFileName != null) {
                logFile = new File(logFileName);
            }
            if (logFile != null) {
                try {
                    FileUtils.writeStringToFile((File)logFile, (String)("\n------- " + FormattingUtils.dateTimeToGMTString((DateTime)DateTime.now((DateTimeZone)DateTimeZone.UTC)) + "\n"), (Charset)StandardCharsets.UTF_8, (boolean)true);
                    FileUtils.writeStringToFile((File)logFile, (String)(method + " " + url + "\n"), (Charset)StandardCharsets.UTF_8, (boolean)true);
                    FileUtils.writeStringToFile((File)logFile, (String)data, (Charset)StandardCharsets.UTF_8, (boolean)true);
                    FileUtils.writeStringToFile((File)logFile, (String)"\n\n", (Charset)StandardCharsets.UTF_8, (boolean)true);
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot write Brainspace log", (Throwable)e);
                }
            }
            ByteArrayInputStream stream = new ByteArrayInputStream(data.getBytes(StandardCharsets.UTF_8));
            StreamDataBodyPart filePart = new StreamDataBodyPart("placeholder." + fileExtension, stream){

                protected FormDataContentDisposition buildContentDisposition() {
                    FormDataContentDisposition contentDisposition = new FormDataContentDisposition("form-data", this.getName(), this.getName(), null, null, null, 0L){

                        protected StringBuilder toStringBuffer() {
                            StringBuilder sb = new StringBuilder();
                            sb.append(this.getType());
                            this.addStringParameter(sb, "name", "file");
                            this.addStringParameter(sb, "filename", this.getName());
                            return sb;
                        }
                    };
                    return contentDisposition;
                }
            };
            try (FormDataMultiPart formDataMultiPart = new FormDataMultiPart();){
                FormDataMultiPart multipart = (FormDataMultiPart)formDataMultiPart.bodyPart((BodyPart)filePart);
                switch (method) {
                    case "POST": {
                        response = invocationBuilder.post(Entity.entity((Object)multipart, (MediaType)MediaType.valueOf((String)multipart.getMediaType().toString())));
                        break;
                    }
                    case "PUT": {
                        response = invocationBuilder.put(Entity.entity((Object)multipart, (MediaType)MediaType.valueOf((String)multipart.getMediaType().toString())));
                        break;
                    }
                    default: {
                        throw new NotImplementedException("Method " + method + " not implemented in server API with body");
                    }
                }
                if (logFile != null) {
                    try {
                        FileUtils.writeStringToFile((File)logFile, (String)("Response HTTP/" + response.getStatus() + "\n"), (Charset)StandardCharsets.UTF_8, (boolean)true);
                    }
                    catch (Exception e) {
                        LOGGER.warn("Cannot write Brainspace log", (Throwable)e);
                    }
                }
            }
            if (response.getStatus() == 401) {
                throw new IOException(this.iu.getString("BrainspaceRestClient.Error.InvalidApiKey"));
            }
            if (response.getStatus() == 403) {
                throw new IOException("User does not have permissions to perform operation in Brainspace");
            }
            if (response.getStatus() == 404) {
                throw new NotFoundException(this.iu.getString("BrainspaceRestClient.Error.CannotConnectToService"));
            }
            if (response.getStatus() == 405) {
                throw new MethodNotSupportedException(this.iu.getString("BrainspaceRestClient.Error.CannotConnectToService"));
            }
            if (response.getStatus() != 200 && response.getStatus() != 201 && response.getStatus() != 202 && response.getStatus() != 204) {
                response.bufferEntity();
                stringResponse = (String)response.readEntity(String.class);
                LOGGER.error(this.apiUrl + " responded with HTTP/" + response.getStatus() + " " + stringResponse);
                throw new IOException("HTTP/" + response.getStatus() + " " + stringResponse);
            }
            stringResponse = (String)response.readEntity(String.class);
            Object responseData = entityType.getType().equals(String.class) ? stringResponse : SerializationUtils.fromJson((String)stringResponse, (Class)entityType.getRawType());
            if (logFile != null) {
                try {
                    FileUtils.writeStringToFile((File)logFile, (String)responseData.toString(), (Charset)StandardCharsets.UTF_8, (boolean)true);
                    FileUtils.writeStringToFile((File)logFile, (String)"\n", (Charset)StandardCharsets.UTF_8, (boolean)true);
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot write Discover log", (Throwable)e);
                }
            }
            Object object = responseData;
            return (ResponseType)object;
        }
    }

    public <ResponseType, RequestType> ResponseType callApi(String url, String method, RequestType requestData, GenericType<ResponseType> entityType) throws IOException {
        LOGGER.info(method + " " + url);
        try (Response response = null;){
            String stringResponse;
            WebTarget webTarget = this.client.target(url);
            Invocation.Builder invocationBuilder = webTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("APIKey " + this.apiKey)).header("Accept", (Object)"application/json").header("Content-Type", (Object)"application/json");
            String logFileName = System.getProperty("automate.brainspace.log");
            File logFile = null;
            if (logFileName != null) {
                logFile = new File(logFileName);
            }
            if (logFile != null) {
                try {
                    FileUtils.writeStringToFile((File)logFile, (String)("\n------- " + FormattingUtils.dateTimeToGMTString((DateTime)DateTime.now((DateTimeZone)DateTimeZone.UTC)) + "\n"), (Charset)StandardCharsets.UTF_8, (boolean)true);
                    FileUtils.writeStringToFile((File)logFile, (String)(method + " " + url + "\n"), (Charset)StandardCharsets.UTF_8, (boolean)true);
                    FileUtils.writeStringToFile((File)logFile, (String)this.gson.toJson(requestData), (Charset)StandardCharsets.UTF_8, (boolean)true);
                    FileUtils.writeStringToFile((File)logFile, (String)"\n\n", (Charset)StandardCharsets.UTF_8, (boolean)true);
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot write Brainspace log", (Throwable)e);
                }
            }
            switch (method) {
                case "POST": {
                    response = invocationBuilder.post(Entity.entity((Object)SerializationUtils.toJson(requestData, (boolean)false), (String)"application/json"));
                    break;
                }
                case "PUT": {
                    response = invocationBuilder.put(Entity.entity((Object)SerializationUtils.toJson(requestData, (boolean)false), (String)"application/json"));
                    break;
                }
                default: {
                    throw new NotImplementedException("Method " + method + " not implemented in server API with body");
                }
            }
            if (logFile != null) {
                try {
                    FileUtils.writeStringToFile((File)logFile, (String)("Response HTTP/" + response.getStatus() + "\n"), (Charset)StandardCharsets.UTF_8, (boolean)true);
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot write Brainspace log", (Throwable)e);
                }
            }
            if (response.getStatus() == 401) {
                throw new IOException(this.iu.getString("BrainspaceRestClient.Error.InvalidApiKey"));
            }
            if (response.getStatus() == 403) {
                throw new IOException("User does not have permissions to perform operation in Brainspace");
            }
            if (response.getStatus() == 404) {
                throw new NotFoundException(this.iu.getString("BrainspaceRestClient.Error.CannotConnectToService"));
            }
            if (response.getStatus() == 405) {
                throw new MethodNotSupportedException(this.iu.getString("BrainspaceRestClient.Error.CannotConnectToService"));
            }
            if (response.getStatus() != 200 && response.getStatus() != 201 && response.getStatus() != 202 && response.getStatus() != 204) {
                response.bufferEntity();
                stringResponse = (String)response.readEntity(String.class);
                LOGGER.error(this.apiUrl + " responded with HTTP/" + response.getStatus() + " " + stringResponse);
                throw new IOException("HTTP/" + response.getStatus() + " " + stringResponse);
            }
            stringResponse = (String)response.readEntity(String.class);
            Object responseData = entityType.getType().equals(String.class) ? stringResponse : SerializationUtils.fromJson((String)stringResponse, (Class)entityType.getRawType());
            if (logFile != null) {
                try {
                    FileUtils.writeStringToFile((File)logFile, (String)responseData.toString(), (Charset)StandardCharsets.UTF_8, (boolean)true);
                    FileUtils.writeStringToFile((File)logFile, (String)"\n", (Charset)StandardCharsets.UTF_8, (boolean)true);
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot write Discover log", (Throwable)e);
                }
            }
            Object object = responseData;
            return (ResponseType)object;
        }
    }

    public <ResponseType, RequestType> ResponseType callApi(String url, String method, GenericType<ResponseType> entityType) throws IOException {
        LOGGER.info(method + " " + url);
        try (Response response = null;){
            String stringResponse;
            WebTarget webTarget = this.client.target(url);
            Invocation.Builder invocationBuilder = webTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("APIKey " + this.apiKey)).header("Accept", (Object)"application/json").header("Content-Type", (Object)"application/json");
            String logFileName = System.getProperty("automate.brainspace.log");
            File logFile = null;
            if (logFileName != null) {
                logFile = new File(logFileName);
            }
            if (logFile != null) {
                try {
                    FileUtils.writeStringToFile((File)logFile, (String)("\n------- " + FormattingUtils.dateTimeToGMTString((DateTime)DateTime.now((DateTimeZone)DateTimeZone.UTC)) + "\n"), (Charset)StandardCharsets.UTF_8, (boolean)true);
                    FileUtils.writeStringToFile((File)logFile, (String)(method + " " + url + "\n"), (Charset)StandardCharsets.UTF_8, (boolean)true);
                    FileUtils.writeStringToFile((File)logFile, (String)"\n", (Charset)StandardCharsets.UTF_8, (boolean)true);
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot write Brainspace log", (Throwable)e);
                }
            }
            switch (method) {
                case "GET": {
                    response = invocationBuilder.get();
                    break;
                }
                case "DELETE": {
                    response = invocationBuilder.delete();
                    break;
                }
                default: {
                    throw new NotImplementedException("Method " + method + " not implemented in server API without body");
                }
            }
            if (logFile != null) {
                try {
                    FileUtils.writeStringToFile((File)logFile, (String)("Response HTTP/" + response.getStatus() + "\n"), (Charset)StandardCharsets.UTF_8, (boolean)true);
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot write Brainspace log", (Throwable)e);
                }
            }
            if (response.getStatus() == 401) {
                throw new IOException(this.iu.getString("BrainspaceRestClient.Error.InvalidApiKey"));
            }
            if (response.getStatus() == 403) {
                throw new IOException("User does not have permissions to perform operation in Brainspace");
            }
            if (response.getStatus() == 404) {
                throw new NotFoundException(this.iu.getString("BrainspaceRestClient.Error.CannotConnectToService"));
            }
            if (response.getStatus() == 405) {
                throw new MethodNotSupportedException(this.iu.getString("BrainspaceRestClient.Error.CannotConnectToService"));
            }
            if (response.getStatus() != 200 && response.getStatus() != 201 && response.getStatus() != 202) {
                response.bufferEntity();
                stringResponse = (String)response.readEntity(String.class);
                LOGGER.error(this.apiUrl + " responded with HTTP/" + response.getStatus() + " " + stringResponse);
                throw new IOException("HTTP/" + response.getStatus() + " " + stringResponse);
            }
            stringResponse = (String)response.readEntity(String.class);
            Object responseData = entityType.getType().equals(String.class) ? stringResponse : SerializationUtils.fromJson((String)stringResponse, (Class)entityType.getRawType());
            if (logFile != null) {
                try {
                    FileUtils.writeStringToFile((File)logFile, (String)new Gson().toJson(responseData), (Charset)StandardCharsets.UTF_8, (boolean)true);
                    FileUtils.writeStringToFile((File)logFile, (String)"\n", (Charset)StandardCharsets.UTF_8, (boolean)true);
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot write Brainspace log", (Throwable)e);
                }
            }
            Object object = responseData;
            return (ResponseType)object;
        }
    }

    public String getVersion() throws IOException {
        LOGGER.info("Getting version");
        String url = this.apiUrl + "/system/compound-version";
        String response = this.callApi(url, "GET", new GenericType<String>(){});
        try {
            Map responseMap = (Map)this.gson.fromJson(response, Map.class);
            Object serviceVersion = responseMap.get("marketingVersion");
            if (serviceVersion != null) {
                return serviceVersion.toString();
            }
            LOGGER.error("API response: " + response);
            throw new IOException("Unexpected API response");
        }
        catch (Exception e) {
            LOGGER.error("API response: " + response);
            throw new IOException("Unexpected API response", e);
        }
    }

    public BrainspaceObject getDataset(long datasetId) throws IOException, BrainspaceDatasetDoesNotExistException {
        LOGGER.info("Dataset " + datasetId + " getting details");
        String url = this.apiUrl + "/dataset/" + datasetId;
        try {
            Map<String, Object> response = this.callApi(url, "GET", new GenericType<Map<String, Object>>(){});
            return this.getBrainspaceObjectFromResponse(response);
        }
        catch (IOException e) {
            throw new BrainspaceDatasetDoesNotExistException();
        }
    }

    public BrainspaceObject getNotebook(long datasetId, long notebookId) throws IOException, BrainspaceNotebookDoesNotExistException {
        LOGGER.info("Dataset " + datasetId + " getting notebook " + notebookId);
        String url = this.apiUrl + "/dataset/" + datasetId + "/notebook/" + notebookId;
        try {
            Map<String, Object> response = this.callApi(url, "GET", new GenericType<Map<String, Object>>(){});
            return this.getBrainspaceObjectFromResponse(response);
        }
        catch (IOException e) {
            throw new BrainspaceNotebookDoesNotExistException();
        }
    }

    public Map getDatasetDetails(long datasetId) throws IOException {
        LOGGER.info("Dataset " + datasetId + " getting details");
        String url = this.apiUrl + "/dataset/" + datasetId;
        Map<String, Object> response = this.callApi(url, "GET", new GenericType<Map<String, Object>>(){});
        return response;
    }

    public Map getDatasetIngestConfig(long datasetId) throws IOException {
        LOGGER.info("Dataset " + datasetId + " getting ingest config");
        String url = this.apiUrl + "/dataset/" + datasetId + "/ingest/config";
        Map<String, Object> response = this.callApi(url, "GET", new GenericType<Map<String, Object>>(){});
        return response;
    }

    public List<Map> getDatasetGroups(long datasetId) throws IOException {
        LOGGER.info("Dataset " + datasetId + " getting groups");
        String url = this.apiUrl + "/dataset/" + datasetId + "/group";
        List<Map> response = this.callApi(url, "GET", new GenericType<List<Map>>(){});
        return response;
    }

    public BrainspaceObject getDataset(BrainspaceIdentifierType identifierType, String identifier) throws IOException, BrainspaceDatasetDoesNotExistException {
        switch (identifierType) {
            case ID: {
                return this.getDataset(Long.parseLong(identifier));
            }
            case NAME: {
                return this.getDataset(identifier);
            }
            case NAME_REGEX: {
                return this.getDataset(Pattern.compile(identifier));
            }
        }
        throw new IOException("Unsupported identifier type " + String.valueOf((Object)identifierType));
    }

    public BrainspaceObject getNotebook(long datasetId, BrainspaceIdentifierType identifierType, String identifier) throws IOException, BrainspaceNotebookDoesNotExistException {
        switch (identifierType) {
            case ID: {
                return this.getNotebook(datasetId, Long.parseLong(identifier));
            }
            case NAME: {
                return this.getNotebook(datasetId, identifier);
            }
            case NAME_REGEX: {
                return this.getNotebook(datasetId, Pattern.compile(identifier));
            }
        }
        throw new IOException("Unsupported identifier type " + String.valueOf((Object)identifierType));
    }

    public BrainspaceObject getGroup(BrainspaceIdentifierType identifierType, String identifier) throws IOException, BrainspaceGroupDoesNotExistException {
        switch (identifierType) {
            case ID: {
                return this.getGroup(Long.parseLong(identifier));
            }
            case NAME: {
                return this.getGroup(identifier);
            }
            case NAME_REGEX: {
                return this.getGroup(Pattern.compile(identifier));
            }
        }
        throw new IOException("Unsupported identifier type " + String.valueOf((Object)identifierType));
    }

    public BrainspaceObject getGroup(long groupId) throws IOException, BrainspaceGroupDoesNotExistException {
        LOGGER.info("Group " + groupId + " getting details");
        String url = this.apiUrl + "/group/" + groupId;
        try {
            Map<String, Object> response = this.callApi(url, "GET", new GenericType<Map<String, Object>>(){});
            return this.getBrainspaceObjectFromResponse(response);
        }
        catch (IOException e) {
            throw new BrainspaceGroupDoesNotExistException();
        }
    }

    public BrainspaceObject getNotebook(long datasetId, String notebookName) throws IOException, BrainspaceNotebookDoesNotExistException {
        List<BrainspaceObject> notebooks = this.getAllNotebooks(datasetId);
        ArrayList<BrainspaceObject> matchingNotebooks = new ArrayList<BrainspaceObject>();
        for (BrainspaceObject notebook : notebooks) {
            if (!notebook.getName().equals(notebookName)) continue;
            matchingNotebooks.add(notebook);
        }
        if (matchingNotebooks.size() == 1) {
            return (BrainspaceObject)matchingNotebooks.get(0);
        }
        if (matchingNotebooks.size() > 1) {
            ArrayList<CallSite> ids = new ArrayList<CallSite>();
            for (BrainspaceObject notebook : matchingNotebooks) {
                ids.add((CallSite)((Object)(notebook.getName() + " (ID: " + notebook.getId() + ")")));
            }
            throw new IOException(this.iu.getFormattedString("UseBrainspaceDataset.Error.MultipleNotebooksWithName", (Object)String.join((CharSequence)", ", ids)));
        }
        throw new BrainspaceNotebookDoesNotExistException();
    }

    public BrainspaceObject getDataset(String datasetName) throws IOException, BrainspaceDatasetDoesNotExistException {
        List<BrainspaceObject> datasets = this.getAllDatasets();
        ArrayList<BrainspaceObject> matchingDatasets = new ArrayList<BrainspaceObject>();
        for (BrainspaceObject dataset : datasets) {
            if (!dataset.getName().equals(datasetName)) continue;
            matchingDatasets.add(dataset);
        }
        if (matchingDatasets.size() == 1) {
            return (BrainspaceObject)matchingDatasets.get(0);
        }
        if (matchingDatasets.size() > 1) {
            ArrayList<CallSite> ids = new ArrayList<CallSite>();
            for (BrainspaceObject dataset : matchingDatasets) {
                ids.add((CallSite)((Object)(dataset.getName() + " (ID: " + dataset.getId() + ")")));
            }
            throw new IOException(this.iu.getFormattedString("UseBrainspaceDataset.Error.MultipleDatasetsWithName", (Object)String.join((CharSequence)", ", ids)));
        }
        throw new BrainspaceDatasetDoesNotExistException();
    }

    public BrainspaceObject getGroup(String groupName) throws IOException, BrainspaceGroupDoesNotExistException {
        List<BrainspaceObject> groups = this.getAllGroups();
        ArrayList<BrainspaceObject> matchingGroups = new ArrayList<BrainspaceObject>();
        for (BrainspaceObject group : groups) {
            if (!group.getName().equals(groupName)) continue;
            matchingGroups.add(group);
        }
        if (matchingGroups.size() == 1) {
            return (BrainspaceObject)matchingGroups.get(0);
        }
        if (matchingGroups.size() > 1) {
            ArrayList<CallSite> ids = new ArrayList<CallSite>();
            for (BrainspaceObject group : matchingGroups) {
                ids.add((CallSite)((Object)(group.getName() + " (ID: " + group.getId() + ")")));
            }
            throw new IOException(this.iu.getFormattedString("UseBrainspaceDataset.Error.MultipleGroupsWithName", (Object)String.join((CharSequence)", ", ids)));
        }
        throw new BrainspaceGroupDoesNotExistException();
    }

    public BrainspaceObject getDataset(Pattern pattern) throws IOException, BrainspaceDatasetDoesNotExistException {
        List<BrainspaceObject> datasets = this.getAllDatasets();
        ArrayList<BrainspaceObject> matchingDatasets = new ArrayList<BrainspaceObject>();
        for (BrainspaceObject dataset : datasets) {
            Matcher matcher = pattern.matcher(dataset.getName());
            if (!matcher.find()) continue;
            matchingDatasets.add(dataset);
        }
        if (matchingDatasets.size() == 1) {
            return (BrainspaceObject)matchingDatasets.get(0);
        }
        if (matchingDatasets.size() > 1) {
            ArrayList<CallSite> ids = new ArrayList<CallSite>();
            for (BrainspaceObject dataset : matchingDatasets) {
                ids.add((CallSite)((Object)(dataset.getName() + " (ID: " + dataset.getId() + ")")));
            }
            throw new IOException(this.iu.getFormattedString("UseBrainspaceDataset.Error.MultipleDatasetsWithRegex", (Object)String.join((CharSequence)", ", ids)));
        }
        throw new BrainspaceDatasetDoesNotExistException();
    }

    public BrainspaceObject getNotebook(long datasetId, Pattern pattern) throws IOException, BrainspaceNotebookDoesNotExistException {
        List<BrainspaceObject> notebooks = this.getAllNotebooks(datasetId);
        ArrayList<BrainspaceObject> matchingNotebooks = new ArrayList<BrainspaceObject>();
        for (BrainspaceObject notebook : notebooks) {
            Matcher matcher = pattern.matcher(notebook.getName());
            if (!matcher.find()) continue;
            matchingNotebooks.add(notebook);
        }
        if (matchingNotebooks.size() == 1) {
            return (BrainspaceObject)matchingNotebooks.get(0);
        }
        if (matchingNotebooks.size() > 1) {
            ArrayList<CallSite> ids = new ArrayList<CallSite>();
            for (BrainspaceObject notebook : matchingNotebooks) {
                ids.add((CallSite)((Object)(notebook.getName() + " (ID: " + notebook.getId() + ")")));
            }
            throw new IOException(this.iu.getFormattedString("UseBrainspaceDataset.Error.MultipleNotebooksWithRegex", (Object)String.join((CharSequence)", ", ids)));
        }
        throw new BrainspaceNotebookDoesNotExistException();
    }

    public BrainspaceObject getGroup(Pattern pattern) throws IOException, BrainspaceGroupDoesNotExistException {
        List<BrainspaceObject> groups = this.getAllGroups();
        ArrayList<BrainspaceObject> matchingGroups = new ArrayList<BrainspaceObject>();
        for (BrainspaceObject group : groups) {
            Matcher matcher = pattern.matcher(group.getName());
            if (!matcher.find()) continue;
            matchingGroups.add(group);
        }
        if (matchingGroups.size() == 1) {
            return (BrainspaceObject)matchingGroups.get(0);
        }
        if (matchingGroups.size() > 1) {
            ArrayList<CallSite> ids = new ArrayList<CallSite>();
            for (BrainspaceObject group : matchingGroups) {
                ids.add((CallSite)((Object)(group.getName() + " (ID: " + group.getId() + ")")));
            }
            throw new IOException(this.iu.getFormattedString("UseBrainspaceDataset.Error.MultipleGroupsWithRegex", (Object)String.join((CharSequence)", ", ids)));
        }
        throw new BrainspaceGroupDoesNotExistException();
    }

    private List<BrainspaceObject> getAllNotebooks(long datasetId) throws IOException {
        BrainspaceSearchResponse response;
        LOGGER.info("Dataset " + datasetId + " getting notebooks");
        long count = 1000L;
        long start = 0L;
        ArrayList<BrainspaceObject> datasets = new ArrayList<BrainspaceObject>();
        do {
            String url = this.apiUrl + "/dataset/" + datasetId + "/notebook?start=" + start + "&count=" + count + "&accessMode=ALL";
            response = this.callApi(url, "GET", new GenericType<BrainspaceSearchResponse>(){});
            start += response.getCount();
            List<Map> results = response.getResults();
            for (Map result : results) {
                datasets.add(this.getBrainspaceObjectFromResponse(result));
            }
        } while (start < response.getTotalResults());
        return datasets;
    }

    public List<BrainspaceTagDefinition> getAllChoiceTags(long datasetId) throws IOException {
        BrainspaceTypedSearchResponse<BrainspaceTagDefinition> response;
        LOGGER.info("Dataset " + datasetId + " getting choice tags");
        long count = 1000L;
        long start = 0L;
        ArrayList<BrainspaceTagDefinition> tags = new ArrayList<BrainspaceTagDefinition>();
        do {
            String url = this.apiUrl + "/dataset/" + datasetId + "/tag?start=" + start + "&count=" + count;
            response = this.callApi(url, "GET", new GenericType<BrainspaceTypedSearchResponse<BrainspaceTagDefinition>>(){});
            start += response.getCount();
            List<BrainspaceTagDefinition> results = response.getResults();
            for (BrainspaceTagDefinition result : results) {
                String tagType = result.getType();
                if (!tagType.equals("SINGLE_CHOICE")) continue;
                tags.add(result);
            }
        } while (start < response.getTotalResults());
        return tags;
    }

    public BrainspaceSearchResponse searchForDocuments(long datasetId, String query, Set<String> fields, List<Long> tagIds, long start) throws IOException {
        LOGGER.info("Dataset " + datasetId + " searching for documents with query " + query + ", fields: " + fields.size() + " tags: " + tagIds.size() + " start: " + start);
        long count = 1000L;
        HashMap<String, Object> searchRequest = new HashMap<String, Object>();
        searchRequest.put("start", start);
        searchRequest.put("count", count);
        searchRequest.put("fields", fields);
        HashMap<String, String> querySettings = new HashMap<String, String>();
        querySettings.put("query", query);
        querySettings.put("type", "lucene");
        searchRequest.put("query", querySettings);
        if (tagIds != null && tagIds.size() > 0) {
            HashMap<String, List<Long>> tagSettings = new HashMap<String, List<Long>>();
            tagSettings.put("tagIds", tagIds);
            searchRequest.put("tags", tagSettings);
        }
        String url = this.apiUrl + "/dataset/" + datasetId + "/search";
        String response = this.callApi(url, "POST", searchRequest, new GenericType<String>(){});
        BrainspaceSearchResponse brainspaceSearchResponse = (BrainspaceSearchResponse)this.gson.fromJson(response, BrainspaceSearchResponse.class);
        return brainspaceSearchResponse;
    }

    public List<Map<String, Object>> getAllDocumentTags(long datasetId, String documentId) throws IOException {
        LOGGER.info("Dataset " + datasetId + " getting document " + documentId + " tags");
        long count = 1000L;
        long start = 0L;
        long totalResults = 0L;
        ArrayList<Map<String, Object>> documentTags = new ArrayList<Map<String, Object>>();
        do {
            String url = this.apiUrl + "/dataset/" + datasetId + "/doc/" + documentId + "/tag?query=&start=" + start + "&count=" + count;
            String response = this.callApi(url, "GET", new GenericType<String>(){});
            Map responseMap = (Map)this.gson.fromJson(response, Map.class);
            totalResults = ((Number)responseMap.get("totalResults")).longValue();
            count = ((Number)responseMap.get("count")).longValue();
            List results = (List)responseMap.get("results");
            documentTags.addAll(results);
        } while ((start += count) < totalResults);
        return documentTags;
    }

    private List<BrainspaceObject> getAllDatasets() throws IOException {
        LOGGER.info("Getting all datasets");
        long count = 1000L;
        long start = 0L;
        long totalResults = 0L;
        ArrayList<BrainspaceObject> datasets = new ArrayList<BrainspaceObject>();
        do {
            String url = this.apiUrl + "/dataset/adminview?query=&start=" + start + "&count=" + count + "&sort=name";
            String response = this.callApi(url, "GET", new GenericType<String>(){});
            Map responseMap = (Map)this.gson.fromJson(response, Map.class);
            totalResults = ((Number)responseMap.get("totalResults")).longValue();
            count = ((Number)responseMap.get("count")).longValue();
            start += count;
            List results = (List)responseMap.get("results");
            for (Map result : results) {
                datasets.add(this.getBrainspaceObjectFromResponse(result));
            }
        } while (start < totalResults);
        return datasets;
    }

    private List<BrainspaceObject> getAllGroups() throws IOException {
        LOGGER.info("Getting all groups");
        long count = 1000L;
        long start = 0L;
        long totalResults = 0L;
        ArrayList<BrainspaceObject> datasets = new ArrayList<BrainspaceObject>();
        do {
            String url = this.apiUrl + "/group?query=&start=" + start + "&count=" + count + "&sort=name";
            String response = this.callApi(url, "GET", new GenericType<String>(){});
            Map responseMap = (Map)this.gson.fromJson(response, Map.class);
            totalResults = ((Number)responseMap.get("totalResults")).longValue();
            count = ((Number)responseMap.get("count")).longValue();
            start += count;
            List results = (List)responseMap.get("results");
            for (Map result : results) {
                datasets.add(this.getBrainspaceObjectFromResponse(result));
            }
        } while (start < totalResults);
        return datasets;
    }

    public BrainspaceObject cloneDataset(String name, BrainspaceObject sourceDataset, boolean copyGroups, BrainspaceObject addToGroup) throws IOException, BrainspaceDatasetDoesNotExistException {
        Map sourceDatasetDetails = this.getDatasetDetails(sourceDataset.getId());
        Map sourceDatasetIngestConfig = this.getDatasetIngestConfig(sourceDataset.getId());
        HashSet<Long> groupIds = new HashSet<Long>();
        if (copyGroups) {
            List<Map> sourceDatasetGroups = this.getDatasetGroups(sourceDataset.getId());
            for (Map sourceDatasetGroup : sourceDatasetGroups) {
                long groupId = ((Number)sourceDatasetGroup.get("groupId")).longValue();
                groupIds.add(groupId);
            }
        }
        if (addToGroup != null) {
            groupIds.add(addToGroup.getId());
        }
        LOGGER.info("Creating dataset " + name + " with groups " + String.join((CharSequence)(", " + String.valueOf(groupIds)), new CharSequence[0]));
        BrainspaceObject dataset = this.createDataset(name, groupIds, sourceDatasetDetails);
        this.setDatasetIngestConfig(dataset.getId(), sourceDatasetIngestConfig);
        this.updateDataset(dataset.getId(), name, groupIds, sourceDatasetDetails);
        return dataset;
    }

    public void submitItemsJson(long datasetId, List<Map<String, Object>> itemsMetadata) throws IOException, ParserConfigurationException, TransformerException {
        LOGGER.info("Dataset " + datasetId + " submitting JSON items: " + itemsMetadata.size());
        String url = this.apiUrl + "/dataset/" + datasetId + "/archive/json";
        HashMap<String, List<Map<String, Object>>> root = new HashMap<String, List<Map<String, Object>>>();
        root.put("docs", itemsMetadata);
        String jsonString = SerializationUtils.toJson(root);
        String response = this.callApiFile(url, "PUT", jsonString, "json", new GenericType<String>(){});
    }

    public void submitItemsXml(long datasetId, List<Map<String, Object>> itemsMetadata) throws IOException, ParserConfigurationException, TransformerException {
        LOGGER.info("Dataset " + datasetId + " submitting XML items: " + itemsMetadata.size());
        String url = this.apiUrl + "/dataset/" + datasetId + "/archive/xml";
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document xmlDocument = documentBuilder.newDocument();
        Element docsElement = xmlDocument.createElement("docs");
        xmlDocument.appendChild(docsElement);
        for (Map<String, Object> itemMetadata : itemsMetadata) {
            Element docElement = xmlDocument.createElement("doc");
            for (String key : itemMetadata.keySet()) {
                Object value = itemMetadata.get(key);
                Element field = xmlDocument.createElement(key);
                String fieldValue = value.toString();
                field.appendChild(xmlDocument.createTextNode(fieldValue));
                docElement.appendChild(field);
            }
            docsElement.appendChild(docElement);
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        StringWriter stringWriter = new StringWriter();
        transformer.transform(new DOMSource(xmlDocument), new StreamResult(stringWriter));
        String xmlString = stringWriter.toString();
        String response = this.callApiFile(url, "PUT", xmlString, "xml", new GenericType<String>(){});
    }

    public void setFieldsMapping(long datasetId, BrainspaceFieldsMapping fieldsMapping) throws IOException {
        LOGGER.info("Dataset " + datasetId + " submitting fieldmap");
        String url = this.apiUrl + "/dataset/" + datasetId + "/ingest/fieldmap";
        String response = this.callApi(url, "PUT", fieldsMapping, new GenericType<String>(){});
    }

    private BrainspaceObject getBrainspaceObjectFromResponse(Map<String, Object> response) throws IOException {
        BrainspaceObject brainspaceObject = new BrainspaceObject();
        try {
            brainspaceObject.setId(((Number)response.get("id")).longValue());
            brainspaceObject.setName((String)response.get("name"));
            return brainspaceObject;
        }
        catch (Exception e) {
            throw new IOException("Cannot parse response", e);
        }
    }

    public BrainspaceObject createDataset(String name, Set<Long> groupIds, Map sourceDatasetDetails) throws IOException {
        LOGGER.info("Create dataset");
        String url = this.apiUrl + "/dataset";
        HashMap createDatasetRequest = new HashMap();
        createDatasetRequest.put("autoDeploy", sourceDatasetDetails.get("autoDeploy"));
        createDatasetRequest.put("name", name);
        createDatasetRequest.put("autoRunModelsInfo", sourceDatasetDetails.get("autoRunModelsInfo"));
        createDatasetRequest.put("groups", groupIds);
        Map<String, Object> response = this.callApi(url, "POST", createDatasetRequest, new GenericType<Map<String, Object>>(){});
        return this.getBrainspaceObjectFromResponse(response);
    }

    public BrainspaceTagDefinition createSingleChoiceTag(long datasetId, String tagName, Collection<String> choiceValues) throws IOException {
        LOGGER.info("Create dataset");
        String url = this.apiUrl + "/dataset/" + datasetId + "/tag";
        HashMap<String, Object> createTagRequest = new HashMap<String, Object>();
        createTagRequest.put("name", tagName);
        createTagRequest.put("type", "SINGLE_CHOICE");
        createTagRequest.put("choiceValues", choiceValues);
        BrainspaceTagDefinition response = this.callApi(url, "POST", createTagRequest, new GenericType<BrainspaceTagDefinition>(){});
        return response;
    }

    public BrainspaceTagDefinition updateTag(long datasetId, BrainspaceTagDefinition brainspaceTagDefinition, Collection<String> choiceValues) throws IOException {
        LOGGER.info("Create dataset");
        String url = this.apiUrl + "/dataset/" + datasetId + "/tag/" + brainspaceTagDefinition.getId();
        BrainspaceUpdateTagDefinition updateTagDefinition = new BrainspaceUpdateTagDefinition();
        updateTagDefinition.setName(brainspaceTagDefinition.getName());
        updateTagDefinition.setId(brainspaceTagDefinition.getId());
        updateTagDefinition.setType(brainspaceTagDefinition.getType());
        updateTagDefinition.setChoices(new ArrayList<BrainspaceUpdateTagChoice>());
        for (BrainspaceTagChoice existingChoice : brainspaceTagDefinition.getChoices()) {
            BrainspaceUpdateTagChoice updateTagChoice = new BrainspaceUpdateTagChoice();
            updateTagChoice.setChoiceId(existingChoice.getId());
            updateTagChoice.setChoiceValue(existingChoice.getValue());
            updateTagDefinition.getChoices().add(updateTagChoice);
        }
        for (String choiceValue : choiceValues) {
            BrainspaceUpdateTagChoice brainspaceTagChoice = new BrainspaceUpdateTagChoice();
            brainspaceTagChoice.setChoiceValue(choiceValue);
            updateTagDefinition.getChoices().add(brainspaceTagChoice);
        }
        BrainspaceTagDefinition response = this.callApi(url, "PUT", updateTagDefinition, new GenericType<BrainspaceTagDefinition>(){});
        return response;
    }

    public void tagItem(long datasetId, String documentId, long choiceId) throws IOException {
        String url = this.apiUrl + "/dataset/" + datasetId + "/doc/" + documentId + "/tag";
        HashMap<String, Long> tagRequest = new HashMap<String, Long>();
        tagRequest.put("tagChoiceId", choiceId);
        this.callApi(url, "PUT", tagRequest, new GenericType<String>(){});
    }

    public void submitDataset(long datasetId) throws IOException {
        LOGGER.info("Dataset " + datasetId + " submitting");
        String url = this.apiUrl + "/dataset/" + datasetId + "/submit";
        String response = this.callApi(url, "POST", "", new GenericType<String>(){});
    }

    public String getDatasetBuildState(long datasetId) throws IOException {
        String url = this.apiUrl + "/dataset/" + datasetId;
        Map<String, Object> response = this.callApi(url, "GET", new GenericType<Map<String, Object>>(){});
        return String.valueOf(response.get("buildState"));
    }

    public void updateDataset(long datasetId, String name, Set<Long> groupIds, Map sourceDatasetDetails) throws IOException {
        LOGGER.info("Dataset " + datasetId + " updating");
        String url = this.apiUrl + "/dataset/" + datasetId;
        HashMap createDatasetRequest = new HashMap();
        createDatasetRequest.put("autoDeploy", sourceDatasetDetails.get("autoDeploy"));
        createDatasetRequest.put("name", name);
        createDatasetRequest.put("autoRunModelsInfo", sourceDatasetDetails.get("autoRunModelsInfo"));
        createDatasetRequest.put("groups", groupIds);
        Map<String, Object> response = this.callApi(url, "PUT", createDatasetRequest, new GenericType<Map<String, Object>>(){});
    }

    public void setDatasetIngestConfig(long datasetId, Map sourceDatasetIngestConfig) throws IOException {
        LOGGER.info("Dataset " + datasetId + " setting ingest config");
        String url = this.apiUrl + "/dataset/" + datasetId + "/ingest/config";
        this.callApi(url, "PUT", sourceDatasetIngestConfig, new GenericType<String>(){});
    }
}

