/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.cds;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.workflow.core.utils.cds.CdsCopilotApplication;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class AddressUtils {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(AddressUtils.class);
    private static final String MICROSOFT_365_CHAT = "Microsoft 365 Chat";
    private static final Set<InternetAddress> systemAddresses = new HashSet<InternetAddress>(Arrays.asList(AddressUtils.parseAddress("\"System Event\" <systemevent@teams.microsoft.com>"), AddressUtils.parseAddress("Microsoft App <microsoftapp@teams.microsoft.com>"), AddressUtils.parseAddress("\"Microsoft App\" <MicrosoftApp@teams.microsoft.com>")));

    public static Set<InternetAddress> getSystemEventAddresses() {
        return systemAddresses;
    }

    public static InternetAddress fromEmailName(String email, String name) {
        try {
            InternetAddress address = new InternetAddress(email, name);
            return AddressUtils.parseAddressNoSemicolon(AddressUtils.render(address));
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("Cannot create address from email=" + email + ", name=" + name, (Throwable)e);
            return AddressUtils.parseAddressNoSemicolon(email);
        }
    }

    public static InternetAddress parseAddress(String addressText) {
        if (addressText == null || addressText.isEmpty()) {
            return null;
        }
        String[] splits = addressText.split(";");
        if (splits[0].contains("@")) {
            return AddressUtils.parseAddressNoSemicolon(splits[0]);
        }
        if (splits[0].startsWith("Copilot in") && splits.length > 1 && splits[1].contains("@")) {
            return AddressUtils.parseAddressNoSemicolon(splits[1]);
        }
        return AddressUtils.parseAddressNoSemicolon(addressText);
    }

    public static Set<InternetAddress> parseAddresses(String addressesText) {
        if (addressesText == null || addressesText.length() == 0) {
            return new LinkedHashSet<InternetAddress>();
        }
        LinkedHashSet<InternetAddress> addresses = new LinkedHashSet<InternetAddress>();
        StringBuilder word = new StringBuilder();
        boolean detectedAt = false;
        boolean inQuotes = false;
        for (char c : addressesText.toCharArray()) {
            InternetAddress address;
            if (c == '\"') {
                boolean bl = inQuotes = !inQuotes;
            }
            if ((c == ',' || c == ';') && (detectedAt || !inQuotes && word.toString().startsWith("Copilot in")) && (address = AddressUtils.parseAddress(word.toString())) != null) {
                addresses.add(address);
                word = new StringBuilder();
                inQuotes = false;
                detectedAt = false;
                continue;
            }
            if (c == '@') {
                detectedAt = true;
            }
            if (c == ':') {
                detectedAt = true;
            }
            word.append(c);
        }
        InternetAddress address = AddressUtils.parseAddress(word.toString());
        if (address != null) {
            addresses.add(address);
        }
        return addresses;
    }

    public static InternetAddress getCopilotAddress(CdsCopilotApplication copilotApplication) {
        return AddressUtils.getCopilotAddress(copilotApplication.toString());
    }

    public static InternetAddress getCopilotAddress(String appName) {
        String name = "Copilot in " + appName;
        String address = name.replaceAll("[^a-zA-Z0-9]+", "").toLowerCase() + "@teams.microsoft.com";
        return AddressUtils.fromEmailName(address, name);
    }

    private static InternetAddress parseAddressNoSemicolon(String addressText) {
        Object address;
        String secondHalf;
        String firstHalf;
        if (addressText == null || addressText.isEmpty()) {
            return null;
        }
        if (addressText.length() % 2 == 0 && (firstHalf = addressText.substring(0, addressText.length() / 2)).equalsIgnoreCase(secondHalf = addressText.substring(addressText.length() / 2))) {
            addressText = firstHalf;
        }
        boolean detectedAt = false;
        boolean inQuotes = false;
        boolean escaping = false;
        StringBuilder word = new StringBuilder();
        String name = null;
        for (char c : addressText.toCharArray()) {
            if (escaping) {
                escaping = false;
                word.append(c);
                continue;
            }
            if (c == '\\') {
                escaping = true;
                continue;
            }
            if (c == '\"') {
                if (inQuotes) {
                    inQuotes = false;
                    word.append(c);
                    continue;
                }
                inQuotes = true;
                word.append(c);
                continue;
            }
            if (c == ';' && detectedAt) break;
            if (c == '@') {
                detectedAt = true;
            }
            if (c == ':') {
                detectedAt = true;
            }
            if (c == '<' && !inQuotes) {
                name = word.toString().trim();
                word = new StringBuilder();
                continue;
            }
            if (c == '>' && !inQuotes || c == ',' && word.toString().equalsIgnoreCase(MICROSOFT_365_CHAT)) break;
            word.append(c);
        }
        if (MICROSOFT_365_CHAT.equalsIgnoreCase((String)(address = word.toString())) || MICROSOFT_365_CHAT.equalsIgnoreCase(name)) {
            name = "Copilot in Bing";
            address = "copilotinbing@teams.microsoft.com";
        }
        if (name != null && (name = name.trim()).startsWith("\"")) {
            if ((name = name.substring(1)).endsWith("\"")) {
                name = name.substring(0, name.length() - 1);
            }
            name = name.trim();
        }
        if (address != null && ((String)address).startsWith("19:") && (((String)address).endsWith("@thread.v2") || ((String)address).endsWith("@unq.gbl.spaces")) || name != null && name.startsWith("19:") && (name.endsWith("@thread.v2") || name.endsWith("@unq.gbl.spaces")) || address != null && ((String)address).equalsIgnoreCase("System_Event")) {
            address = "SystemEvent@teams.microsoft.com";
            name = "System Event";
        } else if (((String)address).startsWith("28:")) {
            address = "MicrosoftApp@teams.microsoft.com";
            name = "Microsoft App";
        } else if (((String)address).contains(":")) {
            LOGGER.debug("Normalizing address " + (String)address);
            address = ((String)address).replace(":", "_");
        }
        if (!((String)address).contains("@")) {
            if (((String)address).startsWith("Copilot in")) {
                name = address;
                address = ((String)address).replaceAll("[^a-zA-Z0-9]+", "").toLowerCase() + "@teams.microsoft.com";
            } else if (((String)address).length() > 0) {
                address = (String)address + "@unknown";
            }
        }
        if (((String)address).contains(".@")) {
            address = ((String)address).replaceAll("(\\.*@)", "@");
        }
        try {
            if (name != null && !name.equalsIgnoreCase((String)address)) {
                return new InternetAddress((String)address, name);
            }
            return new InternetAddress((String)address);
        }
        catch (AddressException | UnsupportedEncodingException e) {
            String fallbackAddress = addressText.replaceAll("[^a-zA-Z0-9]+", "_") + "@unknown";
            LOGGER.debug("Normalizing address " + (String)address + " to " + fallbackAddress, e);
            try {
                return new InternetAddress(fallbackAddress);
            }
            catch (AddressException ex) {
                return null;
            }
        }
    }

    public static String render(InternetAddress address) {
        if (address == null) {
            return "";
        }
        return address.toUnicodeString();
    }

    public static String renderShort(InternetAddress address) {
        if (address == null) {
            return "";
        }
        if (address.getPersonal() != null && !address.getPersonal().isEmpty()) {
            return address.getPersonal();
        }
        return address.toUnicodeString();
    }

    public static String renderShort(Set<InternetAddress> addresses) {
        if (addresses == null) {
            return "";
        }
        ArrayList<String> renderedAddresses = new ArrayList<String>();
        for (InternetAddress address : addresses) {
            if (address == null) continue;
            renderedAddresses.add(AddressUtils.renderShort(address));
        }
        Collections.sort(renderedAddresses);
        return String.join((CharSequence)", ", renderedAddresses);
    }

    public static String render(Set<InternetAddress> addresses) {
        if (addresses == null) {
            return "";
        }
        ArrayList<String> renderedAddresses = new ArrayList<String>();
        for (InternetAddress address : addresses) {
            if (address == null) continue;
            renderedAddresses.add(AddressUtils.render(address));
        }
        Collections.sort(renderedAddresses);
        return String.join((CharSequence)", ", renderedAddresses);
    }

    public static void logDummyAddresses() {
        ArrayList<String> addresses = new ArrayList<String>();
        addresses.add("19:27dbefab-6cc6-4a5b-a50d-d9efc87fe49d_598c3a3e-f7b3-4418-becc-3015f2cedebe@unq.gbl.spaces;Fred \"The Man\" Smith <fred.smith@nd80.onmicrosoft.com>");
        addresses.add("19:2d48735c69664e86bdc1b419ff1f2c27@thread.v2;\"M\u00fcller, Erika (\u611b, \u85cd)\" <emuller@nd80.onmicrosoft.com>");
        addresses.add("19:473e85374ea84f0f88670168d81128a7@thread.v2;\"M\u00fcller, Erika (\u611b, \u85cd)\" <emuller@nd80.onmicrosoft.com>;Fred \"The Man\" Smith <fred.smith@nd80.onmicrosoft.com>;Johanna@Work Lorenz <JohannaL@nd80.onmicrosoft.com>");
        addresses.add("19:598c3a3e-f7b3-4418-becc-3015f2cedebe_0c5cfdbb-596f-4d39-b557-5d9516c94107@unq.gbl.spaces");
        addresses.add("19:598c3a3e-f7b3-4418-becc-3015f2cedebe_658902c0-c52e-4564-ac59-f1b8cbb7ceed@unq.gbl.spaces;\"Semicolon; Colon, John\" <john.scc@nd80.onmicrosoft.com>");
        addresses.add("emuller@nd80.onmicrosoft.com <emuller@nd80.onmicrosoft.com>");
        addresses.add("Microsoft Teams <noreply@email.teams.microsoft.com>");
        addresses.add("Semicolon; Colon, John <john.scc@nd80.onmicrosoft.com>");
        for (String address : addresses) {
            InternetAddress result = AddressUtils.parseAddress(address);
            LOGGER.info("Source: " + address);
            if (result == null) {
                LOGGER.info("\tEmail: NULL");
            } else {
                LOGGER.info("\tEmail: " + result.getAddress());
                LOGGER.info("\tName: " + result.getPersonal());
                LOGGER.info("\tFull: " + AddressUtils.render(result));
            }
            LOGGER.info("=====================");
        }
        ArrayList<String> multipleAddresses = new ArrayList<String>();
        multipleAddresses.add("\"M\u00fcller, Erika (\u611b, \u85cd)\" <emuller@nd80.onmicrosoft.com>,\"Vance, Adele-\u00c9milie (\u611b, \u85cd)\" <AdeleV@nd80.onmicrosoft.com>,\"Wilber, Alex-Fran\u00e7ois\" <AlexW@nd80.onmicrosoft.com>");
        multipleAddresses.add("\"M\u00fcller, Erika (\u611b, \u85cd)\" <emuller@nd80.onmicrosoft.com>,28:0c5cfdbb-596f-4d39-b557-5d9516c94107");
        multipleAddresses.add("\"M\u00fcller, Erika (\u611b, \u85cd)\" <emuller@nd80.onmicrosoft.com>,Fred \"The Man\" Smith <fred.smith@nd80.onmicrosoft.com>,Johanna@Work Lorenz <JohannaL@nd80.onmicrosoft.com>,\"Semicolon, Colon, John\" <john.scc@nd80.onmicrosoft.com>");
        multipleAddresses.add("\"Semicolon, Colon, John\" <john.scc@nd80.onmicrosoft.com>,\"M\u00fcller, Erika (\u611b, \u85cd)\" <emuller@nd80.onmicrosoft.com>");
        multipleAddresses.add("Fred \"The Man\" Smith <fred.smith@nd80.onmicrosoft.com>,\"M\u00fcller, Erika (\u611b, \u85cd)\" <emuller@nd80.onmicrosoft.com>");
        multipleAddresses.add("M\u00fcller, Erika (\u611b, \u85cd) <emuller@nd80.onmicrosoft.com>");
        multipleAddresses.add("M\u00fcller, Erika (\u611b, \u85cd) <emuller@nd80.onmicrosoft.com>,Vance, Adele-\u00c9milie (\u611b, \u85cd) <AdeleV@nd80.onmicrosoft.com>,Johanna@Work Lorenz <JohannaL@nd80.onmicrosoft.com>,Fred \"The Man\" Smith <fred.smith@nd80.onmicrosoft.com>");
        multipleAddresses.add("M\u00fcller, Erika (\u611b, \u85cd) <emuller@nd80.onmicrosoft.com>,Vance, Adele-\u00c9milie (\u611b, \u85cd) <AdeleV@nd80.onmicrosoft.com>,Johanna@Work Lorenz <JohannaL@nd80.onmicrosoft.com>,Fred \"The Man\" Smith <fred.smith@nd80.onmicrosoft.com>,Semicolon; Colon, John <john.scc@nd80.onmicrosoft.com>");
        for (String multipleAddress : multipleAddresses) {
            Set<InternetAddress> result = AddressUtils.parseAddresses(multipleAddress);
            LOGGER.info("Multiple Address Source: " + multipleAddress);
            int i = 0;
            for (InternetAddress r : result) {
                if (i > 0) {
                    LOGGER.info("\t---");
                }
                ++i;
                LOGGER.info("\tEmail: " + r.getAddress());
                LOGGER.info("\tName: " + r.getPersonal());
                LOGGER.info("\tFull: " + AddressUtils.render(r));
            }
            LOGGER.info("=====================");
        }
    }
}

