/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.cds;

import au.com.bytecode.opencsv.CSVReader;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.workflow.core.utils.cds.CdsUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class CdsExportFile
implements Closeable {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(CdsExportFile.class);
    private Path path;
    private String name;
    private String loadfileName;
    private List<String> headers;
    private Set<String> custodians;
    private long recordCount;

    public abstract InputStream getInputStream(String var1) throws IOException;

    public abstract Long getSize(String var1) throws IOException;

    public abstract Long getCrc(String var1) throws IOException;

    public abstract void findAndSetLoadfile(String var1) throws IOException;

    public abstract FileTime getFileTime() throws IOException;

    public InputStream getLoadfileInputStream() throws IOException {
        return this.getInputStream(this.loadfileName);
    }

    public void populateHeadersAndCustodians(String custodianColumnName) throws IOException {
        try (CSVReader csvReader = CdsUtils.buildCsvReader(this.getLoadfileInputStream());){
            this.headers = Arrays.asList(csvReader.readNext());
            this.custodians = new HashSet<String>();
            int custodianColumnIndex = this.headers.indexOf(custodianColumnName);
            if (custodianColumnIndex > 0) {
                String[] row;
                while ((row = csvReader.readNext()) != null) {
                    ++this.recordCount;
                    String custodian = row[custodianColumnIndex];
                    if (custodian == null) continue;
                    this.custodians.add(custodian);
                }
            }
        }
    }

    protected FileTime getEarliestFileTime(FileTime creationTime, FileTime lastModifiedTime) {
        if (lastModifiedTime == null || creationTime != null && creationTime.compareTo(lastModifiedTime) < 0) {
            return creationTime;
        }
        return lastModifiedTime;
    }

    @Override
    public void close() throws IOException {
    }

    public Path getPath() {
        return this.path;
    }

    public String getName() {
        return this.name;
    }

    public String getLoadfileName() {
        return this.loadfileName;
    }

    public List<String> getHeaders() {
        return this.headers;
    }

    public Set<String> getCustodians() {
        return this.custodians;
    }

    public long getRecordCount() {
        return this.recordCount;
    }

    public void setPath(Path path) {
        this.path = path;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLoadfileName(String loadfileName) {
        this.loadfileName = loadfileName;
    }

    public void setHeaders(List<String> headers) {
        this.headers = headers;
    }

    public void setCustodians(Set<String> custodians) {
        this.custodians = custodians;
    }

    public void setRecordCount(long recordCount) {
        this.recordCount = recordCount;
    }
}

