/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.cds;

import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.workflow.core.utils.cds.CdsExportFile;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;

public class CdsExportFolder
extends CdsExportFile {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(CdsExportFolder.class);

    public CdsExportFolder(Path path) {
        this.setName(path.getFileName().toString());
        this.setPath(path);
    }

    @Override
    public InputStream getInputStream(String fileName) throws IOException {
        Path filePath = FileUtils.safeResolveParent((Path)this.getPath(), (String[])new String[]{fileName});
        if (!Files.isDirectory(filePath, new LinkOption[0]) && Files.exists(filePath, new LinkOption[0])) {
            return Files.newInputStream(filePath, new OpenOption[0]);
        }
        LOGGER.error("Export does not contain file: " + fileName);
        return null;
    }

    @Override
    public Long getSize(String fileName) throws IOException {
        return null;
    }

    @Override
    public Long getCrc(String fileName) throws IOException {
        return null;
    }

    @Override
    public void findAndSetLoadfile(String loadfileRegex) {
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(this.getPath());){
            for (Path filePath : dirStream) {
                if (Files.isDirectory(filePath, new LinkOption[0])) continue;
                LOGGER.debug("Detected path entry: " + String.valueOf(filePath));
                if (!filePath.getFileName().toString().matches(loadfileRegex)) continue;
                this.setLoadfileName(filePath.getFileName().toString());
                break;
            }
        }
        catch (IOException e) {
            LOGGER.error("Error reading path: " + String.valueOf(this.getPath()), (Throwable)e);
        }
        if (this.getLoadfileName() == null) {
            LOGGER.error("Failed to set loadfile name with regex: " + loadfileRegex);
        }
    }

    @Override
    public FileTime getFileTime() throws IOException {
        Path loadfilePath = this.getPath().resolve(this.getLoadfileName());
        BasicFileAttributes attr = Files.readAttributes(loadfilePath, BasicFileAttributes.class, new LinkOption[0]);
        FileTime creationTime = attr.creationTime();
        FileTime lastModifiedTime = attr.lastModifiedTime();
        return this.getEarliestFileTime(creationTime, lastModifiedTime);
    }
}

