/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.cds;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.workflow.core.utils.cds.AddressUtils;
import com.nuix.automate.workflow.core.utils.cds.CdsAttachmentType;
import com.nuix.automate.workflow.core.utils.cds.CdsConversationMimeType;
import com.nuix.automate.workflow.core.utils.cds.CdsConversationReaction;
import com.nuix.automate.workflow.core.utils.cds.CdsConversationSource;
import com.nuix.automate.workflow.core.utils.cds.CdsCopilotApplication;
import com.nuix.automate.workflow.core.utils.cds.CdsFileClassType;
import com.nuix.automate.workflow.core.utils.cds.CdsSystemMessageType;
import com.nuix.automate.workflow.core.utils.cds.CdsTeamsMessageType;
import com.nuix.automate.workflow.core.utils.cds.CdsUtils;
import com.nuix.automate.workflow.core.utils.loadfile.LoadfileItem;
import jakarta.mail.internet.InternetAddress;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class CdsItem
implements Cloneable {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(CdsItem.class);
    private static final String HTML_MIMEATT_EXTENSION_REGEX = ".*?\\.html-mimeatt[a-zA-Z0-9-]*$";
    private static final String MSG_CARD_ATTACHMENT = ".*?(Copilot\\sin\\s[a-zA-Z]+|Card)\\.html.*?$";
    private static final String COPILOT_ITEM_CLASS_PREFIX = "ipm.skypeteams.message.copilot.";
    private CdsFileClassType fileClass;
    private String itemClass;
    private String documentId;
    private String immutableId;
    private String familyId;
    private String fileId;
    private String parentId;
    private String locationName;
    private String location;
    private String path;
    private String nativeExportPath;
    private String fileLocation;
    private String fileExtension;
    private String modernParentId;
    private String inputPath;
    private String hash;
    private String subjectLine;
    private CdsTeamsMessageType teamsMessageType;
    private CdsCopilotApplication copilotApplication;
    private Set<String> copilotLinks;
    private InternetAddress sender;
    private Set<InternetAddress> recipients;
    private String messageKind;
    private String conversationId;
    private String conversationType;
    private String internetMessageId;
    private String content;
    private String systemMessageId;
    private String clientMessageId;
    private String parentConversationId;
    private Set<String> parentMessageIds;
    private List<String> messageAttachmentPaths = new ArrayList<String>();
    private CdsConversationMimeType conversationMimeType;
    private CdsConversationSource conversationSource;
    private List<CdsConversationReaction> reactions = new ArrayList<CdsConversationReaction>();
    private String originalMessageId;
    private String messageRevision;
    private CdsSystemMessageType systemMessageType;
    private int systemMessageScope = -1;
    private String callId;
    private String callStartTime;
    private String callEndTime;
    private String callDuration;
    private String recordingName;
    private String recordingFileName;
    private String amsVideoUrl;
    private String amsTranscriptUrl;
    private String videoExportUrl;
    private String recordingDuration;
    private String custodian;
    private CdsAttachmentType attachmentType;
    private String teamName;
    private String channelName;
    private InternetAddress teamAddress;
    private DateTime date;
    private DateTime documentCreatedDateTime;
    private DateTime documentLastModified;
    private DateTime deletedDateTime;
    private String failureDetail;
    private String failureMessage;
    private boolean deleted;
    private String messageRefId;
    private boolean isDuplicateItem;
    private List<Map.Entry<String, byte[]>> embeddedAttachments;

    public CdsItem() {
        this.parentMessageIds = new LinkedHashSet<String>();
        this.copilotLinks = new LinkedHashSet<String>();
    }

    public void setItemClass(String itemClass) {
        this.itemClass = itemClass;
        if (this.isItemClassSystemMessage()) {
            this.setSystemMessageType(CdsSystemMessageType.SYSTEM_MESSAGE);
        }
    }

    public void updateItemLocation() {
        switch (this.fileClass) {
            default: {
                if (this.fileLocation.equalsIgnoreCase("SharePoint")) {
                    this.location = CdsUtils.getFormattedSharePointLocation(this.path, this.custodian);
                    break;
                }
                this.location = CdsUtils.getFormattedExchangeLocation(this.path, this.locationName, this.custodian, this.itemClass);
                break;
            }
            case CONVERSATION: {
                this.location = CdsUtils.getFormattedConversationLocation(this);
            }
        }
    }

    public void setTeamsMessageTypeFromParent(CdsTeamsMessageType parentMessageType) {
        this.setTeamsMessageType(this.getTeamsMessageTypeFromParent(parentMessageType));
    }

    public CdsTeamsMessageType getTeamsMessageTypeFromParent(CdsTeamsMessageType parentMessageType) {
        if (this.isSystemMessage()) {
            return CdsTeamsMessageType.TEAMS_SYSTEM_MESSAGE;
        }
        if (parentMessageType == CdsTeamsMessageType.COPILOT_CONVERSATION) {
            if (this.getSender().getAddress().toLowerCase().contains("@teams.microsoft.com")) {
                return CdsTeamsMessageType.COPILOT_ANSWER;
            }
            return CdsTeamsMessageType.COPILOT_QUESTION;
        }
        if (parentMessageType == CdsTeamsMessageType.YAMMER_CONVERSATION) {
            switch (this.getConversationMimeType()) {
                default: {
                    return CdsTeamsMessageType.YAMMER_MESSAGE;
                }
                case YAMMER_QUESTION: {
                    return CdsTeamsMessageType.YAMMER_QUESTION;
                }
                case YAMMER_ANSWER: 
            }
            return CdsTeamsMessageType.YAMMER_ANSWER;
        }
        if (parentMessageType == CdsTeamsMessageType.TEAMS_CHANNEL_CONVERSATION) {
            return CdsTeamsMessageType.TEAMS_CHANNEL_MESSAGE;
        }
        return CdsTeamsMessageType.TEAMS_CHAT_MESSAGE;
    }

    public boolean isMsg() {
        return this.fileExtension.equalsIgnoreCase("msg") || this.fileExtension.equalsIgnoreCase(".msg");
    }

    public boolean isHtml() {
        return this.fileExtension.equalsIgnoreCase("html") || this.fileExtension.equalsIgnoreCase(".html");
    }

    public boolean isYammerItem() {
        return this.messageKind.equalsIgnoreCase("yammer");
    }

    public boolean isChannelItem() {
        return this.conversationType.equalsIgnoreCase("channel") || this.conversationType.equalsIgnoreCase("team") || this.conversationType.equalsIgnoreCase("topic") || this.conversationType.equalsIgnoreCase("space");
    }

    public boolean isCopilotItem() {
        return this.itemClass.toLowerCase().startsWith(COPILOT_ITEM_CLASS_PREFIX);
    }

    public boolean isCopilotConversation() {
        return this.teamsMessageType == CdsTeamsMessageType.COPILOT_CONVERSATION;
    }

    public boolean isConversation() {
        return this.teamsMessageType == CdsTeamsMessageType.TEAMS_CONVERSATION_ONE || this.teamsMessageType == CdsTeamsMessageType.TEAMS_CONVERSATION_MANY || this.teamsMessageType == CdsTeamsMessageType.TEAMS_CHANNEL_CONVERSATION;
    }

    public boolean isItemClassSystemMessage() {
        return this.itemClass.equalsIgnoreCase("IPM.SkypeTeams.SystemMessage");
    }

    public boolean isMeetingOrCall() {
        return this.itemClass.equalsIgnoreCase("IPM.AppointmentSnapshot.SkypeTeams.Meeting") || this.itemClass.equalsIgnoreCase("IPM.AppointmentSnapshot.SkypeTeams.Call");
    }

    public boolean isIgnorableAttachment() {
        return this.fileClass == CdsFileClassType.ATTACHMENT && (this.immutableId.matches(HTML_MIMEATT_EXTENSION_REGEX) || this.inputPath.matches(MSG_CARD_ATTACHMENT));
    }

    public boolean isModernAttachment() {
        return !this.modernParentId.isEmpty();
    }

    public CdsItem clone() {
        try {
            CdsItem clone = (CdsItem)super.clone();
            clone.messageAttachmentPaths = new ArrayList<String>();
            if (this.messageAttachmentPaths != null) {
                clone.messageAttachmentPaths.addAll(this.messageAttachmentPaths);
            }
            clone.reactions = new ArrayList<CdsConversationReaction>();
            if (this.reactions != null) {
                clone.reactions.addAll(this.reactions);
            }
            clone.parentMessageIds = new LinkedHashSet<String>();
            if (this.parentMessageIds != null) {
                clone.parentMessageIds.addAll(this.parentMessageIds);
            }
            clone.copilotLinks = new LinkedHashSet<String>();
            if (this.copilotLinks != null) {
                clone.copilotLinks.addAll(this.copilotLinks);
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public String getLocation() {
        if (this.subjectLine != null && !this.subjectLine.isEmpty() && this.location != null && this.location.endsWith(this.subjectLine)) {
            String locationPrefix = this.location.substring(0, this.location.length() - this.subjectLine.length());
            return locationPrefix + this.subjectLine.replace(LoadfileItem.FS, LoadfileItem.INTERNALLY_ENCODED_FS);
        }
        return this.location;
    }

    public void setLocation(String parent, String ... children) {
        StringBuilder locationBuilder = new StringBuilder(parent);
        for (String child : children) {
            locationBuilder.append("/").append(LoadfileItem.encodeFs(child));
        }
        this.location = locationBuilder.toString();
    }

    public String getFileId() {
        return this.fileId;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    public void setCopilotLinks(Set<String> copilotLinks) {
        this.copilotLinks = copilotLinks;
    }

    public void setDocumentId(String documentId) {
        this.documentId = documentId;
    }

    public void setImmutableId(String immutableId) {
        this.immutableId = immutableId;
    }

    public void setFamilyId(String familyId) {
        this.familyId = familyId;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setNativeExportPath(String nativeExportPath) {
        this.nativeExportPath = nativeExportPath;
    }

    public void setFileClass(CdsFileClassType fileClass) {
        this.fileClass = fileClass;
    }

    public void setModernParentId(String modernParentId) {
        this.modernParentId = modernParentId;
    }

    public void setInputPath(String inputPath) {
        this.inputPath = inputPath;
    }

    public void setSubjectLine(String subjectLine) {
        this.subjectLine = subjectLine;
    }

    public void setTeamsMessageType(CdsTeamsMessageType teamsMessageType) {
        this.teamsMessageType = teamsMessageType;
    }

    public void updateCopilotApplication() {
        this.setCopilotApplication(CdsCopilotApplication.fromItemClass(this.itemClass));
    }

    public void setCopilotApplication(CdsCopilotApplication copilotApplication) {
        if (copilotApplication == null) {
            copilotApplication = CdsCopilotApplication.UNKNOWN;
        }
        this.copilotApplication = copilotApplication;
        if (copilotApplication == CdsCopilotApplication.UNKNOWN) {
            LOGGER.warn("Found new Copilot type " + String.valueOf(this.itemClass));
        }
    }

    public void setSender(InternetAddress sender) {
        this.sender = sender;
        if (this.recipients != null && sender != null) {
            this.recipients.remove(sender);
        }
    }

    public void formatAndSetConversationId(String conversationId) {
        this.setConversationId(CdsUtils.getFormattedConversationId(conversationId));
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setSystemMessageId(String systemMessageId) {
        this.systemMessageId = systemMessageId;
    }

    public void setClientMessageId(String clientMessageId) {
        this.clientMessageId = clientMessageId;
    }

    public void setParentConversationId(String parentConversationId) {
        this.parentConversationId = parentConversationId;
    }

    public void setParentMessageIds(Set<String> parentMessageIds) {
        this.parentMessageIds = parentMessageIds;
    }

    public void setMessageAttachmentPaths(List<String> messageAttachmentPaths) {
        this.messageAttachmentPaths = messageAttachmentPaths;
    }

    public void setConversationMimeType(CdsConversationMimeType conversationMimeType) {
        this.conversationMimeType = conversationMimeType;
    }

    public void setConversationSource(CdsConversationSource conversationSource) {
        this.conversationSource = conversationSource;
    }

    public void setReactions(List<CdsConversationReaction> reactions) {
        this.reactions = reactions;
    }

    public void setOriginalMessageId(String originalMessageId) {
        this.originalMessageId = originalMessageId;
    }

    public boolean isSystemMessage() {
        return this.systemMessageType != null;
    }

    public void setSystemMessageType(CdsSystemMessageType systemMessageType) {
        this.systemMessageType = systemMessageType;
    }

    public void setSystemMessageScope(int systemMessageScope) {
        this.systemMessageScope = systemMessageScope;
    }

    public void setMessageRevision(String messageRevision) {
        this.messageRevision = messageRevision;
    }

    public void setCallId(String callId) {
        this.callId = callId;
    }

    public void setCallStartTime(String callStartTime) {
        this.callStartTime = callStartTime;
    }

    public void setCallEndTime(String callEndTime) {
        this.callEndTime = callEndTime;
    }

    public void setCallDuration(String callDuration) {
        this.callDuration = callDuration;
    }

    public void setRecordingName(String recordingName) {
        this.recordingName = recordingName;
    }

    public void setRecordingFileName(String recordingFileName) {
        this.recordingFileName = recordingFileName;
    }

    public void setAmsVideoUrl(String amsVideoUrl) {
        this.amsVideoUrl = amsVideoUrl;
    }

    public void setAmsTranscriptUrl(String amsTranscriptUrl) {
        this.amsTranscriptUrl = amsTranscriptUrl;
    }

    public void setVideoExportUrl(String videoExportUrl) {
        this.videoExportUrl = videoExportUrl;
    }

    public void setRecordingDuration(String recordingDuration) {
        this.recordingDuration = recordingDuration;
    }

    public void setCustodian(String custodian) {
        this.custodian = custodian;
    }

    public void setAttachmentType(CdsAttachmentType attachmentType) {
        this.attachmentType = attachmentType;
    }

    public String getPrintableDate() {
        if (this.date == null) {
            return "[N/A]";
        }
        return this.date.withZone(DateTimeZone.UTC).toString();
    }

    public void setDate(String date) {
        this.setDate(CdsUtils.parseDateFromLoadFile(date));
    }

    public void setDate(DateTime date) {
        this.date = date;
    }

    public void setDocumentCreatedDateTime(String date) {
        this.setDocumentCreatedDateTime(CdsUtils.parseDateFromLoadFile(date));
    }

    public void setDocumentCreatedDateTime(DateTime documentCreatedDateTime) {
        this.documentCreatedDateTime = documentCreatedDateTime;
    }

    public void setDocumentLastModified(String date) {
        this.setDocumentLastModified(CdsUtils.parseDateFromLoadFile(date));
    }

    public void setDocumentLastModified(DateTime documentLastModified) {
        this.documentLastModified = documentLastModified;
    }

    public void setDeletedDateTime(DateTime deletedDateTime) {
        this.deletedDateTime = deletedDateTime;
    }

    public void setTeamName(String teamName) {
        this.teamName = teamName;
    }

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }

    public void setTeamAndChannelName(String teamName, String channelName) {
        this.setTeamName(teamName);
        this.setChannelName(channelName);
        this.updateChannelNameIfGeneral();
    }

    public void updateChannelNameIfGeneral() {
        if (this.teamName != null && this.teamName.equalsIgnoreCase(this.channelName)) {
            this.setChannelName("General");
        }
    }

    public Set<InternetAddress> getParticipants() {
        LinkedHashSet<InternetAddress> participants = new LinkedHashSet<InternetAddress>();
        if (this.sender != null) {
            participants.add(this.sender);
        }
        if (this.recipients != null) {
            participants.addAll(this.recipients);
        }
        participants.removeAll(AddressUtils.getSystemEventAddresses());
        return participants;
    }

    public void setRecipients(Set<InternetAddress> recipients) {
        this.recipients = new LinkedHashSet<InternetAddress>();
        if (recipients != null) {
            this.recipients.addAll(recipients);
        }
        if (this.sender != null) {
            this.recipients.remove(this.sender);
        }
    }

    public int getNonSystemParticipantsCount() {
        return this.getParticipants().size();
    }

    public int getNonSystemRecipientsCount() {
        HashSet<InternetAddress> evenRecipients = new HashSet<InternetAddress>(this.getParticipants());
        if (this.sender != null) {
            evenRecipients.remove(this.sender);
        }
        return evenRecipients.size();
    }

    public void setTeamAddress(InternetAddress teamAddress) {
        this.teamAddress = teamAddress;
    }

    public void addEmbeddedAttachment(String filename, byte[] content) {
        if (this.embeddedAttachments == null) {
            this.embeddedAttachments = new ArrayList<Map.Entry<String, byte[]>>();
        }
        AbstractMap.SimpleEntry<String, byte[]> attachment = new AbstractMap.SimpleEntry<String, byte[]>(filename, content);
        this.embeddedAttachments.add(attachment);
    }

    public void setEmbeddedAttachments(List<Map.Entry<String, byte[]>> embeddedAttachments) {
        this.embeddedAttachments = embeddedAttachments;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public String getInternetMessageId() {
        return this.internetMessageId;
    }

    public void setInternetMessageId(String internetMessageId) {
        this.internetMessageId = internetMessageId;
    }

    public String getMessageRefId() {
        return this.messageRefId;
    }

    public void setMessageRefId(String messageRefId) {
        this.messageRefId = messageRefId;
    }

    public boolean isDuplicateItem() {
        return this.isDuplicateItem;
    }

    public void setDuplicateItem(boolean duplicateItem) {
        this.isDuplicateItem = duplicateItem;
    }

    public CdsFileClassType getFileClass() {
        return this.fileClass;
    }

    public String getItemClass() {
        return this.itemClass;
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public String getImmutableId() {
        return this.immutableId;
    }

    public String getFamilyId() {
        return this.familyId;
    }

    public String getLocationName() {
        return this.locationName;
    }

    public String getPath() {
        return this.path;
    }

    public String getNativeExportPath() {
        return this.nativeExportPath;
    }

    public String getFileLocation() {
        return this.fileLocation;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public String getModernParentId() {
        return this.modernParentId;
    }

    public String getInputPath() {
        return this.inputPath;
    }

    public String getSubjectLine() {
        return this.subjectLine;
    }

    public CdsTeamsMessageType getTeamsMessageType() {
        return this.teamsMessageType;
    }

    public CdsCopilotApplication getCopilotApplication() {
        return this.copilotApplication;
    }

    public Set<String> getCopilotLinks() {
        return this.copilotLinks;
    }

    public InternetAddress getSender() {
        return this.sender;
    }

    public Set<InternetAddress> getRecipients() {
        return this.recipients;
    }

    public String getMessageKind() {
        return this.messageKind;
    }

    public String getConversationId() {
        return this.conversationId;
    }

    public String getConversationType() {
        return this.conversationType;
    }

    public String getContent() {
        return this.content;
    }

    public String getSystemMessageId() {
        return this.systemMessageId;
    }

    public String getClientMessageId() {
        return this.clientMessageId;
    }

    public String getParentConversationId() {
        return this.parentConversationId;
    }

    public Set<String> getParentMessageIds() {
        return this.parentMessageIds;
    }

    public List<String> getMessageAttachmentPaths() {
        return this.messageAttachmentPaths;
    }

    public CdsConversationMimeType getConversationMimeType() {
        return this.conversationMimeType;
    }

    public CdsConversationSource getConversationSource() {
        return this.conversationSource;
    }

    public List<CdsConversationReaction> getReactions() {
        return this.reactions;
    }

    public String getOriginalMessageId() {
        return this.originalMessageId;
    }

    public String getMessageRevision() {
        return this.messageRevision;
    }

    public CdsSystemMessageType getSystemMessageType() {
        return this.systemMessageType;
    }

    public int getSystemMessageScope() {
        return this.systemMessageScope;
    }

    public String getCallId() {
        return this.callId;
    }

    public String getCallStartTime() {
        return this.callStartTime;
    }

    public String getCallEndTime() {
        return this.callEndTime;
    }

    public String getCallDuration() {
        return this.callDuration;
    }

    public String getRecordingName() {
        return this.recordingName;
    }

    public String getRecordingFileName() {
        return this.recordingFileName;
    }

    public String getAmsVideoUrl() {
        return this.amsVideoUrl;
    }

    public String getAmsTranscriptUrl() {
        return this.amsTranscriptUrl;
    }

    public String getVideoExportUrl() {
        return this.videoExportUrl;
    }

    public String getRecordingDuration() {
        return this.recordingDuration;
    }

    public String getCustodian() {
        return this.custodian;
    }

    public CdsAttachmentType getAttachmentType() {
        return this.attachmentType;
    }

    public String getTeamName() {
        return this.teamName;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public InternetAddress getTeamAddress() {
        return this.teamAddress;
    }

    public DateTime getDate() {
        return this.date;
    }

    public DateTime getDocumentCreatedDateTime() {
        return this.documentCreatedDateTime;
    }

    public DateTime getDocumentLastModified() {
        return this.documentLastModified;
    }

    public DateTime getDeletedDateTime() {
        return this.deletedDateTime;
    }

    public String getFailureDetail() {
        return this.failureDetail;
    }

    public String getFailureMessage() {
        return this.failureMessage;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public List<Map.Entry<String, byte[]>> getEmbeddedAttachments() {
        return this.embeddedAttachments;
    }

    public void setLocationName(String locationName) {
        this.locationName = locationName;
    }

    public void setFileLocation(String fileLocation) {
        this.fileLocation = fileLocation;
    }

    public void setFileExtension(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    public void setMessageKind(String messageKind) {
        this.messageKind = messageKind;
    }

    public void setConversationType(String conversationType) {
        this.conversationType = conversationType;
    }

    public void setFailureDetail(String failureDetail) {
        this.failureDetail = failureDetail;
    }

    public void setFailureMessage(String failureMessage) {
        this.failureMessage = failureMessage;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }
}

