/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.cds;

public enum CdsSystemMessageType {
    SYSTEM_MESSAGE("systemMessageDetail", ""),
    CALL_ENDED("callEndedEventMessageDetail", ""),
    CALL_RECORDING("callRecordingEventMessageDetail", ""),
    CALL_STARTED("callStartedEventMessageDetail", ""),
    CALL_TRANSCRIPT("callTranscriptEventMessageDetail", ""),
    CHANNEL_ADDED("channelAddedEventMessageDetail", "SpaceThreadChannelAdded"),
    CHANNEL_DELETED("channelDeletedEventMessageDetail", "SpaceThreadChannelDeleted"),
    CHANNEL_DESCRIPTION_UPDATED("channelDescriptionUpdatedEventMessageDetail", "TopicDescriptionUpdated"),
    CHANNEL_RENAMED("channelRenamedEventMessageDetail", "SpaceThreadChannelRenamed"),
    CHANNEL_SHARED("channelSharingUpdatedEventMessageDetail", "ThreadShared"),
    CHANNEL_SET_AS_FAVOURITE("channelSetAsFavoriteByDefaultEventMessageDetail", "UpdateFavDefault"),
    CHANNEL_UNSET_AS_FAVOURITE("channelUnsetAsFavoriteByDefaultEventMessageDetail", ""),
    CHAT_RENAMED("chatRenamedEventMessageDetail", "TopicUpdate"),
    CONVERSATION_ROLE_MEMBER_UPDATED("conversationMemberRoleUpdatedEventMessageDetail", "RoleUpdate"),
    MEETING_POLICY_UPDATED("meetingPolicyUpdatedEventMessageDetail", "MeetingPolicyUpdated"),
    MEMBERS_ADDED("membersAddedEventMessageDetail", "AddMember"),
    MEMBERS_DELETED("membersDeletedEventMessageDetail", "DeleteMember"),
    MEMBERS_JOINED("membersJoinedEventMessageDetail", "MemberJoined"),
    MEMBERS_LEFT("membersLeftEventMessageDetail", "MemberLeft"),
    MESSAGE_PINNED("messagePinnedEventMessageDetail", "PinnedItemsUpdate"),
    MESSAGE_UNPINNED("messageUnpinnedEventMessageDetail", ""),
    TAB_UPDATED("tabUpdatedEventMessageDetail", "TabUpdated"),
    TEAM_CREATED("teamCreatedEventMessageDetail", ""),
    TEAM_ARCHIVED("teamArchivedEventMessageDetail", "ThreadArchivalUpdate"),
    TEAM_UNARCHIVED("teamUnarchivedEventMessageDetail", ""),
    TEAM_JOINING_ENABLED("teamJoiningEnabledEventMessageDetail", "JoiningEnabledUpdate"),
    TEAM_JOINING_DISABLED("teamJoiningDisabledEventMessageDetail", ""),
    TEAM_DESCRIPTION_UPDATED("teamDescriptionUpdatedEventMessageDetail", "SpaceDescriptionUpdated"),
    TEAM_RENAMED("teamRenamedEventMessageDetail", "SpaceTopicUpdated"),
    TEAMS_APP_INSTALLED("teamsAppInstalledEventMessageDetail", "AddCustomApp"),
    TEAMS_APP_REMOVED("teamsAppRemovedEventMessageDetail", "DeleteCustomApp"),
    TEAMS_APP_UPGRADED("teamsAppUpgradedEventMessageDetail", "UpgradeCustomApp"),
    GENERIC("unknownEventMessageDetail", "");

    String eventName;
    String shortName;

    private CdsSystemMessageType(String eventName, String shortName) {
        this.eventName = eventName;
        this.shortName = shortName;
    }

    public static CdsSystemMessageType getType(String shortName) {
        for (CdsSystemMessageType type : CdsSystemMessageType.values()) {
            if (!shortName.equalsIgnoreCase(type.shortName)) continue;
            return type;
        }
        return GENERIC;
    }

    public static String getSystemMessageContent(CdsSystemMessageType type, int conversationLevel) {
        String scope = "";
        if (conversationLevel == 0) {
            scope = "Team";
        } else if (conversationLevel == 1) {
            scope = "Channel";
        } else if (conversationLevel == 2) {
            scope = "Chat";
        }
        switch (type.ordinal()) {
            case 1: {
                return "Call ended";
            }
            case 2: {
                return "Call recording has started";
            }
            case 3: {
                return "Call started";
            }
            case 4: {
                return "Call transcript generated";
            }
            case 5: {
                return "Channel added";
            }
            case 6: {
                return "Channel deleted";
            }
            case 7: {
                return "Channel description updated";
            }
            case 8: {
                return "Channel renamed";
            }
            case 10: {
                return "Channel set as favourite";
            }
            case 9: {
                return "Channel shared";
            }
            case 11: {
                return "Channel unset as favourite";
            }
            case 12: {
                return "Chat renamed";
            }
            case 13: {
                return scope + " conversation member role updated";
            }
            case 14: {
                return "Meeting policy updated";
            }
            case 15: {
                return scope + " members added";
            }
            case 16: {
                return scope + " members deleted";
            }
            case 17: {
                return "Members joined";
            }
            case 18: {
                return "Members left";
            }
            case 19: {
                return "Message pinned";
            }
            case 20: {
                return "Message unpinned";
            }
            case 21: {
                return scope + " tab updated";
            }
            case 23: {
                return "Team archived";
            }
            case 22: {
                return "Team created";
            }
            case 27: {
                return "Team description updated";
            }
            case 26: {
                return "Team joining disabled";
            }
            case 25: {
                return "Team joining enabled";
            }
            case 28: {
                return "Team renamed";
            }
            case 29: {
                return scope + " teams app installed";
            }
            case 30: {
                return scope + " teams app removed";
            }
            case 31: {
                return scope + " teams app upgraded";
            }
            case 24: {
                return "Team unarchived";
            }
        }
        return "system message event";
    }

    public String getEventName() {
        return this.eventName;
    }
}

