/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.cds;

import au.com.bytecode.opencsv.CSVReader;
import com.aspose.email.MailMessage;
import com.aspose.email.MapiAttachment;
import com.aspose.email.MapiMessage;
import com.aspose.email.MapiProperty;
import com.aspose.email.MapiPropertyCollection;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.workflow.core.utils.cds.AddressUtils;
import com.nuix.automate.workflow.core.utils.cds.CdsConversation;
import com.nuix.automate.workflow.core.utils.cds.CdsConversationMimeType;
import com.nuix.automate.workflow.core.utils.cds.CdsCopilotApplication;
import com.nuix.automate.workflow.core.utils.cds.CdsCustomMetadata;
import com.nuix.automate.workflow.core.utils.cds.CdsFileClassType;
import com.nuix.automate.workflow.core.utils.cds.CdsItem;
import com.nuix.automate.workflow.core.utils.cds.CdsSystemMessageType;
import com.nuix.automate.workflow.core.utils.cds.CdsTeamsMessageType;
import com.nuix.automate.workflow.core.utils.loadfile.LoadFileField;
import jakarta.mail.internet.InternetAddress;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.zip.CRC32;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class CdsUtils {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(CdsUtils.class);
    public static final String ESCAPED_ZIP_EXTENSION = "\\.zip";
    private static final List<String> dateFormats = new ArrayList<String>(){
        {
            this.add("M/d/yyyy h:mm:ss a");
            this.add("yyyy-MM-dd HH:mm:ss");
            this.add("yyyy-MM-dd HH:mm:ss'Z'");
            this.add("yyyy-MM-dd HH:mm:ssZ");
        }
    };

    public static CSVReader buildCsvReader(InputStream inputStream) throws IOException {
        char nullCharacter = '\u0000';
        Reader unicodeReader = FileUtils.readFileWithAutoDetectEncoding((InputStream)inputStream);
        return new CSVReader(unicodeReader, ',', '\"', nullCharacter);
    }

    public static List<String> getPathSplit(String fileName) {
        return List.of(fileName.split("[" + File.separator + "/\\\\]"));
    }

    public static Map<String, String> buildItemFieldValues(CdsItem item, Map<String, String> initialValues) {
        HashMap<String, String> itemFieldValues = new HashMap<String, String>();
        if (initialValues != null) {
            itemFieldValues.putAll(initialValues);
        }
        itemFieldValues.putAll(CdsUtils.buildItemFieldValues(item));
        return itemFieldValues;
    }

    public static Map<String, String> buildItemFieldValues(CdsItem item) {
        int participantsCount;
        CdsConversationMimeType mimeType;
        HashMap<String, String> itemFieldValues = new HashMap<String, String>();
        item.setSubjectLine(CdsUtils.generateNormalizedSubjectLine(item));
        itemFieldValues.put(CdsCustomMetadata.CDS_FILE_TYPE.toString(), String.valueOf((Object)item.getTeamsMessageType()));
        if (item.getDate() != null) {
            itemFieldValues.put(CdsCustomMetadata.ITEM_DATE.toString(), String.valueOf(item.getDate()));
        }
        if (item.getDocumentCreatedDateTime() != null) {
            itemFieldValues.put(CdsCustomMetadata.CREATED_DATE_TIME.toString(), String.valueOf(item.getDocumentCreatedDateTime()));
        }
        if (item.getDocumentLastModified() != null) {
            itemFieldValues.put(CdsCustomMetadata.LAST_MODIFIED_DATE_TIME.toString(), String.valueOf(item.getDocumentLastModified()));
        }
        if ((mimeType = item.getConversationMimeType()) != null) {
            itemFieldValues.put(CdsCustomMetadata.MIME_TYPE.toString(), item.getConversationMimeType().getMimeType());
            itemFieldValues.put(CdsCustomMetadata.CONVERSATION_ID.toString(), item.getConversationId());
            itemFieldValues.put(CdsCustomMetadata.CHAT_ID.toString(), item.getConversationId());
            itemFieldValues.put(CdsCustomMetadata.SUBJECT_LINE.toString(), item.getSubjectLine());
            if (mimeType != CdsConversationMimeType.CHANNEL_CONVERSATION && mimeType != CdsConversationMimeType.CHANNEL_MESSAGE && (participantsCount = item.getNonSystemParticipantsCount()) > 0) {
                itemFieldValues.put(CdsCustomMetadata.NUMBER_OF_PARTICIPANTS.toString(), String.valueOf(participantsCount));
            }
            if (item.getCopilotApplication() != null) {
                itemFieldValues.put(CdsCustomMetadata.COPILOT_APPLICATION.toString(), item.getCopilotApplication().toString());
            }
            if (mimeType == CdsConversationMimeType.CHAT_CONVERSATION || mimeType == CdsConversationMimeType.YAMMER_CONVERSATION) {
                itemFieldValues.put(CdsCustomMetadata.COMMUNICATION_PARTICIPANTS.toString(), AddressUtils.render(item.getParticipants()));
            }
            if (mimeType.isChatMessage()) {
                itemFieldValues.put(CdsCustomMetadata.FROM.toString(), AddressUtils.render(item.getSender()));
                itemFieldValues.put(CdsCustomMetadata.TO.toString(), AddressUtils.render(item.getRecipients()));
                if (mimeType != CdsConversationMimeType.CHANNEL_MESSAGE) {
                    itemFieldValues.put(CdsCustomMetadata.CHAT_PARTICIPANTS.toString(), AddressUtils.render(item.getParticipants()));
                }
                if (item.getDate() != null) {
                    itemFieldValues.put(CdsCustomMetadata.COMMUNICATION_DATE.toString(), item.getDate().toString());
                } else {
                    LOGGER.info("Item " + String.valueOf(item) + " does not have date");
                }
                itemFieldValues.put(CdsCustomMetadata.SENDER.toString(), AddressUtils.render(item.getSender()));
                itemFieldValues.put(CdsCustomMetadata.MESSAGE_ID.toString(), item.getClientMessageId());
                CdsTeamsMessageType teamsMessageType = item.getTeamsMessageType();
                if (teamsMessageType.isCall()) {
                    itemFieldValues.put(CdsCustomMetadata.CALL_ID.toString(), item.getCallId());
                    if (item.getSystemMessageType() == CdsSystemMessageType.CALL_STARTED) {
                        itemFieldValues.put(CdsCustomMetadata.CALL_START_TIME.toString(), item.getCallStartTime());
                    } else {
                        itemFieldValues.put(CdsCustomMetadata.CALL_END_TIME.toString(), item.getCallEndTime());
                        itemFieldValues.put(CdsCustomMetadata.CALL_DURATION.toString(), item.getCallDuration());
                    }
                }
                if (teamsMessageType == CdsTeamsMessageType.TEAMS_VIDEO_RECORDING) {
                    itemFieldValues.put(CdsCustomMetadata.CALL_ID.toString(), item.getCallId());
                    itemFieldValues.put(CdsCustomMetadata.RECORDING_URL.toString(), item.getAmsVideoUrl());
                    itemFieldValues.put(CdsCustomMetadata.RECORDING_EXPORT_URL.toString(), item.getVideoExportUrl());
                    itemFieldValues.put(CdsCustomMetadata.RECORDING_DURATION.toString(), item.getRecordingDuration());
                    itemFieldValues.put(CdsCustomMetadata.RECORDING_NAME.toString(), item.getRecordingName());
                    itemFieldValues.put(CdsCustomMetadata.RECORDING_FILE_NAME.toString(), item.getRecordingFileName());
                }
                if (teamsMessageType == CdsTeamsMessageType.TEAMS_TRANSCRIPT) {
                    itemFieldValues.put(CdsCustomMetadata.CALL_ID.toString(), item.getCallId());
                    itemFieldValues.put(CdsCustomMetadata.TRANSCRIPT_URL.toString(), item.getAmsTranscriptUrl());
                }
                if (mimeType == CdsConversationMimeType.CHAT_MESSAGE || mimeType == CdsConversationMimeType.CHANNEL_MESSAGE || mimeType == CdsConversationMimeType.SYSTEM_MESSAGE) {
                    itemFieldValues.put(CdsCustomMetadata.SYSTEM_MESSAGE_ID.toString(), item.getSystemMessageId());
                    itemFieldValues.put(CdsCustomMetadata.MESSAGE_REVISION.toString(), item.getMessageRevision());
                    if (item.getOriginalMessageId() != null) {
                        itemFieldValues.put(CdsCustomMetadata.ORIGINAL_MESSAGE_ID.toString(), item.getOriginalMessageId());
                    }
                }
                if (item.getDeletedDateTime() != null) {
                    itemFieldValues.put(CdsCustomMetadata.DELETED_DATE_TIME.toString(), item.getDeletedDateTime().toString());
                    itemFieldValues.put(CdsCustomMetadata.FLAG_DELETED.toString(), "true");
                }
                if (item.isDeleted()) {
                    itemFieldValues.put(CdsCustomMetadata.FLAG_DELETED.toString(), "true");
                }
                if (item.getParentConversationId() != null && item.getParentConversationId().trim().length() > 0) {
                    itemFieldValues.put(CdsCustomMetadata.CONVERSATION_REFERENCE.toString(), item.getParentConversationId());
                    if (item.getParentMessageIds().size() > 0) {
                        itemFieldValues.put(CdsCustomMetadata.MESSAGE_REFERENCES.toString(), String.join((CharSequence)", ", item.getParentMessageIds()));
                    }
                }
            }
            if (mimeType == CdsConversationMimeType.REACTION) {
                itemFieldValues.put(CdsCustomMetadata.REACTION_TYPE.toString(), item.getContent());
            }
        }
        if (item.getFileClass() == CdsFileClassType.ATTACHMENT && item.getTeamsMessageType() != CdsTeamsMessageType.EMAIL_REACTION && item.getTeamsMessageType() != CdsTeamsMessageType.TEAMS_CHAT_REACTION) {
            itemFieldValues.put(CdsCustomMetadata.ATTACHMENT_TYPE.toString(), String.valueOf((Object)item.getAttachmentType()));
        }
        if (item.getFileClass() == CdsFileClassType.EMAIL && item.getConversationMimeType() == null) {
            participantsCount = item.getNonSystemParticipantsCount();
            if (participantsCount > 0) {
                itemFieldValues.put(CdsCustomMetadata.NUMBER_OF_PARTICIPANTS.toString(), String.valueOf(participantsCount));
            }
            itemFieldValues.put(CdsCustomMetadata.SENDER.toString(), AddressUtils.render(item.getSender()));
            itemFieldValues.put(CdsCustomMetadata.SUBJECT_LINE.toString(), item.getSubjectLine());
        }
        if (item.getFailureMessage() != null && !item.getFailureMessage().isEmpty()) {
            itemFieldValues.put(CdsCustomMetadata.FAILURE_MESSAGE.toString(), item.getFailureMessage());
        }
        if (item.getFailureDetail() != null && !item.getFailureDetail().isEmpty()) {
            itemFieldValues.put(CdsCustomMetadata.FAILURE_DETAIL.toString(), item.getFailureDetail());
        }
        return itemFieldValues;
    }

    public static void setMissingLoadfileFieldValues(Map<String, LoadFileField> loadFileFieldMap, Map<String, String> original, Map<String, String> update) {
        for (String fieldName : original.keySet()) {
            String originalValue;
            LoadFileField loadFileField = loadFileFieldMap.get(fieldName);
            if (loadFileField == null || !loadFileField.isLoadFileField() || update.containsKey(fieldName) || (originalValue = original.get(fieldName)) == null) continue;
            update.put(fieldName, originalValue);
        }
    }

    public static boolean isCopilotCardAttachment(MapiAttachment mapiAttachment) {
        return CdsUtils.isCopilotCardAttachment(mapiAttachment.getProperties());
    }

    public static boolean isCopilotCardAttachment(MapiPropertyCollection propertyCollection) {
        MapiProperty cardPropId = propertyCollection.get_Item(923926559L);
        return cardPropId.toString().startsWith("SystemGeneratedCardAttachment");
    }

    public static String getFormattedConversationLocation(CdsItem cdsItem) {
        return CdsUtils.getFormattedConversationLocation(cdsItem.getLocationName(), cdsItem.getMessageKind(), cdsItem.getTeamName(), cdsItem.getChannelName());
    }

    public static String getFormattedConversationLocation(String locationName, CdsConversation cdsConversation) {
        return CdsUtils.getFormattedConversationLocation(locationName, cdsConversation.getMessageKind(), cdsConversation.getTeamName(), cdsConversation.getChannelName());
    }

    public static String getFormattedConversationLocation(String locationName, String messageKind, String teamName, String channelName) {
        if (messageKind.equalsIgnoreCase("yammer")) {
            return "Users/" + locationName.toLowerCase() + "/Yammer Conversations";
        }
        if (teamName == null || teamName.trim().equals("")) {
            return "Users/" + locationName.toLowerCase() + "/Chats";
        }
        String _channelName = channelName;
        if (teamName.equals(channelName)) {
            _channelName = "General";
        }
        return "Teams/" + teamName + "/Channels/" + _channelName;
    }

    public static String getFormattedExchangeLocation(String compoundPath, String locationName, String custodian, String itemClass) {
        String[] pathSplit = compoundPath.split("/");
        if (!locationName.equalsIgnoreCase(custodian)) {
            String teamName = locationName.split("@")[0];
            if (itemClass.equalsIgnoreCase("IPM.Appointment")) {
                CharSequence[] pathArray = Arrays.copyOfRange(pathSplit, 3, pathSplit.length);
                return "Teams/" + teamName + "/Calendars/" + String.join((CharSequence)"/", pathArray);
            }
            if (pathSplit[1].equalsIgnoreCase("Top of Information Store")) {
                CharSequence[] pathArray = Arrays.copyOfRange(pathSplit, 2, pathSplit.length);
                return "Teams/" + teamName + "/Exchange Online/Mailbox/" + String.join((CharSequence)"/", pathArray);
            }
            CharSequence[] pathArray = Arrays.copyOfRange(pathSplit, 1, pathSplit.length);
            return "Teams/" + teamName + "/SharePoint/" + String.join((CharSequence)"/", pathArray);
        }
        String user = pathSplit[0].toLowerCase();
        if (itemClass.equalsIgnoreCase("IPM.Appointment")) {
            CharSequence[] pathArray = Arrays.copyOfRange(pathSplit, 3, pathSplit.length);
            return "Users/" + user + "/Calendars/" + String.join((CharSequence)"/", pathArray);
        }
        if (pathSplit[1].equalsIgnoreCase("Top of Information Store")) {
            CharSequence[] pathArray = Arrays.copyOfRange(pathSplit, 2, pathSplit.length);
            return "Users/" + user + "/Exchange Online/Mailbox/" + String.join((CharSequence)"/", pathArray);
        }
        CharSequence[] pathArray = Arrays.copyOfRange(pathSplit, 1, pathSplit.length);
        return "Users/" + user + "/Exchange Online/" + String.join((CharSequence)"/", pathArray);
    }

    public static String getFormattedSharePointLocation(String compoundPath, String custodian) {
        int subDocumentUrl = ((String)(compoundPath = ((String)compoundPath).replace("?", ""))).indexOf("_layouts/15/Doc.aspx");
        if (subDocumentUrl != -1) {
            String updatePath = ((String)compoundPath).substring(0, subDocumentUrl) + "Documents" + ((String)compoundPath).substring(((String)compoundPath).lastIndexOf("/"));
            compoundPath = updatePath;
        }
        try {
            URL url = new URL((String)compoundPath);
            String urlPath = url.getPath().trim().substring(1);
            String[] urlSplits = url.getPath().substring(1).split("/");
            int rootIndex = 0;
            int subjectIndex = 0;
            boolean isShareUrl = false;
            for (int i = 0; i < urlSplits.length; ++i) {
                if (i == 0 && urlSplits[0].startsWith(":")) {
                    isShareUrl = true;
                }
                if (!urlSplits[i].equalsIgnoreCase("personal") && !urlSplits[i].equalsIgnoreCase("sites") && !urlSplits[i].equalsIgnoreCase("groups")) continue;
                rootIndex = i;
                subjectIndex = i + 1;
                break;
            }
            if (urlSplits[rootIndex].equalsIgnoreCase("personal")) {
                CharSequence[] pathArray = Arrays.copyOfRange(urlSplits, rootIndex + 2, urlSplits.length);
                if (custodian != null && !custodian.trim().equals("") && !isShareUrl) {
                    return "Users/" + custodian.toLowerCase() + "/SharePoint/" + String.join((CharSequence)"/", pathArray);
                }
                String host = url.getHost();
                String domain = host.substring(0, host.indexOf("-my.sharepoint.com"));
                String _custodian = urlSplits[subjectIndex];
                _custodian = _custodian.replace("_" + domain, "@" + domain);
                _custodian = _custodian.replace("_", ".");
                return "Users/" + _custodian + "/SharePoint/" + String.join((CharSequence)"/", pathArray);
            }
            if (urlSplits[rootIndex].equalsIgnoreCase("sites")) {
                CharSequence[] pathArray = Arrays.copyOfRange(urlSplits, rootIndex + 2, urlSplits.length);
                return "Teams/" + urlSplits[subjectIndex] + "/SharePoint/" + String.join((CharSequence)"/", pathArray);
            }
            if (urlSplits[rootIndex].equalsIgnoreCase("groups")) {
                CharSequence[] pathArray = Arrays.copyOfRange(urlSplits, rootIndex + 1, urlSplits.length);
                return "Group SharePoint Sites/" + String.join((CharSequence)"/", pathArray);
            }
            return "Group SharePoint Sites/Root/" + urlPath;
        }
        catch (Exception e) {
            return compoundPath;
        }
    }

    public static void closeMapiMessage(MapiMessage mapiMessage) {
        if (mapiMessage != null) {
            try {
                mapiMessage.close();
            }
            catch (NoSuchMethodError e) {
                mapiMessage.dispose();
            }
        }
    }

    public static MapiMessage loadEmail(InputStream is) {
        try {
            Method loadMethod = MapiMessage.class.getMethod("load", InputStream.class);
            return (MapiMessage)loadMethod.invoke(null, is);
        }
        catch (Throwable t) {
            try {
                Method fromStreamMethod = MapiMessage.class.getMethod("fromStream", InputStream.class);
                return (MapiMessage)fromStreamMethod.invoke(null, is);
            }
            catch (Throwable t2) {
                return null;
            }
        }
    }

    public static MailMessage loadMailMessage(InputStream is) {
        try {
            Method loadMethod = MailMessage.class.getMethod("load", InputStream.class);
            return (MailMessage)loadMethod.invoke(null, is);
        }
        catch (Throwable t) {
            try {
                Method fromStreamMethod = MailMessage.class.getMethod("fromStream", InputStream.class);
                return (MailMessage)fromStreamMethod.invoke(null, is);
            }
            catch (Throwable t2) {
                return null;
            }
        }
    }

    public static CdsConversationMimeType getYammerMessageType(String itemClass) {
        switch (itemClass) {
            case "IPM.Yammer.Message": {
                return CdsConversationMimeType.YAMMER_MESSAGE;
            }
            case "IPM.Yammer.Question": {
                return CdsConversationMimeType.YAMMER_QUESTION;
            }
            case "IPM.Yammer.Answer": {
                return CdsConversationMimeType.YAMMER_ANSWER;
            }
        }
        LOGGER.warn("Found new yammer message type: " + itemClass);
        return CdsConversationMimeType.YAMMER_MESSAGE;
    }

    public static String getFormattedConversationId(String conversationId) {
        return conversationId;
    }

    public static DateTime parseDateFromLoadFile(String itemDateCell) {
        if (itemDateCell == null || itemDateCell.trim().isEmpty()) {
            return null;
        }
        try {
            return DateTime.parse((String)itemDateCell).withZone(DateTimeZone.UTC);
        }
        catch (Exception exception) {
            Exception lastFailure = null;
            for (String dateFormat : dateFormats) {
                try {
                    return DateTime.parse((String)itemDateCell, (DateTimeFormatter)DateTimeFormat.forPattern((String)dateFormat)).withZone(DateTimeZone.UTC);
                }
                catch (Exception e) {
                    lastFailure = e;
                }
            }
            LOGGER.error("Unable to parse date, item has invalid date or date format is not supported", lastFailure);
            return null;
        }
    }

    public static String generateNormalizedSubjectLine(CdsItem item) {
        Object subjectLine = "";
        String custodian = item.getCustodian() == null ? AddressUtils.renderShort(item.getSender()) : item.getCustodian();
        if (custodian == null) {
            custodian = "";
        }
        LinkedHashSet<InternetAddress> recipients = new LinkedHashSet<InternetAddress>(item.getParticipants());
        int recipientCount = recipients.size();
        if (item.getTeamsMessageType() == CdsTeamsMessageType.TEAMS_CONVERSATION_ONE || item.getTeamsMessageType() == CdsTeamsMessageType.TEAMS_CONVERSATION_MANY) {
            if (item.getSender() != null) {
                --recipientCount;
            }
        } else {
            if (item.getSender() != null) {
                recipients.remove(item.getSender());
            }
            recipientCount = recipients.size();
        }
        Object recipientsCountString = recipientCount == 1 ? "1 other" : (recipientCount > 1 ? recipientCount + " others" : (item.getSender() != null ? AddressUtils.renderShort(item.getSender()) : "unknown"));
        CdsCopilotApplication application = item.getCopilotApplication();
        if (application == null) {
            application = CdsCopilotApplication.UNKNOWN;
        }
        if (item.getTeamsMessageType() != null) {
            switch (item.getTeamsMessageType()) {
                case TEAMS_CONVERSATION_ONE: {
                    subjectLine = "Conversation with " + (String)recipientsCountString;
                    break;
                }
                case TEAMS_CONVERSATION_MANY: {
                    subjectLine = "Conversation with " + (String)recipientsCountString;
                    break;
                }
                case TEAMS_CHANNEL_CONVERSATION: {
                    subjectLine = "Conversation in " + item.getChannelName() + " channel";
                    break;
                }
                case TEAMS_CHANNEL_MESSAGE: {
                    subjectLine = custodian + " sent a message in " + item.getChannelName();
                    break;
                }
                case TEAMS_CHAT_MESSAGE: {
                    if (item.isSystemMessage()) {
                        subjectLine = FormattingUtils.camelCaseToPrintable((String)item.getSystemMessageId());
                        break;
                    }
                    subjectLine = custodian + " sent a message to " + (String)recipientsCountString;
                    break;
                }
                case TEAMS_CHAT_REACTION: {
                    subjectLine = custodian + " reacted to a message";
                    break;
                }
                case TEAMS_SYSTEM_MESSAGE: {
                    subjectLine = item.getContent();
                    break;
                }
                case COPILOT_CONVERSATION: {
                    subjectLine = "Conversation with Copilot in " + String.valueOf((Object)application);
                    break;
                }
                case COPILOT_ANSWER: {
                    subjectLine = custodian + " answered question";
                    break;
                }
                case COPILOT_QUESTION: {
                    subjectLine = custodian + " asked Copilot in " + String.valueOf((Object)application) + " a question";
                    break;
                }
                case TEAMS_MEETING: {
                    subjectLine = "Meeting with " + custodian + " and " + (String)recipientsCountString;
                    break;
                }
                case TEAMS_CALL: {
                    subjectLine = "Call with " + custodian + " and " + (String)recipientsCountString;
                    break;
                }
                case TEAMS_SCREEN_SHARE: {
                    subjectLine = "Screen share with " + custodian + " and " + (String)recipientsCountString;
                    break;
                }
                case TEAMS_CALENDAR_EVENT: {
                    subjectLine = custodian + " sent a calendar invite";
                    break;
                }
                case TEAMS_TRANSCRIPT: {
                    subjectLine = custodian + " shared meeting transcript";
                    break;
                }
                case TEAMS_VIDEO_RECORDING: {
                    subjectLine = custodian + " shared meeting recording";
                    break;
                }
                case DOCUMENT: 
                case EMAIL: 
                case ATTACHMENT: {
                    subjectLine = item.getSubjectLine();
                    break;
                }
                case YAMMER_CONVERSATION: {
                    subjectLine = custodian + " started a Yammer conversation";
                    break;
                }
                case YAMMER_QUESTION: {
                    subjectLine = custodian + " asked a Yammer question";
                    break;
                }
                case YAMMER_MESSAGE: {
                    subjectLine = custodian + " sent a Yammer message";
                    break;
                }
                case YAMMER_ANSWER: {
                    subjectLine = custodian + " answered a Yammer question";
                    break;
                }
                case EMAIL_REACTION: {
                    subjectLine = custodian + " reacted to an email";
                }
            }
        } else {
            subjectLine = "Unknown";
        }
        return subjectLine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long computeCrc(InputStream is) throws IOException {
        CRC32 crc = new CRC32();
        try {
            byte[] buf = new byte[8192];
            int n = is.read(buf);
            while (n != -1) {
                crc.update(buf, 0, n);
                n = is.read(buf);
            }
        }
        finally {
            is.close();
        }
        return crc.getValue();
    }
}

