/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.cds;

import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.workflow.core.utils.cds.CdsItem;
import com.nuix.automate.workflow.core.utils.cds.CdsUtils;
import com.nuix.automate.workflow.core.utils.cds.PurviewExportFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;

public class PurviewExportFolder
extends PurviewExportFile {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(PurviewExportFolder.class);

    public PurviewExportFolder(Path path) throws IOException {
        this.setName(path.getFileName().toString());
        this.setPath(path);
    }

    @Override
    public InputStream getInputStream(CdsItem cdsItem) throws IOException {
        String fileName = cdsItem.getNativeExportPath();
        if (fileName == null) {
            return null;
        }
        List<String> pathSplit = CdsUtils.getPathSplit(fileName);
        String itemPath = String.join((CharSequence)File.separator, pathSplit.subList(1, pathSplit.size()));
        Path filePath = FileUtils.safeResolveParent((Path)this.getPath(), (String[])new String[]{itemPath});
        if (!Files.isDirectory(filePath, new LinkOption[0]) && Files.exists(filePath, new LinkOption[0])) {
            return Files.newInputStream(filePath, new OpenOption[0]);
        }
        LOGGER.error("Export does not contain file: " + cdsItem.getNativeExportPath());
        return null;
    }

    @Override
    public Long getSize(CdsItem cdsItem) throws IOException {
        return null;
    }

    @Override
    public Long getCrc(CdsItem cdsItem) throws IOException {
        return null;
    }

    @Override
    public boolean hasItem(CdsItem cdsItem) {
        try {
            String fileName = cdsItem.getNativeExportPath();
            if (fileName == null) {
                return false;
            }
            List<String> pathSplit = CdsUtils.getPathSplit(fileName);
            String itemPath = String.join((CharSequence)File.separator, pathSplit.subList(1, pathSplit.size()));
            Path filePath = FileUtils.safeResolveParent((Path)this.getPath(), (String[])new String[]{itemPath});
            return !Files.isDirectory(filePath, new LinkOption[0]) && Files.exists(filePath, new LinkOption[0]);
        }
        catch (Exception e) {
            LOGGER.debug("Error reading file: " + cdsItem.getNativeExportPath(), (Throwable)e);
            return false;
        }
    }
}

