/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.cds;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.workflow.core.utils.cds.CdsItem;
import com.nuix.automate.workflow.core.utils.cds.CdsUtils;
import com.nuix.automate.workflow.core.utils.cds.PurviewExportFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class PurviewExportZip
extends PurviewExportFile {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(PurviewExportZip.class);
    private ZipFile zipFile;

    public PurviewExportZip(Path path) throws IOException {
        this.setName(path.getFileName().toString());
        this.setPath(path);
        this.zipFile = new ZipFile(path.toFile());
    }

    @Override
    public InputStream getInputStream(CdsItem cdsItem) throws IOException {
        String fileName = cdsItem.getNativeExportPath();
        if (fileName == null) {
            return null;
        }
        List<String> pathSplit = CdsUtils.getPathSplit(fileName);
        String containerPath = String.join((CharSequence)File.separator, pathSplit.subList(1, pathSplit.size()));
        ZipEntry entry = this.zipFile.getEntry(containerPath);
        if (entry != null) {
            return this.zipFile.getInputStream(entry);
        }
        String purviewPatchedFileName = containerPath + ".html";
        entry = this.zipFile.getEntry(purviewPatchedFileName);
        if (entry != null) {
            LOGGER.debug("Detected native " + containerPath + " with .html suffix");
            return this.zipFile.getInputStream(entry);
        }
        LOGGER.warn("ZipFile does not contain entry: " + containerPath);
        return null;
    }

    @Override
    public Long getSize(CdsItem cdsItem) throws IOException {
        String fileName = cdsItem.getNativeExportPath();
        if (fileName == null) {
            return null;
        }
        List<String> pathSplit = CdsUtils.getPathSplit(fileName);
        String containerPath = String.join((CharSequence)File.separator, pathSplit.subList(1, pathSplit.size()));
        ZipEntry entry = this.zipFile.getEntry(containerPath);
        if (entry != null) {
            return entry.getSize();
        }
        String purviewPatchedFileName = containerPath + ".html";
        entry = this.zipFile.getEntry(purviewPatchedFileName);
        if (entry != null) {
            LOGGER.debug("Detected native " + containerPath + " with .html suffix");
            return entry.getSize();
        }
        LOGGER.warn("ZipFile does not contain entry: " + containerPath);
        return null;
    }

    @Override
    public Long getCrc(CdsItem cdsItem) throws IOException {
        String fileName = cdsItem.getNativeExportPath();
        if (fileName == null) {
            return null;
        }
        List<String> pathSplit = CdsUtils.getPathSplit(fileName);
        String containerPath = String.join((CharSequence)File.separator, pathSplit.subList(1, pathSplit.size()));
        ZipEntry entry = this.zipFile.getEntry(containerPath);
        if (entry != null) {
            return entry.getCrc();
        }
        String purviewPatchedFileName = containerPath + ".html";
        entry = this.zipFile.getEntry(purviewPatchedFileName);
        if (entry != null) {
            LOGGER.debug("Detected native " + containerPath + " with .html suffix");
            return entry.getCrc();
        }
        LOGGER.warn("ZipFile does not contain entry: " + containerPath);
        return null;
    }

    @Override
    public boolean hasItem(CdsItem cdsItem) {
        String fileName = cdsItem.getNativeExportPath();
        if (fileName == null) {
            return false;
        }
        List<String> pathSplit = CdsUtils.getPathSplit(fileName);
        String containerPath = String.join((CharSequence)File.separator, pathSplit.subList(1, pathSplit.size()));
        return this.zipFile.getEntry(containerPath) != null;
    }

    @Override
    public void close() throws IOException {
        if (this.zipFile != null) {
            this.zipFile.close();
        }
    }
}

