/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.cds;

import au.com.bytecode.opencsv.CSVReader;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.workflow.core.utils.cds.CdsItem;
import com.nuix.automate.workflow.core.utils.cds.CdsUtils;
import com.nuix.automate.workflow.core.utils.cds.PurviewItemsZipHandler;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class PurviewReportFile
implements Closeable {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(PurviewReportFile.class);
    protected Path path;
    protected String name;
    protected Set<String> loadfileNames;
    protected List<String> headers;
    protected Set<String> custodians;
    protected long recordCount;
    protected PurviewItemsZipHandler itemsHandler;

    public PurviewReportFile(Path path) throws IOException {
        this.path = path;
        this.custodians = new HashSet<String>();
        this.recordCount = 0L;
        this.loadfileNames = new HashSet<String>();
    }

    public void scanForItemExports(String itemRegex, String pstRegex) throws IOException {
        this.itemsHandler.scanForPurviewExports(itemRegex, pstRegex);
    }

    public abstract InputStream getInputStream(CdsItem var1) throws IOException;

    public abstract Long getCrc(CdsItem var1) throws IOException;

    public abstract Long getSize(CdsItem var1) throws IOException;

    public abstract List<InputStream> getLoadfileInputStreams() throws IOException;

    public abstract InputStream getInternalInputStream(String var1) throws IOException;

    public abstract void findAndSetLoadfileName(String var1) throws IOException;

    public abstract FileTime getFileTime() throws IOException;

    public void populateHeadersAndCustodians(String custodianColumnName) throws IOException {
        boolean configuredHeaders = false;
        for (InputStream is : this.getLoadfileInputStreams()) {
            CSVReader csvReader = CdsUtils.buildCsvReader(is);
            try {
                String[] row;
                int custodianColumnIndex;
                if (!configuredHeaders) {
                    this.headers = Arrays.asList(csvReader.readNext());
                    configuredHeaders = true;
                }
                if ((custodianColumnIndex = this.headers.indexOf(custodianColumnName)) <= 0) continue;
                while ((row = csvReader.readNext()) != null) {
                    ++this.recordCount;
                    String custodian = row[custodianColumnIndex];
                    if (custodian == null || custodian.equals(custodianColumnName)) continue;
                    this.custodians.add(custodian);
                }
            }
            finally {
                if (csvReader == null) continue;
                csvReader.close();
            }
        }
    }

    protected String getFirstLoadfileName() {
        if (this.loadfileNames.isEmpty()) {
            return null;
        }
        return this.loadfileNames.iterator().next();
    }

    protected FileTime getEarliestFileTime(FileTime creationTime, FileTime lastModifiedTime) {
        if (lastModifiedTime == null || creationTime != null && creationTime.compareTo(lastModifiedTime) < 0) {
            return creationTime;
        }
        return lastModifiedTime;
    }

    @Override
    public void close() throws IOException {
    }

    public String toString() {
        return this.path.toString();
    }

    public Path getPath() {
        return this.path;
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getLoadfileNames() {
        return this.loadfileNames;
    }

    public List<String> getHeaders() {
        return this.headers;
    }

    public Set<String> getCustodians() {
        return this.custodians;
    }

    public long getRecordCount() {
        return this.recordCount;
    }

    public PurviewItemsZipHandler getItemsHandler() {
        return this.itemsHandler;
    }

    public void setPath(Path path) {
        this.path = path;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLoadfileNames(Set<String> loadfileNames) {
        this.loadfileNames = loadfileNames;
    }

    public void setHeaders(List<String> headers) {
        this.headers = headers;
    }

    public void setCustodians(Set<String> custodians) {
        this.custodians = custodians;
    }

    public void setRecordCount(long recordCount) {
        this.recordCount = recordCount;
    }

    public void setItemsHandler(PurviewItemsZipHandler itemsHandler) {
        this.itemsHandler = itemsHandler;
    }
}

