/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.cds;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.workflow.core.utils.cds.CdsItem;
import com.nuix.automate.workflow.core.utils.cds.PurviewItemsZipHandler;
import com.nuix.automate.workflow.core.utils.cds.PurviewReportFile;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class PurviewReportZip
extends PurviewReportFile {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(PurviewReportZip.class);
    protected ZipFile zipFile;

    public PurviewReportZip(Path path) throws IOException {
        super(path);
        this.zipFile = new ZipFile(path.toFile());
        this.itemsHandler = new PurviewItemsZipHandler(path.getParent());
    }

    @Override
    public InputStream getInputStream(CdsItem cdsItem) throws IOException {
        return this.itemsHandler.getItemInputStream(cdsItem);
    }

    @Override
    public Long getCrc(CdsItem cdsItem) throws IOException {
        return this.itemsHandler.getCrc(cdsItem);
    }

    @Override
    public Long getSize(CdsItem cdsItem) throws IOException {
        return this.itemsHandler.getSize(cdsItem);
    }

    @Override
    public List<InputStream> getLoadfileInputStreams() throws IOException {
        ArrayList<InputStream> inputStreams = new ArrayList<InputStream>();
        for (String loadfileName : this.loadfileNames) {
            inputStreams.add(this.getInternalInputStream(loadfileName));
        }
        return inputStreams;
    }

    @Override
    public FileTime getFileTime() throws IOException {
        ZipEntry cdsLoadfile = this.zipFile.getEntry(this.getFirstLoadfileName());
        if (cdsLoadfile != null) {
            FileTime creationTime = cdsLoadfile.getCreationTime();
            FileTime lastModifiedTime = cdsLoadfile.getLastModifiedTime();
            return this.getEarliestFileTime(creationTime, lastModifiedTime);
        }
        return null;
    }

    @Override
    public InputStream getInternalInputStream(String fileName) throws IOException {
        ZipEntry entry = this.zipFile.getEntry(fileName);
        if (entry != null) {
            return this.zipFile.getInputStream(entry);
        }
        String purviewPatchedFileName = fileName + ".html";
        entry = this.zipFile.getEntry(purviewPatchedFileName);
        if (entry != null) {
            LOGGER.debug("Detected native " + fileName + " with .html suffix");
            return this.zipFile.getInputStream(entry);
        }
        LOGGER.warn("ZipFile does not contain entry: " + fileName);
        return null;
    }

    @Override
    public void findAndSetLoadfileName(String purviewReportItemsRegex) throws IOException {
        Enumeration<? extends ZipEntry> entries = this.zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) continue;
            LOGGER.debug("Detected zip entry " + entry.getName());
            if (!entry.getName().matches(purviewReportItemsRegex)) continue;
            this.loadfileNames.add(entry.getName());
        }
        if (this.loadfileNames.isEmpty()) {
            LOGGER.error("Failed to set loadfile name with regex: " + purviewReportItemsRegex);
        }
    }
}

