/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.digestlist;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.workflow.core.utils.digestlist.MD5Hash;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import nuix.Item;

public class DigestHelperUtils {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(DigestHelperUtils.class);
    private static final Pattern md5Pattern = Pattern.compile("^[A-Fa-f0-9]{32}$");
    private static int invalidMd5sCount;
    private static long itemsProcessed;
    private static long itemsToProcess;
    private static boolean stopRequested;

    public static int getInvalidMd5sCount() {
        return invalidMd5sCount;
    }

    public static double getExecutionProgress() {
        return (double)itemsProcessed / (double)itemsToProcess;
    }

    public static long getItemsProcessed() {
        return itemsProcessed;
    }

    static void requestStop() {
        stopRequested = true;
    }

    public static void resetState() {
        invalidMd5sCount = 0;
        itemsProcessed = 0L;
        itemsToProcess = 1L;
        stopRequested = false;
    }

    public static Set<MD5Hash> getMd5HashSetFromItems(Set<Item> items) {
        DigestHelperUtils.resetState(items.size());
        HashSet<MD5Hash> md5HashSet = new HashSet<MD5Hash>(items.size());
        for (Item item : items) {
            try {
                if (stopRequested) break;
                String md5Hex = item.getDigests().getMd5();
                if (md5Hex == null) {
                    throw new NullPointerException();
                }
                MD5Hash md5Hash = new MD5Hash(md5Hex);
                md5HashSet.add(md5Hash);
            }
            catch (NullPointerException e) {
                if (LOGGER != null) {
                    LOGGER.info("Item " + item.getGuid() + " md5 is null");
                }
                ++invalidMd5sCount;
            }
            ++itemsProcessed;
        }
        return md5HashSet;
    }

    public static Set<MD5Hash> getMd5HashSetFromFile(String md5FilePath) throws IOException {
        return DigestHelperUtils.getMd5HashSetFromFile(Paths.get(md5FilePath, new String[0]));
    }

    static Set<MD5Hash> getMd5HashSetFromFile(Path md5File) throws IOException {
        String fileExtension;
        if (!Files.exists(md5File, new LinkOption[0])) {
            throw new NoSuchFileException("Given md5 file does not exist");
        }
        String[] fileNameSplit = md5File.toString().split("\\.");
        switch (fileExtension = fileNameSplit[fileNameSplit.length - 1].toLowerCase()) {
            case "txt": 
            case "csv": 
            case "tsv": {
                return DigestHelperUtils.fromTextFile(md5File);
            }
            case "hash": {
                return DigestHelperUtils.fromNuixHashFile(md5File);
            }
        }
        throw new IllegalArgumentException("The file " + String.valueOf(md5File.toAbsolutePath()) + " provided does not have a valid extension.");
    }

    private static Set<MD5Hash> fromNuixHashFile(Path hashFile) throws IOException {
        int md5sInFile = (int)Files.size(hashFile) / 16;
        DigestHelperUtils.resetState(md5sInFile);
        HashSet<MD5Hash> md5HashSet = new HashSet<MD5Hash>(md5sInFile);
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(Files.newInputStream(hashFile, new OpenOption[0]));){
            if (bufferedInputStream.read(new byte[13], 0, 13) == -1) {
                throw new EOFException("Unsupported file format");
            }
            byte[] buffer = new byte[16];
            while (bufferedInputStream.read(buffer) > 0) {
                if (stopRequested) {
                    break;
                }
                byte[] md5ByteArray = Arrays.copyOf(buffer, 16);
                MD5Hash md5Hash = new MD5Hash(md5ByteArray);
                md5HashSet.add(md5Hash);
                ++itemsProcessed;
            }
        }
        return md5HashSet;
    }

    private static Set<MD5Hash> fromTextFile(Path textFile) throws IOException {
        HashSet<MD5Hash> md5HashSet;
        block16: {
            md5HashSet = new HashSet<MD5Hash>();
            int md5ColIndex = DigestHelperUtils.getTextFileMd5ColIndex(textFile);
            boolean hasHeader = md5ColIndex >= 0;
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(Files.newInputStream(textFile, new OpenOption[0]), StandardCharsets.UTF_8));){
                long totalLines = bufferedReader.lines().count();
                DigestHelperUtils.resetState(totalLines);
            }
            bufferedReader = new BufferedReader(new InputStreamReader(Files.newInputStream(textFile, new OpenOption[0]), StandardCharsets.UTF_8));
            try {
                String line;
                if (hasHeader) {
                    String line2;
                    bufferedReader.readLine();
                    while ((line2 = bufferedReader.readLine()) != null) {
                        if (stopRequested) {
                            break block16;
                        }
                        String md5Hex = line2.split("\\s{0,4},\\s{0,4}")[md5ColIndex].replace("\"", "");
                        DigestHelperUtils.validateAndAddMd5Hash(md5HashSet, md5Hex);
                    }
                    break block16;
                }
                while ((line = bufferedReader.readLine()) != null) {
                    if (stopRequested) {
                        break;
                    }
                    DigestHelperUtils.validateAndAddMd5Hash(md5HashSet, line);
                }
            }
            finally {
                bufferedReader.close();
            }
        }
        return md5HashSet;
    }

    private static int getTextFileMd5ColIndex(Path textFile) throws IOException {
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(Files.newInputStream(textFile, new OpenOption[0]), StandardCharsets.UTF_8));){
            String header = bufferedReader.readLine();
            String[] headerSplit = header.split("\\s{0,4},\\s{0,4}");
            for (int i = 0; i < headerSplit.length; ++i) {
                String col = headerSplit[i];
                if (!col.toLowerCase().contains("md5")) continue;
                int n = i;
                return n;
            }
            int n = -1;
            return n;
        }
    }

    private static void validateAndAddMd5Hash(Set<MD5Hash> md5HashSet, String md5Hex) {
        try {
            if (md5Hex == null || !md5Pattern.matcher(md5Hex).matches()) {
                throw new NullPointerException();
            }
            MD5Hash md5Hash = new MD5Hash(md5Hex);
            md5HashSet.add(md5Hash);
            ++itemsProcessed;
        }
        catch (NullPointerException e) {
            if (LOGGER != null) {
                LOGGER.info("Invalid MD5: " + md5Hex);
            }
            ++invalidMd5sCount;
        }
    }

    private static void resetState(long total) {
        itemsToProcess = total;
        itemsProcessed = 0L;
    }

    static {
        itemsProcessed = 0L;
        itemsToProcess = 1L;
        stopRequested = false;
    }
}

