/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.genAi;

import com.nuix.automate.utils.api.script.Response;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.thirdparty.GenAiService;
import com.nuix.automate.utils.models.api.thirdparty.GenAiUserCredential;
import com.nuix.automate.workflow.core.utils.genAi.GenAiException;
import com.nuix.automate.workflow.core.utils.genAi.GenAiMessage;
import com.nuix.automate.workflow.core.utils.genAi.GenAiModel;
import com.nuix.automate.workflow.core.utils.genAi.GenAiRequest;
import com.nuix.automate.workflow.core.utils.genAi.GenAiResponse;
import com.nuix.automate.workflow.core.utils.genAi.RetryableGenAiException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public abstract class GenAiClient {
    private static final int DEFAULT_TIMEOUT_S = 60;
    protected GenAiService genAiService;
    protected GenAiUserCredential genAiUserCredential;
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(GenAiClient.class);

    public GenAiClient(GenAiService genAiService) {
        this.genAiService = genAiService;
        this.genAiUserCredential = (GenAiUserCredential)genAiService.getUserCredential();
    }

    private void normalizeRequest(GenAiRequest request) {
        if (this.genAiService.getEnableSystemRole() == null || !this.genAiService.getEnableSystemRole().booleanValue()) {
            for (GenAiMessage genAiMessage : request.getMessages()) {
                if (!"system".equals(genAiMessage.getRole())) continue;
                genAiMessage.setRole("user");
            }
        }
    }

    protected void raiseForStatus(Response response) throws GenAiException {
        if (response.status_code == 429 || response.status_code == 500 || response.status_code == 502 || response.status_code == 503 || response.status_code == 504) {
            throw new RetryableGenAiException("Generic error HTTP/" + response.status_code);
        }
        if (response.status_code < 200 || response.status_code >= 300) {
            try {
                Map errorResponse = (Map)SerializationUtils.fromJson((String)response.text);
                if (errorResponse.containsKey("error")) {
                    throw new GenAiException("HTTP/" + response.status_code + ", " + String.valueOf(errorResponse.get("error")));
                }
                if (errorResponse.containsKey("detail")) {
                    throw new GenAiException("HTTP/" + response.status_code + ", " + String.valueOf(errorResponse.get("detail")));
                }
                throw new GenAiException("HTTP/" + response.status_code + ", " + response.text);
            }
            catch (GenAiException e) {
                throw e;
            }
            catch (Exception e) {
                throw new GenAiException("HTTP/" + response.status_code + ", " + response.text);
            }
        }
    }

    public abstract List<GenAiModel> getAvailableModels();

    protected abstract GenAiResponse getResponseInternal(GenAiRequest var1) throws IOException;

    public GenAiResponse getResponse(GenAiRequest request) throws IOException {
        LOGGER.info("GenAI request " + request.getId() + " started");
        this.normalizeRequest(request);
        AtomicReference<Object> responseReference = new AtomicReference<Object>(null);
        IOException[] exception = new IOException[]{null};
        int timeoutMs = this.getTimeoutS() * 1000;
        Thread thread = new Thread(() -> {
            try {
                responseReference.set(this.getResponseInternal(request));
            }
            catch (IOException e) {
                exception[0] = e;
            }
            catch (Exception e) {
                exception[0] = new IOException(e);
            }
        });
        thread.start();
        try {
            thread.join(timeoutMs);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        if (thread.isAlive()) {
            try {
                thread.stop();
            }
            catch (Exception e) {
                LOGGER.warn("Cannot stop timed out GenAI thread", (Throwable)e);
            }
            throw new RetryableGenAiException("Timeout " + this.getTimeoutS() + "s");
        }
        if (exception[0] != null) {
            throw exception[0];
        }
        return responseReference.get();
    }

    public int getTimeoutS() {
        if (this.genAiService.getTimeoutS() != null) {
            return this.genAiService.getTimeoutS();
        }
        return 60;
    }
}

