/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.genAi;

import com.nuix.automate.workflow.core.utils.genAi.openAi.DataElement;
import java.util.List;

public class GenAiMessage {
    public static final String ROLE_USER = "user";
    public static final String ROLE_SYSTEM = "system";
    public static final String ROLE_ASSISTANT = "assistant";
    public static final String ROLE_TOOL = "tool";
    public static final String ROLE_FUNCTION = "function";
    private String role;
    private String content;
    private List<DataElement> images;

    public GenAiMessage(String role, String content) {
        this.role = role;
        this.content = content;
    }

    public GenAiMessage(String role, String content, List<DataElement> images) {
        this.role = role;
        this.content = content;
        this.images = images;
    }

    public GenAiMessage(String role, List<DataElement> images) {
        this.role = role;
        this.images = images;
    }

    public String toString() {
        String result = this.role.toUpperCase() + ": ";
        if (this.content != null) {
            result = result + this.content;
            if (this.images != null && this.images.size() > 0) {
                result = result + "; ";
            }
        }
        if (this.images != null && this.images.size() > 0) {
            result = this.images.size() == 1 ? result + "1 image" : result + this.images.size() + " images";
        }
        return result;
    }

    public String getRole() {
        return this.role;
    }

    public String getContent() {
        return this.content;
    }

    public List<DataElement> getImages() {
        return this.images;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setImages(List<DataElement> images) {
        this.images = images;
    }
}

