/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.genAi;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.nuix.automate.workflow.core.utils.genAi.GenAiMessage;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class GenAiRequest {
    private String id;
    private List<GenAiMessage> messages;
    private Map<String, Object> options;
    private String jsonSchema;
    private Object reference;

    public GenAiRequest(String id, List<GenAiMessage> messages) {
        this.id = id;
        this.messages = messages;
        this.options = new LinkedHashMap<String, Object>();
    }

    public void setMaxResponseTokens(int maxTokens) {
        this.options.put("max_tokens", maxTokens);
    }

    public void setTemperature(double temperature) {
        this.options.put("temperature", temperature);
    }

    @JsonIgnore
    public Double getTemperature() {
        if (this.options.containsKey("temperature")) {
            return (double)((Double)this.options.get("temperature"));
        }
        return null;
    }

    @JsonIgnore
    public Integer getMaxResponseTokens() {
        if (this.options.containsKey("max_tokens")) {
            return (int)((Integer)this.options.get("max_tokens"));
        }
        return null;
    }

    public String getId() {
        return this.id;
    }

    public List<GenAiMessage> getMessages() {
        return this.messages;
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    public String getJsonSchema() {
        return this.jsonSchema;
    }

    public Object getReference() {
        return this.reference;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setMessages(List<GenAiMessage> messages) {
        this.messages = messages;
    }

    public void setOptions(Map<String, Object> options) {
        this.options = options;
    }

    public void setJsonSchema(String jsonSchema) {
        this.jsonSchema = jsonSchema;
    }

    public void setReference(Object reference) {
        this.reference = reference;
    }
}

