/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.genAi.bedrock;

import com.nuix.automate.utils.api.script.Response;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.thirdparty.GenAiService;
import com.nuix.automate.workflow.core.utils.genAi.GenAiClient;
import com.nuix.automate.workflow.core.utils.genAi.GenAiModel;
import com.nuix.automate.workflow.core.utils.genAi.bedrock.BedrockRestClient;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class BedrockClient
extends GenAiClient {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(BedrockClient.class);
    private static final String BEDROCK_URL_PREFIX = "https://bedrock.";
    private static final String BEDROCK_RUNTIME_URL_PREFIX = "https://bedrock-runtime.";
    protected BedrockRestClient restClient;

    public BedrockClient(GenAiService genAiService) {
        super(genAiService);
        this.restClient = new BedrockRestClient(genAiService);
        if (genAiService.getWhitelistedCertFingerprints() != null && !genAiService.getWhitelistedCertFingerprints().isEmpty()) {
            this.restClient.setFingerprints(genAiService.getWhitelistedCertFingerprints());
        }
        this.restClient.setBaseUrl(genAiService.getUrl().replace(BEDROCK_URL_PREFIX, BEDROCK_RUNTIME_URL_PREFIX));
    }

    protected List<GenAiModel> getAvailableModels(String filter) {
        Map bedrockModelsResponse;
        Response response;
        ArrayList<GenAiModel> models = new ArrayList<GenAiModel>();
        String originalBaseUrl = this.restClient.getBaseUrl();
        this.restClient.setBaseUrl(originalBaseUrl.replace(BEDROCK_RUNTIME_URL_PREFIX, BEDROCK_URL_PREFIX));
        try {
            response = this.restClient.get("/foundation-models");
            if (response.status_code == 200) {
                bedrockModelsResponse = (Map)SerializationUtils.fromJson((String)response.text);
                models.addAll(this.parseBedrockModelsResponse(bedrockModelsResponse, filter));
            } else {
                LOGGER.warn("Cannot get foundation models from Bedrock, received HTTP/" + response.status_code);
            }
        }
        catch (Exception e) {
            LOGGER.error("Cannot get foundation models from Bedrock", (Throwable)e);
        }
        try {
            response = this.restClient.get("/custom-models");
            if (response.status_code == 200) {
                bedrockModelsResponse = (Map)SerializationUtils.fromJson((String)response.text);
                models.addAll(this.parseBedrockModelsResponse(bedrockModelsResponse, filter));
            } else {
                LOGGER.warn("Cannot get custom models from Bedrock, received HTTP/" + response.status_code);
            }
        }
        catch (Exception e) {
            LOGGER.error("Cannot get custom models from Bedrock", (Throwable)e);
        }
        this.restClient.setBaseUrl(originalBaseUrl);
        return models;
    }

    private List<GenAiModel> parseBedrockModelsResponse(Map<String, Object> bedrockModelsResponse, String filter) {
        ArrayList<GenAiModel> models = new ArrayList<GenAiModel>();
        if (bedrockModelsResponse.containsKey("modelSummaries")) {
            List modelSummaries = (List)bedrockModelsResponse.get("modelSummaries");
            for (Map modelSummary : modelSummaries) {
                if (!modelSummary.containsKey("modelId")) continue;
                boolean isTextInputModel = false;
                boolean isTextOutputModel = false;
                String modelId = String.valueOf(modelSummary.get("modelId"));
                String modelName = null;
                modelName = modelSummary.containsKey("modelName") ? String.valueOf(modelSummary.get("modelName")) : modelId;
                if (filter != null && !modelId.contains(filter)) continue;
                if (modelSummary.containsKey("inputModalities")) {
                    List inputModalities = (List)modelSummary.get("inputModalities");
                    if (!inputModalities.contains("TEXT") && !inputModalities.contains("IMAGE")) continue;
                    isTextInputModel = true;
                }
                if (!isTextInputModel) continue;
                if (modelSummary.containsKey("outputModalities")) {
                    List outputModalities = (List)modelSummary.get("outputModalities");
                    if (!outputModalities.contains("TEXT")) continue;
                    isTextOutputModel = true;
                }
                if (!isTextOutputModel) continue;
                models.add(new GenAiModel(modelId, modelName));
            }
        }
        return models;
    }
}

