/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.genAi.bedrock.anthropic;

import com.nuix.automate.workflow.core.utils.genAi.GenAiException;
import com.nuix.automate.workflow.core.utils.genAi.GenAiMessage;
import com.nuix.automate.workflow.core.utils.genAi.GenAiRequest;
import com.nuix.automate.workflow.core.utils.genAi.bedrock.BedrockContentElement;
import com.nuix.automate.workflow.core.utils.genAi.bedrock.BedrockDataSource;
import com.nuix.automate.workflow.core.utils.genAi.bedrock.anthropic.AnthropicMessage;
import com.nuix.automate.workflow.core.utils.genAi.openAi.DataElement;
import java.util.ArrayList;
import java.util.LinkedHashMap;

public class AnthropicRequest
extends LinkedHashMap<String, Object> {
    public AnthropicRequest(GenAiRequest genAiRequest) throws GenAiException {
        this.put("anthropic_version", "bedrock-2023-05-31");
        ArrayList<AnthropicMessage> messages = new ArrayList<AnthropicMessage>();
        for (GenAiMessage genAiMessage : genAiRequest.getMessages()) {
            if (genAiRequest.getJsonSchema() != null && !genAiRequest.getJsonSchema().isEmpty()) {
                throw new GenAiException("Anthropic Gen AI implementation does not support JSON Schema");
            }
            AnthropicMessage anthropicMessage = new AnthropicMessage();
            anthropicMessage.setRole(genAiMessage.getRole());
            ArrayList<BedrockContentElement> content = new ArrayList<BedrockContentElement>();
            if (genAiMessage.getContent() != null && genAiMessage.getContent().length() > 0) {
                BedrockContentElement textContentElement = new BedrockContentElement();
                textContentElement.setType("text");
                textContentElement.setText(genAiMessage.getContent());
                if (genAiMessage.getRole().equals("system")) {
                    ArrayList system;
                    if (this.get("system") == null) {
                        system = new ArrayList();
                        this.put("system", system);
                    } else {
                        system = (ArrayList)this.get("system");
                    }
                    system.add(textContentElement);
                } else {
                    content.add(textContentElement);
                }
            }
            if (genAiMessage.getImages() != null && genAiMessage.getImages().size() > 0) {
                for (DataElement dataElement : genAiMessage.getImages()) {
                    BedrockContentElement imageContentElement = new BedrockContentElement();
                    imageContentElement.setType("image");
                    imageContentElement.setSource(new BedrockDataSource("base64", dataElement.getMediaType(), dataElement.getData()));
                    content.add(imageContentElement);
                }
            }
            if (content.isEmpty()) continue;
            anthropicMessage.setContent(content);
            messages.add(anthropicMessage);
        }
        this.put("messages", messages);
    }

    public void setMaxTokens(int maxTokens) {
        this.put("max_tokens", maxTokens);
    }

    public Integer getMaxTokens() {
        return (Integer)this.get("max_tokens");
    }

    public void setOption(String name, Object value) {
        this.put(name, value);
    }
}

