/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.genAi.bedrock.converse;

import com.google.gson.JsonSyntaxException;
import com.nuix.automate.utils.api.script.Response;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.thirdparty.GenAiService;
import com.nuix.automate.workflow.core.utils.genAi.GenAiException;
import com.nuix.automate.workflow.core.utils.genAi.GenAiMessage;
import com.nuix.automate.workflow.core.utils.genAi.GenAiModel;
import com.nuix.automate.workflow.core.utils.genAi.GenAiRequest;
import com.nuix.automate.workflow.core.utils.genAi.GenAiResponse;
import com.nuix.automate.workflow.core.utils.genAi.GenAiUsage;
import com.nuix.automate.workflow.core.utils.genAi.InvalidModelGenAiException;
import com.nuix.automate.workflow.core.utils.genAi.bedrock.BedrockClient;
import com.nuix.automate.workflow.core.utils.genAi.bedrock.converse.ConverseContentBlock;
import com.nuix.automate.workflow.core.utils.genAi.bedrock.converse.ConverseRequest;
import com.nuix.automate.workflow.core.utils.genAi.bedrock.converse.ConverseResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;

public class ConverseClient
extends BedrockClient {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ConverseClient.class);

    public ConverseClient(GenAiService genAiService) {
        super(genAiService);
    }

    @Override
    public List<GenAiModel> getAvailableModels() {
        return this.getAvailableModels(null);
    }

    @Override
    protected GenAiResponse getResponseInternal(GenAiRequest request) throws IOException {
        ConverseRequest converseRequest = new ConverseRequest(request);
        if (this.genAiService.getCustomParameters() != null) {
            for (Map.Entry entry : this.genAiService.getCustomParameters().entrySet()) {
                Object optionValue;
                try {
                    optionValue = SerializationUtils.fromJson((String)((String)entry.getValue()));
                }
                catch (JsonSyntaxException e) {
                    optionValue = entry.getValue();
                }
                converseRequest.setOption((String)entry.getKey(), optionValue);
            }
        }
        if (request.getOptions() != null) {
            request.getOptions().forEach(converseRequest::setOption);
        }
        String endpoint = "/model/" + this.genAiService.getModel() + "/converse";
        Response response = this.restClient.post(endpoint, converseRequest);
        this.raiseForStatus(response);
        ConverseResponse converseResponse = (ConverseResponse)response.getObject(ConverseResponse.class);
        try {
            String outputTypeString;
            Map errorOutput;
            Object outputType;
            Map errorResponse = (Map)SerializationUtils.fromJson((String)response.text);
            if (errorResponse.containsKey("message")) {
                String message = String.valueOf(errorResponse.get("message"));
                if (response.status_code == 400 && message.contains("model identifier is invalid")) {
                    throw new InvalidModelGenAiException(message);
                }
                throw new GenAiException(message);
            }
            if (errorResponse.containsKey("Output") && (outputType = (errorOutput = (Map)errorResponse.get("Output")).get("__type")) != null && (outputTypeString = (String)outputType).contains("OperationException")) {
                throw new GenAiException(outputTypeString);
            }
        }
        catch (GenAiException e) {
            LOGGER.error(response.text);
            throw e;
        }
        catch (Exception e) {
            // empty catch block
        }
        GenAiResponse genAiResponse = new GenAiResponse();
        genAiResponse.setCreatedAt(DateTime.now().getMillis());
        genAiResponse.setModel(this.genAiService.getModel());
        Object message = null;
        for (ConverseContentBlock contentBlock : converseResponse.getOutput().getMessage().getContent()) {
            if (contentBlock.getText() != null) {
                if (message == null) {
                    message = contentBlock.getText();
                    continue;
                }
                message = (String)message + "\n" + contentBlock.getText();
                continue;
            }
            if (contentBlock.getToolUse() == null) continue;
            message = SerializationUtils.toJson((Object)contentBlock.getToolUse().getInput());
            break;
        }
        if (message == null) {
            message = SerializationUtils.toJson(converseResponse.getOutput().getMessage().getContent());
        }
        GenAiMessage genAiMessage = new GenAiMessage(converseResponse.getOutput().getMessage().getRole(), (String)message);
        genAiResponse.setMessage(genAiMessage);
        GenAiUsage genAiUsage = new GenAiUsage();
        genAiUsage.setCompletionTokens(converseResponse.getUsage().getOutputTokens());
        genAiUsage.setPromptTokens(converseResponse.getUsage().getInputTokens());
        genAiResponse.setUsage(genAiUsage);
        return genAiResponse;
    }
}

