/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.genAi.ollama;

import com.google.gson.JsonSyntaxException;
import com.nuix.automate.utils.api.script.Response;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.thirdparty.GenAiService;
import com.nuix.automate.utils.models.api.thirdparty.GenAiUserCredential;
import com.nuix.automate.workflow.core.utils.genAi.GenAiClient;
import com.nuix.automate.workflow.core.utils.genAi.GenAiModel;
import com.nuix.automate.workflow.core.utils.genAi.GenAiRequest;
import com.nuix.automate.workflow.core.utils.genAi.GenAiResponse;
import com.nuix.automate.workflow.core.utils.genAi.GenAiUsage;
import com.nuix.automate.workflow.core.utils.genAi.ollama.OllamaRequest;
import com.nuix.automate.workflow.core.utils.genAi.ollama.OllamaResponse;
import com.nuix.automate.workflow.core.utils.genAi.ollama.OllamaRestClient;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;

public class OllamaClient
extends GenAiClient {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(OllamaClient.class);
    private OllamaRestClient restClient;

    public OllamaClient(GenAiService genAiService) {
        super(genAiService);
        this.restClient = new OllamaRestClient("OllamaRestClient-" + genAiService.getId());
        if (genAiService.getWhitelistedCertFingerprints() != null && !genAiService.getWhitelistedCertFingerprints().isEmpty()) {
            this.restClient.setFingerprints(genAiService.getWhitelistedCertFingerprints());
        }
        this.restClient.setBaseUrl(genAiService.getUrl());
        if (genAiService.getAuthenticationRequired()) {
            GenAiUserCredential credential = (GenAiUserCredential)genAiService.getUserCredential();
            switch (genAiService.getAuthenticationMethod()) {
                case API_KEY: 
                case BEARER_TOKEN: {
                    this.restClient.setBearerToken(credential.getToken());
                    break;
                }
                case CUSTOM_HEADER: {
                    for (Map.Entry entry : credential.getProperties().entrySet()) {
                        this.restClient.setHeader((String)entry.getKey(), (String)entry.getValue());
                    }
                    break;
                }
            }
        }
    }

    @Override
    public List<GenAiModel> getAvailableModels() {
        ArrayList<GenAiModel> validModels = new ArrayList<GenAiModel>();
        String getModelsUrl = this.genAiService.getUrl().replace("/api/chat", "/api/tags");
        this.restClient.setBaseUrl(getModelsUrl);
        try {
            Response response = this.restClient.get(null);
            this.raiseForStatus(response);
            Map models = (Map)response.getObject(Map.class);
            List modelsData = (List)models.get("models");
            for (Object modelData : modelsData) {
                Map modelDataMap = (Map)modelData;
                String id = (String)modelDataMap.get("model");
                String name = (String)modelDataMap.get("name");
                validModels.add(new GenAiModel(id, name));
            }
        }
        catch (Exception e) {
            LOGGER.warn("Cannot get models", (Throwable)e);
        }
        this.restClient.setBaseUrl(this.genAiService.getUrl());
        return validModels;
    }

    @Override
    protected GenAiResponse getResponseInternal(GenAiRequest request) throws IOException {
        OllamaRequest ollamaRequest = new OllamaRequest(this.genAiService.getModel(), request);
        if (this.genAiService.getCustomParameters() != null) {
            for (Map.Entry entry : this.genAiService.getCustomParameters().entrySet()) {
                Object optionValue;
                try {
                    optionValue = SerializationUtils.fromJson((String)((String)entry.getValue()));
                }
                catch (JsonSyntaxException e) {
                    optionValue = entry.getValue();
                }
                ollamaRequest.setOption((String)entry.getKey(), optionValue);
            }
        }
        if (request.getOptions() != null) {
            request.getOptions().forEach(ollamaRequest::setOption);
        }
        Response response = this.restClient.post(null, ollamaRequest);
        this.raiseForStatus(response);
        OllamaResponse ollamaResponse = (OllamaResponse)response.getObject(OllamaResponse.class);
        GenAiResponse genAiResponse = new GenAiResponse();
        try {
            genAiResponse.setCreatedAt(DateTime.parse((String)ollamaResponse.getCreatedAt()).getMillis());
        }
        catch (IllegalArgumentException e) {
            LOGGER.debug("Cannot parse date " + ollamaResponse.getCreatedAt(), (Throwable)e);
        }
        genAiResponse.setModel(ollamaResponse.getModel());
        genAiResponse.setMessage(ollamaResponse.getMessage());
        GenAiUsage genAiUsage = new GenAiUsage();
        genAiUsage.setCompletionTokens(ollamaResponse.getEvalCount());
        genAiUsage.setPromptTokens(ollamaResponse.getPromptEvalCount());
        genAiResponse.setUsage(genAiUsage);
        return genAiResponse;
    }
}

