/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.genAi.ollama;

import com.nuix.automate.workflow.core.utils.genAi.GenAiMessage;
import com.nuix.automate.workflow.core.utils.genAi.openAi.DataElement;
import java.util.ArrayList;
import java.util.List;

public class OllamaMessage {
    private String role;
    private String content;
    private List<String> images;

    public OllamaMessage() {
    }

    public OllamaMessage(GenAiMessage genAiMessage) {
        this.role = genAiMessage.getRole();
        this.content = genAiMessage.getContent();
        if (genAiMessage.getImages() != null) {
            this.images = new ArrayList<String>();
            for (DataElement dataElement : genAiMessage.getImages()) {
                this.images.add(dataElement.getData());
            }
        }
    }

    public OllamaMessage(String role, String content, String image) {
        this.role = role;
        this.content = content;
        this.images = new ArrayList<String>();
        this.images.add(image);
    }

    public OllamaMessage(String role, String content) {
        this.role = role;
        this.content = content;
    }

    public String getRole() {
        return this.role;
    }

    public String getContent() {
        return this.content;
    }

    public List<String> getImages() {
        return this.images;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setImages(List<String> images) {
        this.images = images;
    }
}

