/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.genAi.ollama;

import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.workflow.core.utils.genAi.GenAiMessage;
import com.nuix.automate.workflow.core.utils.genAi.GenAiRequest;
import com.nuix.automate.workflow.core.utils.genAi.ollama.OllamaMessage;
import com.nuix.automate.workflow.core.utils.genAi.openAi.DataElement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class OllamaRequest {
    private String model;
    private List<OllamaMessage> messages;
    private Map<String, Object> options;
    private boolean stream;
    private Map<String, Object> format;

    public OllamaRequest() {
    }

    public OllamaRequest(String model, GenAiRequest genAiRequest) {
        this.model = model;
        this.messages = new ArrayList<OllamaMessage>();
        for (GenAiMessage genAiMessage : genAiRequest.getMessages()) {
            if (genAiMessage.getImages() != null && genAiMessage.getImages().size() > 1) {
                this.messages.add(new OllamaMessage(genAiMessage.getRole(), genAiMessage.getContent()));
                for (DataElement dataElement : genAiMessage.getImages()) {
                    OllamaMessage imageOllamaMessage = new OllamaMessage(genAiMessage);
                    this.messages.add(new OllamaMessage(genAiMessage.getRole(), "", dataElement.getData()));
                }
                continue;
            }
            this.messages.add(new OllamaMessage(genAiMessage));
        }
        this.options = new LinkedHashMap<String, Object>();
        if (genAiRequest.getOptions() != null) {
            this.options.putAll(genAiRequest.getOptions());
        }
        if (genAiRequest.getJsonSchema() != null && !genAiRequest.getJsonSchema().isEmpty()) {
            this.format = (Map)SerializationUtils.fromJson((String)genAiRequest.getJsonSchema());
        }
        this.options.put("stream_response", false);
        this.stream = false;
    }

    public void setOption(String name, Object value) {
        if (this.options == null) {
            this.options = new LinkedHashMap<String, Object>();
        }
        this.options.put(name, value);
    }

    public String getModel() {
        return this.model;
    }

    public List<OllamaMessage> getMessages() {
        return this.messages;
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    public boolean isStream() {
        return this.stream;
    }

    public Map<String, Object> getFormat() {
        return this.format;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void setMessages(List<OllamaMessage> messages) {
        this.messages = messages;
    }

    public void setOptions(Map<String, Object> options) {
        this.options = options;
    }

    public void setStream(boolean stream) {
        this.stream = stream;
    }

    public void setFormat(Map<String, Object> format) {
        this.format = format;
    }
}

