/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.general;

import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.DisplayCondition;
import com.nuix.automate.utils.workflow.DisplayConditionType;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.Parameters;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.nuix.ExecutionContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DisplayConditionUtils {
    private static final transient LoggerWrapper LOGGER = LogManagerUtils.getLogger(DisplayConditionUtils.class);
    private static DisplayConditionUtils instance;

    public static DisplayConditionUtils getInstance() {
        if (instance == null) {
            instance = new DisplayConditionUtils();
        }
        return instance;
    }

    public List<StaticParameter> evaluateDisplayableParameters(List<StaticParameter> parameters, long timeoutMs) {
        Parameters sessionConfigParameters = new Parameters();
        for (StaticParameter parameter : parameters) {
            sessionConfigParameters.put((Parameter)parameter);
        }
        ExecutionContext executionContext = new ExecutionContext(null, null, null, null, null, false, sessionConfigParameters);
        return this.evaluateDisplayableParametersInternal(parameters, executionContext, timeoutMs);
    }

    public List<StaticParameter> evaluateDisplayableParameters(List<StaticParameter> parameters, ExecutionContext executionContext, long timeoutMs) {
        Parameters sessionConfigParameters = new Parameters();
        for (Parameter parameter : executionContext.getSessionConfigParameters().getParameters()) {
            sessionConfigParameters.put(parameter);
        }
        for (StaticParameter staticParameter : parameters) {
            sessionConfigParameters.put((Parameter)staticParameter);
        }
        ExecutionContext executionContextInternal = new ExecutionContext(null, null, null, null, null, false, sessionConfigParameters);
        return this.evaluateDisplayableParametersInternal(parameters, executionContextInternal, timeoutMs);
    }

    private List<StaticParameter> evaluateDisplayableParametersInternal(List<StaticParameter> parameters, ExecutionContext executionContext, long timeoutMs) {
        HashSet<String> displayableParameterNames = new HashSet<String>();
        for (StaticParameter parameter : parameters) {
            boolean result = this.evaluateDisplayCondition(parameter.getDisplayCondition(), executionContext, displayableParameterNames, timeoutMs);
            if (result) {
                displayableParameterNames.add(parameter.getName());
            }
            parameter.getDisplayCondition().setDisplayable(result);
        }
        return parameters;
    }

    public boolean evaluateDisplayCondition(DisplayCondition displayCondition, ExecutionContext executionContext, Set<String> displayableParameterNames, long timeoutMs) {
        if (!this.isValidDisplayCondition(displayCondition)) {
            return true;
        }
        String parameterValue = displayCondition.getParameter();
        String value = displayCondition.getValue();
        DisplayConditionType condition = displayCondition.getCondition();
        if (!displayableParameterNames.contains(parameterValue)) {
            return false;
        }
        try {
            parameterValue = executionContext.evalParameters(parameterValue, null);
        }
        catch (Exception e) {
            LOGGER.error("cannot evaluate parameter " + parameterValue, (Throwable)e);
        }
        try {
            value = executionContext.evalParameters(value, null);
        }
        catch (Exception e) {
            LOGGER.error("cannot evaluate display condition value", (Throwable)e);
        }
        boolean result = false;
        switch (condition) {
            default: {
                result = parameterValue.equals(value);
                break;
            }
            case IS_NOT: {
                result = !parameterValue.equals(value);
                break;
            }
            case CONTAINS: {
                result = parameterValue.contains(value);
                break;
            }
            case BEGINS_WITH: {
                result = parameterValue.startsWith(value);
                break;
            }
            case ENDS_WITH: {
                result = parameterValue.endsWith(value);
                break;
            }
            case GREATER_THAN: {
                Long gt_parameterLong = null;
                try {
                    gt_parameterLong = Long.parseLong(parameterValue);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Long gt_valueLong = null;
                try {
                    gt_valueLong = Long.parseLong(value);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (gt_parameterLong == null || gt_valueLong == null) break;
                result = gt_parameterLong > gt_valueLong;
                break;
            }
            case LESS_THAN: {
                Long lt_parameterLong = null;
                try {
                    lt_parameterLong = Long.parseLong(parameterValue);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Long lt_valueLong = null;
                try {
                    lt_valueLong = Long.parseLong(value);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (lt_parameterLong == null || lt_valueLong == null) break;
                result = lt_parameterLong < lt_valueLong;
                break;
            }
            case MATCHES_REGEX: {
                result = FormattingUtils.safeMatchesRegex((String)parameterValue, (String)value, (long)timeoutMs);
            }
        }
        return result;
    }

    private boolean isValidDisplayCondition(DisplayCondition displayCondition) {
        if (displayCondition == null) {
            return false;
        }
        return displayCondition.getParameter() != null && displayCondition.getCondition() != null && displayCondition.getValue() != null;
    }

    private boolean isDisplayConditionDependantOnParent(String parent, DisplayCondition displayCondition) {
        if (this.isValidDisplayCondition(displayCondition)) {
            return displayCondition.getParameter().equals(parent);
        }
        return false;
    }

    public int getDisplayableParametersCount(List<StaticParameter> parameters) {
        int count = 0;
        for (StaticParameter p : parameters) {
            if (!p.getDisplayCondition().getDisplayable()) continue;
            ++count;
        }
        return count;
    }

    public List<com.nuix.automate.utils.models.api.job.Parameter> resolveDependantParameters(String parentParameter, List<com.nuix.automate.utils.models.api.job.Parameter> parameters) {
        ArrayList<com.nuix.automate.utils.models.api.job.Parameter> dependants = new ArrayList<com.nuix.automate.utils.models.api.job.Parameter>();
        for (int i = 0; i < parameters.size(); ++i) {
            com.nuix.automate.utils.models.api.job.Parameter parameter = parameters.get(i);
            if (!this.isDisplayConditionDependantOnParent(parentParameter, parameter.getDisplayCondition())) continue;
            dependants.add(parameter);
            dependants.addAll(this.resolveDependantParameters(parameter.getName(), parameters.subList(i, parameters.size() - 1)));
        }
        return dependants;
    }

    public Map<String, Boolean> evaluateDependantParameters(com.nuix.automate.utils.models.api.job.Parameter parentParameter, List<com.nuix.automate.utils.models.api.job.Parameter> parametersToUpdate, long timeoutMs) {
        if (parentParameter == null || parametersToUpdate == null) {
            return new HashMap<String, Boolean>();
        }
        ArrayList<StaticParameter> staticParameters = new ArrayList<StaticParameter>();
        staticParameters.add(new StaticParameter(parentParameter));
        for (com.nuix.automate.utils.models.api.job.Parameter parameter : parametersToUpdate) {
            if (parameter.getName().equals(parentParameter.getName()) || !this.isDisplayConditionDependantOnParent(parentParameter.getName(), parameter.getDisplayCondition())) continue;
            StaticParameter staticParameter = new StaticParameter(parameter);
            staticParameters.add(staticParameter);
        }
        List<StaticParameter> displayableParameters = this.evaluateDisplayableParameters(staticParameters, timeoutMs);
        HashMap<String, Boolean> nameDisplayableMap = new HashMap<String, Boolean>();
        for (StaticParameter displayableParameter : displayableParameters) {
            if (displayableParameter.getName().equals(parentParameter.getName())) continue;
            nameDisplayableMap.put(displayableParameter.getName(), displayableParameter.getDisplayCondition().getDisplayable());
        }
        return nameDisplayableMap;
    }

    public Map<String, DisplayCondition> updateDisplayableParameters(List<com.nuix.automate.utils.models.api.job.Parameter> parametersToUpdate, long timeoutMs) {
        ArrayList<StaticParameter> staticParameters = new ArrayList<StaticParameter>();
        for (com.nuix.automate.utils.models.api.job.Parameter parameter : parametersToUpdate) {
            StaticParameter staticParameter = new StaticParameter(parameter);
            staticParameters.add(staticParameter);
        }
        HashMap<String, DisplayCondition> nameDisplayCondition = new HashMap<String, DisplayCondition>();
        List<StaticParameter> displayableParameters = this.evaluateDisplayableParameters(staticParameters, timeoutMs);
        for (StaticParameter displayableParameter : displayableParameters) {
            nameDisplayCondition.put(displayableParameter.getName(), displayableParameter.getDisplayCondition());
        }
        return nameDisplayCondition;
    }
}

