/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.general;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.input.BoundedInputStream;

public class DownloadObserver {
    private final AtomicLong sizeWritten;
    private final AtomicBoolean stopRequested;
    private final BoundedInputStream downloadInputStream;
    private final Thread writeThread = Thread.currentThread();
    private long count;
    private boolean done;
    private final long throwAfterNSecondsFrozen;
    private long lastReadUpdateMillis;
    private String error;

    public DownloadObserver(BoundedInputStream cin, AtomicLong sizeWritten, AtomicBoolean stopRequested, long throwAfterNSecondsFrozen) {
        this.downloadInputStream = cin;
        this.sizeWritten = sizeWritten;
        this.stopRequested = stopRequested;
        this.throwAfterNSecondsFrozen = throwAfterNSecondsFrozen;
    }

    public long run() {
        return this.run(true);
    }

    public long run(boolean interruptWriteThreadIfFrozen) {
        if (this.stopRequested.get()) {
            this.writeThread.interrupt();
            return 0L;
        }
        long prevCount = this.count;
        this.count = this.downloadInputStream.getCount();
        long read = this.count - prevCount;
        this.sizeWritten.getAndUpdate(prev -> prev + read);
        long currentMillis = System.currentTimeMillis();
        if (read != 0L || this.lastReadUpdateMillis == 0L) {
            this.lastReadUpdateMillis = currentMillis;
        } else if (interruptWriteThreadIfFrozen && (currentMillis - this.lastReadUpdateMillis) / 1000L > this.throwAfterNSecondsFrozen) {
            this.writeThread.interrupt();
            this.error = "DownloadObserver.Warning.DetectedFrozenFileProgress";
        }
        return read;
    }

    public void finish() {
        this.run(false);
        this.done = true;
    }

    public long getCount() {
        return this.count;
    }

    public boolean getDone() {
        return this.done;
    }

    public String getErrorKey() {
        return this.error;
    }
}

