/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.general;

import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.filelibrary.FileLibraryFile;
import com.nuix.automate.utils.models.api.job.Parameter;
import com.nuix.automate.utils.workflow.LogLevel;
import com.nuix.automate.utils.workflow.ParameterSource;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.workflow.WorkflowExecution;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;

public class FileParameterUtils {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(FileParameterUtils.class);
    private InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");

    public void createFileContentParameters(WorkflowExecution workflowExecution, List<Parameter> sessionParameters, Path additionalFilesTempDirectory, Map<String, FileLibraryFile> fileParameters) {
        for (Parameter parameter : sessionParameters) {
            try {
                String[] fileDataSplit;
                if (!parameter.isFileContents() || (fileDataSplit = parameter.getValue().split(":")).length != 2) continue;
                FileLibraryFile additionalFile = new FileLibraryFile();
                additionalFile.setName(fileDataSplit[0]);
                additionalFile.setData(fileDataSplit[1]);
                fileParameters.put(parameter.getName(), additionalFile);
            }
            catch (Exception e) {
                LOGGER.error("Unable to write " + parameter.getName() + " file", (Throwable)e);
            }
        }
        if (fileParameters.size() > 0) {
            this.createFiles(additionalFilesTempDirectory, fileParameters, workflowExecution);
        }
    }

    public void createFiles(Path additionalFilesDirectory, Map<String, FileLibraryFile> fileParameters, WorkflowExecution workflowExecution) {
        if (fileParameters == null || fileParameters.size() == 0) {
            return;
        }
        try {
            for (String parameterName : fileParameters.keySet()) {
                boolean shouldCreateFile;
                FileLibraryFile additionalFile = fileParameters.get(parameterName);
                File filePath = additionalFilesDirectory.resolve(additionalFile.getName()).toFile();
                Path baseDirPath = additionalFilesDirectory;
                Path userDirPath = Paths.get(additionalFile.getName(), new String[0]);
                if (!this.isSafePath(baseDirPath, userDirPath)) continue;
                byte[] fileData = com.nuix.automate.utils.general.FileUtils.decodeFileData((String)additionalFile.getData());
                if (filePath.exists()) {
                    if (this.shouldReplace(filePath, fileData)) {
                        LOGGER.info("Replacing file: " + additionalFile.getName() + " at: " + filePath.getAbsolutePath());
                        workflowExecution.log(this.iu.getFormattedString("ExecutionProfileUtils.ReplacingFile", new Object[]{additionalFile.getName(), filePath.getAbsolutePath(), FormattingUtils.sizeToDisplaySize((long)fileData.length)}));
                        shouldCreateFile = true;
                    } else {
                        LOGGER.info("Existing file: " + additionalFile.getName() + " at: " + filePath.getAbsolutePath() + " is the same");
                        shouldCreateFile = false;
                    }
                } else {
                    LOGGER.info("Creating file: " + additionalFile.getName() + " at: " + filePath.getAbsolutePath());
                    workflowExecution.log(this.iu.getFormattedString("ExecutionProfileUtils.CreatingFile", new Object[]{additionalFile.getName(), filePath.getAbsolutePath(), FormattingUtils.sizeToDisplaySize((long)fileData.length)}));
                    shouldCreateFile = true;
                    if (!filePath.getParentFile().exists()) {
                        filePath.getParentFile().mkdirs();
                    }
                }
                if (shouldCreateFile) {
                    this.writeFileToPath(filePath, fileData);
                }
                workflowExecution.log(this.iu.getFormattedString("ExecutionProfileUtils.SettingFileParameter", new Object[]{parameterName, filePath.getAbsolutePath()}));
                StaticParameter fileParameter = new StaticParameter(parameterName, filePath.getAbsolutePath());
                fileParameter.setSource(ParameterSource.FILE);
                workflowExecution.getExecutionContext().getSessionConfigParameters().put((com.nuix.automate.utils.workflow.Parameter)fileParameter);
            }
        }
        catch (Exception e) {
            LOGGER.error("Cannot create file", (Throwable)e);
            workflowExecution.log(e.getMessage(), LogLevel.ERROR);
        }
    }

    public boolean shouldReplace(File existingFile, byte[] newFileData) throws IOException {
        try {
            byte[] existingFileData = FileUtils.readFileToByteArray((File)existingFile);
            return !Arrays.equals(existingFileData, newFileData);
        }
        catch (Exception e) {
            LOGGER.error("Failed to read existing file: " + existingFile.getAbsolutePath(), (Throwable)e);
            throw new IOException(this.iu.getFormattedString("ExecutionProfileUtils.FailedToReadExisting", new Object[]{existingFile.getAbsolutePath(), e.getMessage()}));
        }
    }

    public void writeFileToPath(File safePath, byte[] fileData) throws IOException {
        try {
            FileUtils.writeByteArrayToFile((File)safePath, (byte[])fileData);
        }
        catch (IOException e) {
            LOGGER.error("Failed to create file", (Throwable)e);
            throw new IOException(this.iu.getFormattedString("ExecutionProfileUtils.FailedToCreate", new Object[]{safePath.getAbsolutePath(), e.getMessage()}));
        }
    }

    public boolean isSafePath(Path baseDirPath, Path userPath) throws IOException {
        if (!baseDirPath.isAbsolute()) {
            LOGGER.error("Base path must be absolute");
            throw new IOException(this.iu.getFormattedString("ExecutionProfileUtils.FailedToCreateBasePathNotAbsolute", (Object)baseDirPath.toString()));
        }
        if (userPath.isAbsolute()) {
            LOGGER.error("Filename cannot be an absolute path");
            throw new IOException(this.iu.getFormattedString("ExecutionProfileUtils.FailedToCreateNameAbsolute", (Object)userPath.toString()));
        }
        Path resolvedPath = baseDirPath.resolve(userPath).normalize();
        if (!resolvedPath.startsWith(baseDirPath)) {
            LOGGER.error("Could not set file parameter, filename escapes base path");
            throw new IOException(this.iu.getFormattedString("ExecutionProfileUtils.FailedToCreateNameNotSafe", (Object)userPath.toString()));
        }
        return true;
    }
}

