/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.general;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.workflow.core.utils.general.OutputListener;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class LineOutputStream
extends OutputStream {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(LineOutputStream.class);
    private static final int DEFAULT_BUFFER_LENGTH = 2048;
    private boolean hasBeenClosed = false;
    private byte[] buf = new byte[this.curBufLength];
    private int count = 0;
    private int curBufLength = 2048;
    private List<OutputListener> outputListeners = new ArrayList<OutputListener>();

    public synchronized void addListener(OutputListener listener) {
        this.outputListeners.add(listener);
    }

    private synchronized void fireLogLine(String line) {
        if (line.endsWith("\r\n")) {
            line = line.substring(0, line.length() - 2);
        } else if (line.endsWith("\n")) {
            line = line.substring(0, line.length() - 1);
        } else if (line.endsWith("\r")) {
            line = line.substring(0, line.length() - 1);
        }
        if (line.length() == 0) {
            return;
        }
        for (OutputListener outputListener : this.outputListeners) {
            try {
                outputListener.lineOutputted(line);
            }
            catch (Exception e) {
                LOGGER.error("Cannot send log line to listener", (Throwable)e);
            }
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (this.hasBeenClosed) {
            throw new IOException("The stream has been closed.");
        }
        if (b == 0) {
            return;
        }
        if (this.count == this.curBufLength) {
            int newBufLength = this.curBufLength + 2048;
            byte[] newBuf = new byte[newBufLength];
            System.arraycopy(this.buf, 0, newBuf, 0, this.curBufLength);
            this.buf = newBuf;
            this.curBufLength = newBufLength;
        }
        this.buf[this.count] = (byte)b;
        ++this.count;
    }

    @Override
    public void flush() {
        if (this.count == 0) {
            return;
        }
        byte[] bytes = new byte[this.count];
        System.arraycopy(this.buf, 0, bytes, 0, this.count);
        String str = new String(bytes, StandardCharsets.UTF_8);
        this.fireLogLine(str);
        this.count = 0;
    }

    @Override
    public void close() {
        this.flush();
        this.hasBeenClosed = true;
    }
}

