/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.general;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Scanner;

public class OsUtils {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(OsUtils.class);
    private static String sn = null;
    private static String name = null;

    public static String getComputerName() {
        if (name != null) {
            return name;
        }
        Map<String, String> env = System.getenv();
        if (env.containsKey("COMPUTERNAME")) {
            name = env.get("COMPUTERNAME");
        } else if (env.containsKey("HOSTNAME")) {
            name = env.get("HOSTNAME");
        } else {
            try {
                name = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException ex) {
                name = "Unknown";
            }
        }
        return name;
    }

    public static final String getSerialNumber() {
        if (sn != null) {
            return sn;
        }
        try {
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(new String[]{"wmic", "bios", "get", "serialnumber"});
            try (InputStream is = process.getInputStream();){
                Scanner sc = new Scanner(is);
                while (sc.hasNext()) {
                    String next = sc.next();
                    if (!"SerialNumber".equals(next)) continue;
                    sn = sc.next().trim();
                    break;
                }
            }
        }
        catch (IOException e) {
            LOGGER.warn("Cannot get system SN", (Throwable)e);
        }
        if (sn == null) {
            sn = "Unknown";
        }
        return sn;
    }

    public static String getUserName() {
        return System.getProperty("user.name");
    }

    public static boolean getOsWindows() {
        return System.getProperty("os.name").contains("Windows");
    }
}

