/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.general;

import com.nuix.automate.utils.workflow.ParameterType;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.ConfigureParametersOperation;
import com.nuix.automate.workflow.core.execution.options.configuration.ParameterListType;
import java.awt.Component;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.JPasswordField;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;

public class ParametersCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    JTextField jTextField;
    List<Object[]> parameters;
    ConfigureParametersOperation operation;
    ParameterListType parameterListType;

    public ParametersCellEditor(ConfigureParametersOperation operation, ParameterListType parameterListType) {
        this.operation = operation;
        this.parameterListType = parameterListType;
    }

    public ParametersCellEditor(List<Object[]> parameters, ParameterListType parameterListType) {
        this.parameters = parameters;
        this.parameterListType = parameterListType;
    }

    private boolean isProtected(int row) {
        if (this.parameters != null) {
            if (this.parameters.get(row)[1] instanceof ParameterType) {
                ParameterType parameterType = (ParameterType)this.parameters.get(row)[1];
                return parameterType.equals((Object)ParameterType.TEXT_PROTECTED) || parameterType.equals((Object)ParameterType.TEXT_MASKED);
            }
            String parameterName = this.parameters.get(row)[0].toString();
            StaticParameter dummyParameter = new StaticParameter(parameterName, "");
            return dummyParameter.isEffectiveTypeMaskedOrProtected();
        }
        return this.operation.isParamProtectedOrMasked(row, this.parameterListType);
    }

    @Override
    public Object getCellEditorValue() {
        return this.jTextField.getText();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.jTextField = this.isProtected(row) ? new JPasswordField() : new JTextField();
        this.jTextField.setText(value.toString());
        return this.jTextField;
    }
}

