/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.general;

import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.joda.time.DateTime;

public class ProductInfoUtils {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ProductInfoUtils.class);

    private static void getOperationSettings(Class<? extends Operation> operationClass, StringBuilder sb) {
        String operationName = operationClass.getName().replace("com.nuix.automate.workflowfornuix.execution.operations.", "");
        HashMap<String, Method> methods = new HashMap<String, Method>();
        for (Method method : operationClass.getMethods()) {
            methods.put(method.getName(), method);
        }
        try {
            Operation instance = operationClass.newInstance();
            for (Field field : operationClass.getFields()) {
                Object fieldName;
                field.setAccessible(true);
                int fieldModifiers = field.getModifiers();
                if (Modifier.isTransient(fieldModifiers) || Modifier.isStatic(fieldModifiers) || Modifier.isPrivate(fieldModifiers) || Modifier.isProtected(fieldModifiers) || ((String)(fieldName = field.getName())).equals("notes") || ((String)fieldName).equals("predefined")) continue;
                Object fieldValue = field.get(instance);
                ArrayList<Object> values = new ArrayList<Object>();
                Class<?> type = field.getType();
                if (fieldValue instanceof String || type.toString().equals("class java.lang.String")) {
                    if (((String)fieldName).equals("sourceEncoding") || ((String)fieldName).equals("zipEncoding")) {
                        values.add("UTF-8");
                        values.add("windows-1252");
                    } else if (((String)fieldName).equals("timeZoneId")) {
                        values.add("UTC");
                        values.add("EST");
                    } else {
                        fieldName = (String)fieldName + ".length";
                        values.add("0");
                        values.add("1");
                    }
                } else if (fieldValue instanceof Object[]) {
                    fieldName = (String)fieldName + ".count";
                    values.add("0");
                    values.add("1");
                } else if (fieldValue instanceof Collection || type.toString().equals("interface java.util.List")) {
                    fieldName = (String)fieldName + ".count";
                    values.add("0");
                    values.add("1");
                } else if (fieldValue instanceof Boolean || type.toString().equals("class java.lang.Boolean")) {
                    values.add("true");
                    values.add("false");
                } else if (fieldValue instanceof Enum) {
                    Enum e = (Enum)fieldValue;
                    for (Object value : e.getDeclaringClass().getEnumConstants()) {
                        values.add(String.valueOf(value));
                    }
                } else if (fieldValue instanceof Number || fieldValue instanceof Integer || fieldValue instanceof Long || fieldValue instanceof Double) {
                    values.add("0");
                    values.add("1");
                } else if (type.toString().equals("class java.util.Date")) {
                    values.add(FormattingUtils.dateTimeToGMTString((DateTime)new DateTime((Object)"2010-01-01T12:00:01+01:00")));
                    values.add(FormattingUtils.dateTimeToGMTString((DateTime)new DateTime((Object)"2029-12-31T23:59:59+01:00")));
                } else {
                    LOGGER.error("Cannot determine " + operationName + " " + (String)fieldName + " type " + type.toString());
                }
                for (String string : values) {
                    sb.append(operationName + "," + (String)fieldName + "," + string + "\n");
                }
            }
        }
        catch (IllegalAccessException e) {
            LOGGER.error("Illegal Access " + operationName, (Throwable)e);
        }
        catch (InstantiationException e) {
            LOGGER.debug("InstantiationException " + operationName, (Throwable)e);
        }
    }
}

