/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.general;

import com.nuix.automate.workflow.core.execution.operations.DummyOperation;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.mapper.CannotResolveClassException;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;

public class ReflectionUtils {
    public static List<Class<? extends Operation>> getOperationClasses() throws IOException, URISyntaxException {
        return ReflectionUtils.getOperationClasses(false);
    }

    public static List<Class<? extends Operation>> getOperationClasses(boolean includeImplementations) throws IOException, URISyntaxException {
        String operationsPackage = "com.nuix.automate.workflow.core.execution.operations";
        List classes = com.nuix.automate.utils.general.ReflectionUtils.getClassesForPackage((String)operationsPackage, Operation.class);
        ArrayList<Class<? extends Operation>> operationClasses = new ArrayList<Class<? extends Operation>>();
        for (Class clazz : classes) {
            if (clazz.equals(DummyOperation.class) || Modifier.isAbstract(clazz.getModifiers()) || !includeImplementations && clazz.getSimpleName().endsWith("Implementation")) continue;
            operationClasses.add(clazz);
        }
        return operationClasses;
    }

    public static Operation getOperationImplementation(Operation operation) throws CannotResolveClassException, ConversionException {
        XStream xstream = new XStream((ReflectionProvider)new PureJavaReflectionProvider());
        xstream.ignoreUnknownElements();
        xstream.allowTypesByWildcard(new String[]{"com.nuix.automate.**"});
        if (!operation.disabled) {
            String xmlText = xstream.toXML((Object)operation);
            if (operation.getClass().getName().endsWith("Implementation")) {
                return operation;
            }
            xmlText = xmlText.replace(operation.getClass().getName(), operation.getClass().getName() + "Implementation");
            Object operationImplementation = xstream.fromXML(xmlText);
            Operation implementation = (Operation)operationImplementation;
            return implementation;
        }
        return operation;
    }
}

