/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.general;

import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.PrintableOption;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.options.addevidence.SourceScope;
import com.nuix.automate.workflow.core.execution.options.configuration.PasswordSettingsType;
import com.nuix.automate.workflow.core.execution.options.export.LegalExportType;
import com.nuix.automate.workflow.core.execution.options.report.ReportView;
import com.nuix.automate.workflow.core.execution.options.report.SizeMethod;
import com.nuix.automate.workflow.core.execution.options.report.SizeUnit;
import com.nuix.automate.workflow.core.execution.options.sorting.SortDirection;
import com.nuix.automate.workflow.core.execution.options.sorting.SortField;
import com.nuix.automate.workflow.core.execution.workflow.Workflow;
import com.nuix.automate.workflow.core.update.Library;
import com.nuix.automate.workflow.core.update.Package;
import com.nuix.automate.workflow.core.utils.digestlist.DigestLocation;
import com.nuix.automate.workflow.core.utils.general.ReflectionUtils;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.InputSource;

public class Serializer {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(Serializer.class);
    private XStream serializerXstream = this.initializeXStream(true);
    private XStream deserializerXstream = this.initializeXStream(false);

    private XStream initializeXStream(boolean includeOperationsImplementations) {
        LOGGER.info("Initializing XStream");
        XStream xstream = new XStream((ReflectionProvider)new PureJavaReflectionProvider());
        xstream.ignoreUnknownElements();
        xstream.allowTypesByWildcard(new String[]{"com.nuix.automate.**"});
        try {
            block4: for (Class<? extends Operation> clazz : ReflectionUtils.getOperationClasses(includeOperationsImplementations)) {
                for (Constructor<?> constructor : clazz.getConstructors()) {
                    if (constructor.getParameterTypes().length != 0) continue;
                    try {
                        Operation operationInstance = (Operation)constructor.newInstance(new Object[0]);
                        xstream.alias(operationInstance.getOperationAlias().getAlias(), clazz);
                    }
                    catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                        LOGGER.error("Failed to add xstream alias for clazz, error during default constructor initialization, " + clazz.getSimpleName(), (Throwable)e);
                    }
                    continue block4;
                }
            }
        }
        catch (IOException | URISyntaxException e) {
            LOGGER.error("Failed to add xstream alias for operations", (Throwable)e);
        }
        xstream.alias("sourceScope", SourceScope.class);
        xstream.alias("digestLocation", DigestLocation.class);
        xstream.alias("sortField", SortField.class);
        xstream.alias("sortDirection", SortDirection.class);
        xstream.alias("passwordSettings", PasswordSettingsType.class);
        xstream.alias("legalExportType", LegalExportType.class);
        xstream.alias("com.nuix.automate.workflow.core.execution.workflow.ImmutableWorkflow", Workflow.class);
        xstream.alias("workflow", Workflow.class);
        xstream.alias("item", String.class);
        xstream.alias("reportView", ReportView.class);
        xstream.alias("sizeMethod", SizeMethod.class);
        xstream.alias("sizeUnit", SizeUnit.class);
        xstream.alias("library", Library.class);
        xstream.alias("package", Package.class);
        xstream.alias("parameter", StaticParameter.class);
        xstream.alias("option", PrintableOption.class);
        return xstream;
    }

    Serializer() {
    }

    public static String formatXml(String xml) {
        try {
            TransformerFactory factory = SAXTransformerFactory.newInstance();
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            Transformer serializer = factory.newTransformer();
            serializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            SAXSource xmlSource = new SAXSource(new InputSource(new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8))));
            StreamResult res = new StreamResult(new ByteArrayOutputStream());
            serializer.transform(xmlSource, res);
            return new String(((ByteArrayOutputStream)res.getOutputStream()).toByteArray(), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            return xml;
        }
    }

    public void serialize(Object o, File file) throws IOException {
        String xmlText = this.serialize(o);
        try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
            bufferedWriter.write(xmlText);
        }
    }

    public String serialize(Object o) throws IOException {
        String xmlText = this.serializerXstream.toXML(o);
        xmlText = Serializer.formatXml(xmlText);
        return xmlText;
    }

    public Object deserialize(File file) throws IOException {
        String xml = FileUtils.readFileWithAutodetectEncoding((File)file);
        return this.deserialize(xml);
    }

    public Object deserialize(String s) throws IOException {
        return this.deserializerXstream.fromXML(this.patchXml(s));
    }

    public Object deserialize(URL u) throws IOException {
        return this.deserializerXstream.fromXML(u);
    }

    private String patchXml(String xml) {
        xml = xml.replace("com.nuix.automate.rfn.scheduler.operations.GenerateDomainFieldsOperation", "generateDomainFields");
        xml = xml.replace("<replacetems>", "<replaceItems>");
        xml = xml.replace("</replacetems>", "</replaceItems>");
        xml = xml.replace("<promptForPlaceholdersAtExecution>", "<promptAtExecution>");
        xml = xml.replace("</promptForPlaceholdersAtExecution>", "</promptAtExecution>");
        xml = xml.replace("<removeTag>", "<untagItems>");
        xml = xml.replace("</removeTag>", "</untagItems>");
        xml = xml.replace("<setRelativityWorkspaceAndFolder>", "<configureRelativityConnection>");
        xml = xml.replace("</setRelativityWorkspaceAndFolder>", "</configureRelativityConnection>");
        xml = xml.replace("<relativityCreateClient>", "<relativitySetClient>");
        xml = xml.replace("</relativityCreateClient>", "</relativitySetClient>");
        xml = xml.replace("<relativityCreateMatter>", "<relativitySetMatter>");
        xml = xml.replace("</relativityCreateMatter>", "</relativitySetMatter>");
        xml = xml.replace("<configureNuix>", "<configureNuixEngine>");
        xml = xml.replace("</configureNuix>", "</configureNuixEngine>");
        xml = xml.replace("<name>{memgraph_service_id}</name>\n          <parameterType>MEMGRAPH_SERVICE</parameterType>", "<name>{knowledge_graph_service_id}</name>\n          <parameterType>GRAPH_SERVICE</parameterType>");
        xml = xml.replace("<parameterType>MEMGRAPH_SERVICE</parameterType>", "<parameterType>GRAPH_SERVICE</parameterType>");
        xml = xml.replace("memgraphConfigureConnection>", "graphConfigureConnection>");
        xml = xml.replace("<memgraphServiceId>{memgraph_service_id}</memgraphServiceId>", "<graphServiceId>{knowledge_graph_service_id}</graphServiceId>");
        xml = xml.replace("memgraphServiceId>", "graphServiceId>");
        xml = xml.replace("memgraphPromote>", "graphPromote>");
        xml = xml.replace("sendEnrichmentToMemgraph>", "sendEnrichmentToGraph>");
        xml = xml.replace("sendEnrichmentToMemgraph>", "sendEnrichmentToGraph>");
        xml = xml.replace("com.rampiva.automate.utils.models.", "com.nuix.automate.utils.models.");
        xml = xml.replace("com.rampiva.workflow.core.", "com.nuix.automate.workflow.core.");
        return xml;
    }
}

