/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.general;

import java.util.Arrays;

public class StringCleaner {
    static final int[] fileNameIllegalCharacters = new int[]{34, 60, 62, 124, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 58, 42, 63, 92, 47};
    static final int[] pathNameIllegalCharacters = new int[]{34, 60, 62, 124, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 58, 42, 63, 47};

    public static String cleanDocumentIdPrefix(String originalPrefix) {
        String result = originalPrefix;
        if (result.length() == 0) {
            return "SET-";
        }
        return result;
    }

    private static String cleanPathName(String originalPath) {
        originalPath = originalPath.trim();
        StringBuilder cleanName = new StringBuilder();
        int len = originalPath.codePointCount(0, originalPath.length());
        for (int i = 0; i < len; ++i) {
            int c = originalPath.codePointAt(i);
            if (Arrays.binarySearch(pathNameIllegalCharacters, c) < 0 || i == 1 && c == 58) {
                cleanName.appendCodePoint(c);
                continue;
            }
            cleanName.append("_");
        }
        return cleanName.toString();
    }

    public static String cleanFileName(String orifinalFileName) {
        StringBuilder cleanName = new StringBuilder();
        int len = orifinalFileName.codePointCount(0, orifinalFileName.length());
        for (int i = 0; i < len; ++i) {
            int c = orifinalFileName.codePointAt(i);
            if (Arrays.binarySearch(fileNameIllegalCharacters, c) < 0) {
                cleanName.appendCodePoint(c);
                continue;
            }
            cleanName.append("_");
        }
        return cleanName.toString();
    }

    static {
        Arrays.sort(fileNameIllegalCharacters);
        Arrays.sort(pathNameIllegalCharacters);
    }
}

