/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.general;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import java.util.HashSet;
import java.util.Set;

public class ThreadUtils {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ThreadUtils.class);

    public static Set<Thread> getAutomateThreads() {
        HashSet<Thread> automateThreads = new HashSet<Thread>();
        Set<Thread> allThreads = Thread.getAllStackTraces().keySet();
        for (Thread thread : allThreads) {
            if (thread.getName().startsWith("Automate")) {
                automateThreads.add(thread);
            }
            for (StackTraceElement stackTraceElement : thread.getStackTrace()) {
                if (!stackTraceElement.toString().toLowerCase().contains("automate")) continue;
                automateThreads.add(thread);
            }
        }
        LOGGER.info("Detected " + automateThreads.size() + " Automate thread(s)");
        if (automateThreads.size() > 0) {
            LOGGER.info("Live Automate threads:");
            for (Thread automateThread : automateThreads) {
                if (!automateThread.isAlive()) continue;
                LOGGER.info("\t\"" + automateThread.getName() + "\"\tID=" + automateThread.getId());
                if (automateThread.getName().equals("main")) {
                    LOGGER.info("\t\t...");
                    continue;
                }
                for (StackTraceElement stackTraceElement : automateThread.getStackTrace()) {
                    LOGGER.info("\t\t" + stackTraceElement.toString());
                }
            }
        }
        return automateThreads;
    }
}

