/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.general;

public class TimeZone {
    private String timeZoneID;
    private String representation;
    private String displayName;
    private int rawOffset;

    public TimeZone(String timeZoneID) {
        this.timeZoneID = timeZoneID;
        java.util.TimeZone timeZone = java.util.TimeZone.getTimeZone(timeZoneID);
        this.rawOffset = timeZone.getRawOffset();
        Object offset = "GMT";
        if (this.rawOffset != 0) {
            int hoursOffset = Math.abs(this.rawOffset) / 1000 / 60 / 60;
            int minutesOffset = Math.abs(this.rawOffset) / 1000 / 60 - hoursOffset * 60;
            offset = this.rawOffset > 0 ? (String)offset + "+" : (String)offset + "-";
            offset = (String)offset + String.format("%02d:%02d", hoursOffset, minutesOffset);
        }
        this.displayName = timeZone.getDisplayName().replaceAll(" \\([^\\)]+\\)", "");
        this.representation = "(" + (String)offset + ") " + this.displayName + " (" + timeZoneID + ")";
    }

    public String GetDisplayName() {
        return this.displayName;
    }

    public String GetTimeZoneID() {
        return this.timeZoneID;
    }

    public int GetRawOffset() {
        return this.rawOffset;
    }

    public String toString() {
        return this.representation;
    }
}

