/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.investigate;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.workflow.core.utils.general.ThirdPartyProxyRestClient;
import com.nuix.automate.workflow.core.utils.investigate.Group;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.GenericType;

public class InvestigateServiceRestClient
extends ThirdPartyProxyRestClient {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(InvestigateServiceRestClient.class);

    public InvestigateServiceRestClient(String thirdPartyServiceId, String schedulerUrl, String bearerToken, Set<String> whitelistedCertFingerprints) throws GeneralSecurityException {
        super(thirdPartyServiceId, schedulerUrl, bearerToken, whitelistedCertFingerprints);
    }

    @Override
    public String getLogFileName() {
        return System.getProperty("automate.investigateservice.log");
    }

    @Override
    public String getServiceName() {
        return "Investigate Service";
    }

    public List<Group> getGroups() throws IOException {
        return this.proxyApiGetRequest("svc/groups", new GenericType<List<Group>>(){});
    }

    public void addGroupToCase(Integer groupId, String caseGuid) throws IOException {
        HashMap body = new HashMap();
        ArrayList<Integer> groupIds = new ArrayList<Integer>();
        groupIds.add(groupId);
        body.put("groupIds", groupIds);
        this.proxyApiRequest("svc/caseGroups/" + caseGuid + "/add", "POST", 200, body, new GenericType<String>(){});
    }
}

