/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.loadfile;

import com.aspose.email.MapiAttachment;
import com.aspose.email.MapiMessage;
import com.aspose.email.SaveOptions;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.workflow.core.execution.exceptions.DocIdErrorListener;
import com.nuix.automate.workflow.core.utils.cds.AddressUtils;
import com.nuix.automate.workflow.core.utils.cds.CdsAttachmentType;
import com.nuix.automate.workflow.core.utils.cds.CdsConversationMimeType;
import com.nuix.automate.workflow.core.utils.cds.CdsConversationSource;
import com.nuix.automate.workflow.core.utils.cds.CdsFileClassType;
import com.nuix.automate.workflow.core.utils.cds.CdsItem;
import com.nuix.automate.workflow.core.utils.cds.CdsTeamsMessageParser;
import com.nuix.automate.workflow.core.utils.cds.CdsUtils;
import com.nuix.automate.workflow.core.utils.loadfile.Loadfile;
import com.nuix.automate.workflow.core.utils.loadfile.LoadfileItem;
import jakarta.mail.internet.InternetAddress;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipOutputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class CdsLoadFileItem
extends LoadfileItem {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(CdsLoadFileItem.class);
    private CdsItem item;
    private boolean detachRegularAttachments;
    private boolean stubModernAttachments;

    public CdsLoadFileItem(String docId, CdsItem item, Map<String, String> fieldValueMap, boolean convertEmailsToEmlRfc5322, boolean detachRegularAttachments, boolean stubModernAttachments) {
        super(docId, item.getFamilyId(), item.getLocation(), String.valueOf((Object)item.getFileClass()), fieldValueMap, convertEmailsToEmlRfc5322);
        this.item = item;
        this.detachRegularAttachments = detachRegularAttachments;
        this.stubModernAttachments = stubModernAttachments;
    }

    @Override
    public void setLocation(String location) {
        this.setLocation(location, new String[0]);
    }

    public void setLocation(String location, String ... others) {
        this.item.setLocation(location, others);
        super.setLocation(this.item.getLocation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean write(Loadfile loadfile, Document xmlDocument, Element documentsXmlElement, ZipOutputStream zipOutputStream, DocIdErrorListener errorListener) throws IOException {
        boolean resultOk;
        block49: {
            resultOk = true;
            if (this.item.getConversationMimeType() != null) {
                if (this.item.getConversationMimeType() == CdsConversationMimeType.CHANNEL_CONVERSATION || this.item.getConversationMimeType() == CdsConversationMimeType.CHAT_CONVERSATION || this.item.getConversationMimeType() == CdsConversationMimeType.YAMMER_CONVERSATION) {
                    this.writeXml(loadfile, xmlDocument, documentsXmlElement, null, this.item.getNativeExportPath(), true, this.item.isDuplicateItem());
                    Iterator iterator = this.children.iterator();
                    while (iterator.hasNext()) {
                        LoadfileItem child = (LoadfileItem)iterator.next();
                        boolean childResultOk = child.write(loadfile, xmlDocument, documentsXmlElement, zipOutputStream, errorListener);
                        resultOk = resultOk && childResultOk;
                    }
                    return resultOk;
                }
                if (this.item.getConversationMimeType() == CdsConversationMimeType.REACTION) {
                    this.writeXml(loadfile, xmlDocument, documentsXmlElement, null, this.item.getNativeExportPath(), true, this.item.isDuplicateItem());
                    return true;
                }
            }
            String md5Hash = null;
            boolean skipNativeFile = true;
            try (InputStream inputStream = this.getInputStream();){
                if (inputStream != null && this.item.getNativeExportPath() != null && this.item.getNativeExportPath().endsWith(".msg")) {
                    MapiMessage mapiMessage = CdsUtils.loadEmail(inputStream);
                    try {
                        if (this.item.getConversationSource() == CdsConversationSource.GENERATED) {
                            if (mapiMessage != null) {
                                mapiMessage.setBodyContent(this.item.getContent(), 1);
                                mapiMessage.setSubject(CdsTeamsMessageParser.getChatMessageName(this.item));
                                this.updateMapiMessage(mapiMessage);
                                if (this.item.isCopilotItem()) {
                                    for (MapiAttachment mapiAttachment : new ArrayList(mapiMessage.getAttachments())) {
                                        if (!CdsUtils.isCopilotCardAttachment(mapiAttachment) && !mapiAttachment.getDisplayName().equalsIgnoreCase("TeamsChat")) continue;
                                        mapiMessage.getAttachments().removeMapiAttachment(mapiAttachment);
                                    }
                                }
                            } else {
                                LOGGER.warn("Could not load native msg file " + this.item.getNativeExportPath());
                                this.item.setFailureMessage("Cannot load email");
                                this.item.setFailureDetail("Email could not be loaded: " + this.item.getNativeExportPath());
                            }
                        }
                        ArrayList<String> stubAttachmentNames = new ArrayList<String>();
                        for (LoadfileItem child : this.children) {
                            CdsItem childCdsItem;
                            if (!(child instanceof CdsLoadFileItem) || (childCdsItem = ((CdsLoadFileItem)child).item) == null) continue;
                            if (this.detachRegularAttachments && CdsAttachmentType.REGULAR.equals((Object)childCdsItem.getAttachmentType())) {
                                stubAttachmentNames.add(child.getName());
                            }
                            if (!this.stubModernAttachments || !CdsAttachmentType.MODERN.equals((Object)childCdsItem.getAttachmentType())) continue;
                            stubAttachmentNames.add(child.getName());
                        }
                        if (mapiMessage != null && this.item.getSender() != null) {
                            mapiMessage.setSenderName(this.item.getSender().getPersonal());
                            mapiMessage.setSentRepresentingName(this.item.getSender().getPersonal());
                            mapiMessage.setSenderEmailAddress(this.item.getSender().getAddress());
                            mapiMessage.setSenderSmtpAddress(this.item.getSender().getAddress());
                            mapiMessage.setSentRepresentingEmailAddress(this.item.getSender().getAddress());
                        }
                        if (this.convertToEml) {
                            String sender = AddressUtils.render(this.item.getSender());
                            this.copyStreamAsEml(mapiMessage, zipOutputStream, sender, this.detachRegularAttachments, stubAttachmentNames);
                            skipNativeFile = false;
                        } else if (mapiMessage != null) {
                            if (this.detachRegularAttachments) {
                                mapiMessage.getAttachments().clear();
                            }
                            for (String stubAttachment : stubAttachmentNames) {
                                mapiMessage.getAttachments().add(stubAttachment, new byte[]{0});
                            }
                            this.saveMapiStream(mapiMessage, zipOutputStream, (SaveOptions)SaveOptions.getDefaultMsgUnicode());
                            skipNativeFile = false;
                        } else {
                            LOGGER.warn("Cannot read email MSG, id: " + this.item.getDocumentId());
                            this.copyStream(this.getInputStream(), zipOutputStream);
                            skipNativeFile = false;
                        }
                        if (mapiMessage == null) break block49;
                    }
                    catch (Throwable t) {
                        try {
                            if (skipNativeFile) {
                                this.item.setFailureMessage("Error while modifying MSG");
                                this.item.setFailureDetail("Error while modifying MSG, copying stream " + ExceptionUtils.getStackTrace((Throwable)t));
                                resultOk = false;
                                if (errorListener != null) {
                                    errorListener.onError(this.docId, "Error while modifying MSG", t, false);
                                } else {
                                    LOGGER.warn("Error while modifying MSG, copying stream " + this.docId, t);
                                }
                                this.copyStream(this.getInputStream(), zipOutputStream);
                                skipNativeFile = false;
                            }
                            break block49;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            if (mapiMessage != null) {
                                CdsUtils.closeMapiMessage(mapiMessage);
                            }
                        }
                    }
                    CdsUtils.closeMapiMessage(mapiMessage);
                    break block49;
                }
                if (this.md5 != null && this.md5.length() > 0) {
                    md5Hash = this.md5;
                    if (inputStream != null) {
                        this.copyStream(inputStream, zipOutputStream);
                        skipNativeFile = false;
                    }
                    break block49;
                }
                if (this.item.getFileClass() == CdsFileClassType.CONVERSATION && this.item.getConversationSource() == CdsConversationSource.GENERATED) {
                    MapiMessage generatedChatMessage = null;
                    try {
                        generatedChatMessage = new MapiMessage("placeholder@example.com", "placeholder@example.com", "", this.item.getContent(), 1);
                        this.updateMapiMessage(generatedChatMessage);
                        this.saveMapiStream(generatedChatMessage, zipOutputStream, (SaveOptions)SaveOptions.getDefaultEml());
                        skipNativeFile = false;
                        if (generatedChatMessage == null) break block49;
                    }
                    catch (Throwable throwable) {
                        if (generatedChatMessage == null) throw throwable;
                        CdsUtils.closeMapiMessage(generatedChatMessage);
                        throw throwable;
                    }
                    CdsUtils.closeMapiMessage(generatedChatMessage);
                    break block49;
                }
                if (inputStream != null) {
                    md5Hash = this.copyHashStream(inputStream, zipOutputStream);
                    skipNativeFile = false;
                }
            }
            catch (Exception e) {
                this.item.setFailureMessage("Cannot package native file");
                this.item.setFailureDetail("Error packaging native file, " + ExceptionUtils.getStackTrace((Throwable)e));
                resultOk = false;
                if (errorListener != null) {
                    errorListener.onError(this.docId, "Cannot package native file", e, false);
                } else {
                    LOGGER.warn("Cannot package native file for DocID " + this.docId, (Throwable)e);
                }
            }
            finally {
                if (this.item.getConversationMimeType() != CdsConversationMimeType.CHANNEL_CONVERSATION && this.item.getConversationMimeType() != CdsConversationMimeType.CHAT_CONVERSATION && this.item.getConversationMimeType() != CdsConversationMimeType.YAMMER_CONVERSATION) {
                    this.writeXml(loadfile, xmlDocument, documentsXmlElement, md5Hash, this.item.getNativeExportPath(), skipNativeFile, this.item.isDuplicateItem());
                }
            }
        }
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            LoadfileItem child = (LoadfileItem)iterator.next();
            boolean childResultOk = child.write(loadfile, xmlDocument, documentsXmlElement, zipOutputStream, errorListener);
            resultOk = resultOk && childResultOk;
        }
        return resultOk;
    }

    private void updateMapiMessage(MapiMessage mapiMessage) {
        String senderAddress = this.item.getSender().getAddress();
        try {
            mapiMessage.setSenderEmailAddress(senderAddress);
        }
        catch (Exception e) {
            String normalizedEmailAddress = senderAddress.replaceAll("[^A-Za-z0-9]", "_") + "@placeholder.local";
            LOGGER.warn("Invalid email address " + senderAddress + ", normalized to " + normalizedEmailAddress);
            mapiMessage.setSenderEmailAddress(normalizedEmailAddress);
        }
        mapiMessage.setSenderName(this.item.getSender().getPersonal());
        mapiMessage.getRecipients().clear();
        Set<InternetAddress> participants = this.item.getRecipients();
        if (participants == null) {
            LOGGER.warn("Loadfile item " + this.docId + " has no participants");
        } else {
            for (InternetAddress participant : participants) {
                mapiMessage.getRecipients().add(participant.getAddress(), participant.getPersonal(), 1);
            }
        }
        if (this.item.getDate() != null) {
            mapiMessage.setDeliveryTime(this.item.getDate().toDate());
            mapiMessage.setClientSubmitTime(this.item.getDate().toDate());
        }
    }

    public CdsItem getItem() {
        return this.item;
    }

    public boolean isDetachRegularAttachments() {
        return this.detachRegularAttachments;
    }

    public boolean isStubModernAttachments() {
        return this.stubModernAttachments;
    }

    public void setItem(CdsItem item) {
        this.item = item;
    }

    public void setDetachRegularAttachments(boolean detachRegularAttachments) {
        this.detachRegularAttachments = detachRegularAttachments;
    }

    public void setStubModernAttachments(boolean stubModernAttachments) {
        this.stubModernAttachments = stubModernAttachments;
    }
}

