/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.loadfile;

import com.nuix.automate.workflow.core.utils.cds.CdsCustomMetadata;
import org.apache.commons.lang3.StringEscapeUtils;

public class LoadFileField {
    private String name;
    private String type;
    private boolean edrmField;
    private String normalizedFieldName;
    private boolean loadFileField;
    private int index;

    public LoadFileField(CdsCustomMetadata metadata, String type, boolean edrmField, int index) {
        this.name = StringEscapeUtils.escapeXml11((String)metadata.toString());
        this.type = type;
        this.edrmField = edrmField;
        this.index = index;
        this.loadFileField = false;
        this.normalizedFieldName = this.normalizeFieldIdentifier(this.name);
    }

    public LoadFileField(String name, String type, boolean edrmField, int index) {
        this.name = StringEscapeUtils.escapeXml11((String)name);
        this.type = type;
        this.edrmField = edrmField;
        this.index = index;
        this.loadFileField = false;
        this.normalizedFieldName = this.normalizeFieldIdentifier(name);
    }

    public LoadFileField(CdsCustomMetadata metadata, String type, int index) {
        this.name = StringEscapeUtils.escapeXml11((String)metadata.toString());
        this.type = type;
        this.edrmField = false;
        this.index = index;
        this.loadFileField = false;
        this.normalizedFieldName = this.normalizeFieldIdentifier(this.name);
    }

    public LoadFileField(String name, String type, int index) {
        this.name = StringEscapeUtils.escapeXml11((String)name);
        this.type = type;
        this.edrmField = false;
        this.index = index;
        this.loadFileField = false;
        this.normalizedFieldName = this.normalizeFieldIdentifier(name);
    }

    public LoadFileField(String name, String type, int index, boolean isLoadFileField) {
        this.name = StringEscapeUtils.escapeXml11((String)name);
        this.type = type;
        this.edrmField = false;
        this.index = index;
        this.loadFileField = isLoadFileField;
        this.normalizedFieldName = this.normalizeFieldIdentifier(name);
    }

    public LoadFileField() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isEdrmField() {
        return this.edrmField;
    }

    public void setEdrmField(boolean edrmField) {
        this.edrmField = edrmField;
    }

    public String getNormalizedFieldName() {
        return this.normalizedFieldName;
    }

    public void setNormalizedFieldName(String normalizedFieldName) {
        this.normalizedFieldName = normalizedFieldName;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public boolean isLoadFileField() {
        return this.loadFileField;
    }

    public void setLoadFileField(boolean loadFileField) {
        this.loadFileField = loadFileField;
    }

    private String normalizeFieldIdentifier(String fieldName) {
        String prefix = "_";
        if (this.isLoadFileField()) {
            prefix = "_LF_";
        }
        return prefix + fieldName.replace(' ', '_').replaceAll("[^a-zA-Z0-9_\\-.]", "_");
    }
}

