/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.loadfile;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.workflow.core.utils.loadfile.LoadFileField;
import com.nuix.automate.workflow.core.utils.loadfile.Loadfile;
import com.nuix.automate.workflow.core.utils.loadfile.LoadfileItem;
import com.nuix.automate.workflow.core.utils.loadfile.Relationship;
import com.nuix.automate.workflow.core.utils.loadfile.RelationshipType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LoadfileHandler {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(LoadfileHandler.class);
    private Loadfile loadfile;
    private Map<String, LoadfileItem> topLevelItems;
    private List<Loadfile> loadfiles = new ArrayList<Loadfile>();
    private List<LoadFileField> loadFileFields;

    public LoadfileHandler(List<LoadFileField> loadFileFields) {
        this.topLevelItems = new HashMap<String, LoadfileItem>();
        this.loadfile = new Loadfile(loadFileFields);
        this.loadFileFields = loadFileFields;
        this.loadfiles.add(this.loadfile);
    }

    public List<Loadfile> getLoadFiles() {
        return this.loadfiles;
    }

    public void addTopLevelItem(LoadfileItem loadfileItem) {
        this.topLevelItems.put(loadfileItem.getDocId(), loadfileItem);
    }

    public Map<String, LoadfileItem> getTopLevelItem() {
        return this.topLevelItems;
    }

    public Map<String, LoadFileField> getLoadFileFields() {
        return this.loadfile.getLoadFileFields();
    }

    public void splitLoadfiles(boolean splitExport, int maxLoadfileSize) {
        int currentLoadfileSize = 0;
        for (LoadfileItem topLevelItem : this.topLevelItems.values()) {
            if (splitExport && currentLoadfileSize >= maxLoadfileSize) {
                this.loadfile = new Loadfile(this.loadFileFields);
                this.loadfiles.add(this.loadfile);
                currentLoadfileSize = 0;
            }
            HashSet<Relationship> relationships = new HashSet<Relationship>();
            this.getRelationships(relationships, topLevelItem);
            LOGGER.debug("Size: " + relationships.size());
            currentLoadfileSize += relationships.size();
            this.loadfile.addTopLevelItem(topLevelItem);
            this.loadfile.addRelationships(relationships);
        }
        LOGGER.info("Loadfile count: " + this.loadfiles.size());
    }

    public void getRelationships(Set<Relationship> relationships, LoadfileItem loadfileItem) {
        LOGGER.debug(loadfileItem.location);
        for (LoadfileItem child : loadfileItem.children) {
            relationships.add(new Relationship(loadfileItem.getDocId(), child.getDocId(), RelationshipType.CONTAINER));
            if (child.children.isEmpty()) continue;
            this.getRelationships(relationships, child);
        }
    }
}

