/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.loadfile;

import com.nuix.automate.workflow.core.utils.loadfile.RelationshipType;
import java.util.Objects;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Relationship {
    private String parentDocumentId;
    private String childDocumentId;
    private RelationshipType type;

    public Relationship(String parentDocumentId, String childDocumentId, RelationshipType type) {
        this.parentDocumentId = parentDocumentId;
        this.childDocumentId = childDocumentId;
        this.type = type;
    }

    public Relationship() {
    }

    public String getParentDocumentId() {
        return this.parentDocumentId;
    }

    public void setParentDocumentId(String parentDocumentId) {
        this.parentDocumentId = parentDocumentId;
    }

    public String getChildDocumentId() {
        return this.childDocumentId;
    }

    public void setChildDocumentId(String childDocumentId) {
        this.childDocumentId = childDocumentId;
    }

    public RelationshipType getType() {
        return this.type;
    }

    public void setType(RelationshipType type) {
        this.type = type;
    }

    public void writeRelationshipXml(Document xmlDocument, Element parentRelationshipXmlElement) {
        Element relationshipXmlElement = xmlDocument.createElement("Relationship");
        relationshipXmlElement.setAttribute("ParentDocId", this.parentDocumentId);
        relationshipXmlElement.setAttribute("ChildDocId", this.childDocumentId);
        relationshipXmlElement.setAttribute("Type", this.type.toString());
        parentRelationshipXmlElement.appendChild(relationshipXmlElement);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Relationship that = (Relationship)o;
        return Objects.equals(this.parentDocumentId, that.parentDocumentId) && Objects.equals(this.childDocumentId, that.childDocumentId) && this.type == that.type;
    }

    public int hashCode() {
        int result = Objects.hashCode(this.parentDocumentId);
        result = 31 * result + Objects.hashCode(this.childDocumentId);
        result = 31 * result + Objects.hashCode((Object)this.type);
        return result;
    }
}

