/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.memgraph;

import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.nuix.ExecutionContext;
import com.nuix.automate.workflow.core.utils.memgraph.GraphServiceRestClient;
import com.nuix.automate.workflow.core.utils.memgraph.GraphUtils;
import com.nuix.automate.workflow.core.utils.memgraph.MemgraphJobInfo;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.HashSet;

public class MemgraphUtils
extends GraphUtils {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(MemgraphUtils.class);
    private InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"WorkflowText");
    private GraphServiceRestClient graphServiceRestClient;
    private Operation operation;
    private ExecutionContext executionContext;

    public MemgraphUtils(ExecutionContext executionContext, Operation operation) {
        this.executionContext = executionContext;
        this.operation = operation;
        this.initializeMemgraphServiceClient();
    }

    protected void initializeMemgraphServiceClient() {
        try {
            String graphServiceId = this.executionContext.evalParametersIfSet("{wfn_graph_service_id}", this.operation);
            String schedulerUrl = this.executionContext.evalParametersIfSet("{scheduler_url}", this.operation).trim();
            String bearerToken = this.executionContext.evalProtectedParameter("{job_bearer_token_protected}").trim();
            HashSet<String> whitelistedCertFingerprints = new HashSet<String>();
            try {
                whitelistedCertFingerprints.add(this.executionContext.evalParametersIfSet("{scheduler_cert_fingerprint}", this.operation).trim());
            }
            catch (ParameterException e) {
                LOGGER.info("Not using custom Scheduler cert fingerprint", (Throwable)e);
            }
            this.graphServiceRestClient = new GraphServiceRestClient(graphServiceId, schedulerUrl, bearerToken, whitelistedCertFingerprints);
            this.graphServiceRestClient.setReattemptEnabled(false);
            this.graphServiceRestClient.setOperation(this.operation);
        }
        catch (ParameterException | GeneralSecurityException e) {
            LOGGER.error("Not using Memgraph Service, " + ExceptionUtils.getExceptionPrintableMessage((Throwable)e, (boolean)false));
        }
    }

    @Override
    public Integer getLock() {
        try {
            String guid = this.executionContext.nuixCase.getGuid();
            MemgraphJobInfo memgraphJobInfo = new MemgraphJobInfo();
            memgraphJobInfo.setCaseId(guid);
            memgraphJobInfo.setExecutionState(ExecutionState.NOT_STARTED);
            try {
                memgraphJobInfo.setJobId(this.executionContext.evalParametersIfSet("{job_id}", this.operation));
            }
            catch (ParameterException e) {
                throw new IllegalStateException("Cannot get job info", e);
            }
            LOGGER.debug("Getting Memgraph lock for " + String.valueOf(memgraphJobInfo));
            return this.graphServiceRestClient.requestMemgraphLock(memgraphJobInfo);
        }
        catch (IOException e) {
            LOGGER.error("Cannot get Memgraph lock", (Throwable)e);
            return -1;
        }
    }

    @Override
    public void releaseLock() {
        try {
            MemgraphJobInfo memgraphJobInfo = new MemgraphJobInfo();
            memgraphJobInfo.setExecutionState(ExecutionState.FINISHED);
            try {
                memgraphJobInfo.setJobId(this.executionContext.evalParametersIfSet("{job_id}", this.operation));
            }
            catch (ParameterException e) {
                throw new IllegalStateException("Cannot get job info", e);
            }
            LOGGER.info("Releasing Memgraph lock for " + String.valueOf(memgraphJobInfo));
            this.graphServiceRestClient.requestMemgraphLock(memgraphJobInfo);
        }
        catch (IOException e) {
            LOGGER.error("Cannot release Memgraph lock", (Throwable)e);
        }
    }
}

