/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.nlp;

import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.SchedulerComponent;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.logging.LogChannel;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.nuix.ExecutionContext;
import com.nuix.automate.workflow.core.utils.nlp.NlpRestClient;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.GenericType;
import org.joda.time.DateTime;

public class NlpUtils {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(NlpUtils.class);
    private InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"WorkflowText");
    private NlpRestClient nlpRestClient;
    private Operation operation;
    private ExecutionContext executionContext;

    public NlpUtils(ExecutionContext executionContext, Operation operation) throws GeneralSecurityException, ParameterException, IOException {
        this.executionContext = executionContext;
        this.operation = operation;
        this.initializeNlpServiceClient();
        this.testConnection();
    }

    protected void initializeNlpServiceClient() throws ParameterException, GeneralSecurityException {
        String apiUrl = this.executionContext.evalParametersIfSet("{wfn_nlp_url}", this.operation).trim();
        String feedsUrl = this.executionContext.evalParametersIfSet("{wfn_nlp_feeds_url}", this.operation).trim();
        String jobsUrl = this.executionContext.evalParametersIfSet("{wfn_nlp_jobs_url}", this.operation).trim();
        String nlpCredential = this.executionContext.evalProtectedParameter("{wfn_nlp_api_token_protected}");
        HashSet<String> whitelistedCertFingerprints = new HashSet<String>();
        whitelistedCertFingerprints.addAll(this.executionContext.evalJsonParameter("{wfn_nlp_whitelisted_cert_fingerprints}", Set.class, this.operation));
        LogChannel logChannel = new LogChannel(UidUtils.getRandom(), this.executionContext.evalParameters("{job_id}", this.operation), null, SchedulerComponent.API_CLIENT, DateTime.now().getMillis());
        this.nlpRestClient = new NlpRestClient(UidUtils.getRandom(), apiUrl, feedsUrl, jobsUrl, nlpCredential, whitelistedCertFingerprints, logChannel);
    }

    public String createMemgraphPersistance(String name, String hostname, int port, String username, String password, String playbookName) throws IOException {
        LOGGER.info("Creating NLP Memgraph persistance to " + hostname + " on port " + port + " with playbook " + playbookName);
        this.nlpRestClient.retrieveAccessToken();
        String url = this.nlpRestClient.getFeedsApiUrl() + "/persist/createMG?name=" + FormattingUtils.encodeForUrl((String)name) + "&ssl=FALSE&hostname=" + FormattingUtils.encodeForUrl((String)hostname) + "&dbPortNumber=" + port + "&playbookName=" + FormattingUtils.encodeForUrl((String)playbookName) + (String)(username != null && !username.trim().isEmpty() ? "&dbUsername=" + FormattingUtils.encodeForUrl((String)username) + "&dbPassword=" + FormattingUtils.encodeForUrl((String)password) : "") + "&enabled=true";
        Object logUrl = username == null ? url : url.replace(FormattingUtils.encodeForUrl((String)password), "REDACTED");
        Map response = this.nlpRestClient.callApi(url, (String)logUrl, "POST", null, new GenericType<Map>(){});
        LOGGER.info("NLP API response status: " + String.valueOf(response.get("status")) + ", message: " + String.valueOf(response.get("message")));
        String error = null;
        try {
            String status = ((Map)response.get("response")).get("status").toString();
            if (status.equals("ERROR")) {
                error = "API error, see log for details";
                error = ((Map)response.get("response")).get("error").toString();
            }
        }
        catch (Exception status) {
            // empty catch block
        }
        if (error != null) {
            throw new IOException("Cannot create Memgraph persistence, " + error);
        }
        try {
            String graphId = ((Map)response.get("response")).get("id").toString();
            return graphId;
        }
        catch (Exception e) {
            LOGGER.error("Cannot parse Graph ID from API response " + SerializationUtils.toJson((Object)response));
            throw new IOException(response.get("message").toString());
        }
    }

    public void deleteMemgraphPersistance() throws IOException {
        LOGGER.info("Deleting NLP Memgraph persistence");
        this.nlpRestClient.retrieveAccessToken();
        String url = this.nlpRestClient.getFeedsApiUrl() + "/persist/deleteMG";
        Map response = this.nlpRestClient.callApi(url, url, "POST", null, new GenericType<Map>(){});
        LOGGER.info("NLP API response status: " + String.valueOf(response.get("status")) + ", message: " + String.valueOf(response.get("message")));
    }

    public void deletePlaybook(String playbookName) throws IOException {
        LOGGER.info("Deleting NLP Memgraph playbook " + playbookName);
        this.nlpRestClient.retrieveAccessToken();
        String url = this.nlpRestClient.getFeedsApiUrl() + "/playbook/deletePlaybook?name=" + FormattingUtils.encodeForUrl((String)playbookName);
        Map response = this.nlpRestClient.callApi(url, url, "DELETE", new GenericType<Map>(){});
        LOGGER.info("NLP API response status: " + String.valueOf(response.get("status")) + ", message: " + String.valueOf(response.get("message")));
    }

    public void createPlaybook(String playbookName, String playbookContents) throws IOException {
        LOGGER.info("Creating NLP Memgraph playbook " + playbookName + " with " + playbookContents.length() + " bytes");
        this.nlpRestClient.retrieveAccessToken();
        String url = this.nlpRestClient.getFeedsApiUrl() + "/playbook/createPlaybook?name=" + FormattingUtils.encodeForUrl((String)playbookName);
        Map response = this.nlpRestClient.callApi(url, url, "POST", playbookContents, new GenericType<Map>(){});
        LOGGER.info("NLP API response status: " + String.valueOf(response.get("status")) + ", message: " + String.valueOf(response.get("message")));
    }

    public void testConnection() throws IOException {
        LOGGER.info("Testing NLP API connection");
        this.nlpRestClient.retrieveAccessToken();
        String url = this.nlpRestClient.getFeedsApiUrl() + "/info/retrieve";
        try {
            Map response = this.nlpRestClient.callApi(url, url, "POST", null, new GenericType<Map>(){});
            LOGGER.info("NLP API response status: " + String.valueOf(response.get("status")) + ", message: " + String.valueOf(response.get("message")));
        }
        catch (IOException e) {
            throw new IOException("Cannot query NLP API " + url);
        }
    }
}

