/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.nuix;

import com.nuix.automate.utils.general.AdaptiveThreadPoolExecutorFactory;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.nuix.CustomDeduplicationField;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import nuix.Address;
import nuix.Case;
import nuix.Communication;
import nuix.Item;
import nuix.ProductionSetItem;
import org.joda.time.DateTime;
import org.openimaj.util.parallel.Parallel;
import org.openimaj.util.parallel.partition.FixedSizeChunkPartitioner;
import org.openimaj.util.parallel.partition.Partitioner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemsUtils {
    private static final Logger log = LoggerFactory.getLogger(ItemsUtils.class);
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ItemsUtils.class);
    private static final String[] messageIdPropertyNames = new String[]{"Message-ID", "Mapi-Smtp-Message-Id", "X-Message-ID", "X-Mapi-Smtp-Message-Id", "Mapi-X-Message-Id", "Mapi-X-Smtp-Message-Id", "$MessageID", "PR_INTERNET_MESSAGE_ID"};
    private static final String[] mapiSearchKeyPropertyNames = new String[]{"Mapi-Search-Key", "X-Mapi-Search-Key"};
    private static ItemsUtils instance = null;
    private static boolean stopRequested;

    public static synchronized ItemsUtils getInstance() {
        if (instance == null) {
            instance = new ItemsUtils();
        }
        return instance;
    }

    public static boolean copyItemText(Reader reader, StringBuilder sb, long maxSize, String suffixTrim) throws IOException {
        int readSize;
        char[] buffer = new char[0x100000];
        long totalReadSize = 0L;
        boolean trimmed = false;
        while ((readSize = reader.read(buffer)) != -1) {
            if ((long)readSize + totalReadSize > maxSize) {
                readSize = (int)(maxSize - totalReadSize);
                trimmed = true;
            }
            sb.append(buffer, 0, readSize);
            totalReadSize += (long)readSize;
            if (!trimmed) continue;
            sb.append(suffixTrim);
            return false;
        }
        return true;
    }

    public static boolean getItemPropertiesToString(Item item, StringBuilder sb, long maxSize, String suffixTrim) {
        long length = 0L;
        boolean overflow = false;
        for (Map.Entry entry : item.getProperties().entrySet()) {
            String propertyName = (String)entry.getKey();
            String propertyValue = String.valueOf(entry.getValue());
            Object line = propertyName + ":\t" + propertyValue + "\n";
            long remainingCharacters = maxSize - length;
            if ((long)((String)line).length() > remainingCharacters) {
                line = ((String)line).substring(0, (int)remainingCharacters);
                overflow = true;
            }
            sb.append((String)line);
            if (!overflow) continue;
            sb.append(suffixTrim);
            break;
        }
        return !overflow;
    }

    public static boolean getItemMetadataFieldToString(Item item, String metadataFieldName, String defaultValue, StringBuilder sb, long maxSize, String suffixTrim) {
        Object result = item.getCustomMetadata().get((Object)metadataFieldName);
        if (result == null) {
            sb.append(defaultValue);
            return false;
        }
        String metadataValue = result.toString();
        if ((long)metadataValue.length() < maxSize) {
            sb.append(metadataValue);
            return false;
        }
        sb.append(metadataValue, 0, (int)maxSize);
        sb.append(suffixTrim);
        return true;
    }

    public static boolean copyItemText(Item item, StringBuilder sb, long maxSize, String suffixTrim) throws IOException {
        try {
            AtomicBoolean atomicBoolean = new AtomicBoolean(true);
            if (item.getTextObject().isAvailable()) {
                item.getTextObject().usingText(reader -> {
                    atomicBoolean.set(ItemsUtils.copyItemText(reader, sb, maxSize, suffixTrim));
                    return null;
                });
            } else {
                atomicBoolean.set(ItemsUtils.getItemPropertiesToString(item, sb, maxSize, suffixTrim));
            }
            return atomicBoolean.get();
        }
        catch (IOException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Cannot get text for item " + item.getGuid(), (Throwable)e);
            }
            throw e;
        }
        catch (Throwable t) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Cannot get text for item " + item.getGuid() + " with usingText()", t);
            }
            if (item.getTextObject().isAvailable()) {
                Reader reader2 = item.getTextObject().getReader();
                return ItemsUtils.copyItemText(reader2, sb, maxSize, suffixTrim);
            }
            return ItemsUtils.getItemPropertiesToString(item, sb, maxSize, suffixTrim);
        }
    }

    public static String getCommunicationHeader(Item item) {
        Communication communication = item.getCommunication();
        StringBuilder stringBuilder = new StringBuilder();
        ItemsUtils.appendCommunicationParticipant(stringBuilder, "From", communication.getFrom());
        DateTime communicationDate = communication.getDateTime();
        if (communicationDate != null) {
            stringBuilder.append("Sent: " + FormattingUtils.dateTimeToEmailDateTimeString((DateTime)communication.getDateTime()) + "\n");
        }
        ItemsUtils.appendCommunicationParticipant(stringBuilder, "To", communication.getTo());
        ItemsUtils.appendCommunicationParticipant(stringBuilder, "Cc", communication.getCc());
        ItemsUtils.appendCommunicationParticipant(stringBuilder, "Bcc", communication.getBcc());
        return stringBuilder.toString();
    }

    private static void appendCommunicationParticipant(StringBuilder stringBuilder, String name, List<Address> addresses) {
        if (addresses.size() > 0) {
            boolean firstAddress = true;
            for (Address address : addresses) {
                if (firstAddress) {
                    stringBuilder.append(name + ": ");
                    firstAddress = false;
                } else {
                    stringBuilder.append("; ");
                }
                stringBuilder.append(address.toDisplayString());
            }
            stringBuilder.append("\n");
        }
    }

    public static void stopBackgroundTask() {
        stopRequested = true;
    }

    public static Map<String, Set<String>> getItemGuidToDocIdsDictionary(Case nuixCase, Set<Item> items) throws IOException {
        stopRequested = false;
        ConcurrentHashMap<String, Set<String>> result = new ConcurrentHashMap<String, Set<String>>(items.size());
        FixedSizeChunkPartitioner itemsPartitioner = new FixedSizeChunkPartitioner(items, ItemsUtils.getPartitionerChunkSize(1000, null));
        Parallel.forEachPartitioned((Partitioner)itemsPartitioner, iterator -> {
            while (iterator.hasNext()) {
                Item item = (Item)iterator.next();
                String guid = item.getGuid();
                result.put(guid, new TreeSet());
            }
        }, (ThreadPoolExecutor)AdaptiveThreadPoolExecutorFactory.newAdaptiveThreadPoolExecutor());
        nuixCase.getProductionSets().forEach(productionSet -> {
            if (stopRequested) {
                return;
            }
            List productionSetItems = productionSet.getProductionSetItems();
            FixedSizeChunkPartitioner partitioner = new FixedSizeChunkPartitioner((Iterable)productionSetItems, ItemsUtils.getPartitionerChunkSize(1000, null));
            Parallel.forEachPartitioned((Partitioner)partitioner, iterator -> {
                if (stopRequested) {
                    return;
                }
                while (iterator.hasNext()) {
                    ProductionSetItem productionSetItem = (ProductionSetItem)iterator.next();
                    String guid = productionSetItem.getItem().getGuid();
                    if (!result.containsKey(guid)) continue;
                    String docId = productionSetItem.getDocumentNumber().toString();
                    Set docIds = (Set)result.get(guid);
                    docIds.add(docId);
                }
            }, (ThreadPoolExecutor)AdaptiveThreadPoolExecutorFactory.newAdaptiveThreadPoolExecutor());
        });
        return result;
    }

    public static String getItemPath(Item item) {
        List pathNames = item.getPathNames();
        return "\\" + String.join((CharSequence)"\\", pathNames.subList(0, pathNames.size() - 1));
    }

    public static String getItemPathWithoutEvidenceName(Item item) {
        List pathNames = item.getPathNames();
        if (pathNames.size() > 0) {
            return "\\" + String.join((CharSequence)"\\", pathNames.subList(1, pathNames.size() - 1));
        }
        return "\\";
    }

    public static List<Set<Item>> findItemsAndMaterialDescendantsTopLevelVsNonTopLevel(Collection<Item> itemSet) {
        HashSet<Item> topLevelItems = new HashSet<Item>();
        HashSet<Item> nonTopLevelItems = new HashSet<Item>();
        if (!itemSet.isEmpty()) {
            HashSet<String> guidsProcessed = new HashSet<String>();
            for (Item item : itemSet) {
                String itemGuid = item.getGuid();
                if (guidsProcessed.contains(itemGuid)) continue;
                if (item.isAudited()) {
                    if (item.isTopLevel()) {
                        topLevelItems.add(item);
                    } else {
                        nonTopLevelItems.add(item);
                    }
                }
                for (Item descendant : item.getDescendants()) {
                    String descendantGuid = descendant.getGuid();
                    if (!guidsProcessed.contains(descendantGuid) && descendant.isAudited()) {
                        if (descendant.isTopLevel()) {
                            topLevelItems.add(descendant);
                        } else {
                            nonTopLevelItems.add(descendant);
                        }
                    }
                    guidsProcessed.add(descendantGuid);
                }
                guidsProcessed.add(itemGuid);
            }
        }
        ArrayList<Set<Item>> result = new ArrayList<Set<Item>>();
        result.add(topLevelItems);
        result.add(nonTopLevelItems);
        return result;
    }

    public static Set<Item> findItemsAndDescendants(Collection<Item> itemSet) {
        if (itemSet.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Item> result = new HashSet<Item>();
        for (Item item : itemSet) {
            boolean isNewItem = result.add(item);
            if (!isNewItem) continue;
            result.addAll(item.getDescendants());
        }
        return result;
    }

    public static Set<Item> findItemsAndMaterialDescendants(Collection<Item> itemSet) {
        if (itemSet.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Item> result = new HashSet<Item>();
        HashSet<String> guidsProcessed = new HashSet<String>();
        for (Item item : itemSet) {
            String itemGuid = item.getGuid();
            if (guidsProcessed.contains(itemGuid)) continue;
            if (item.isAudited()) {
                result.add(item);
            }
            for (Item descendant : item.getDescendants()) {
                String descendantGuid = descendant.getGuid();
                if (!guidsProcessed.contains(descendantGuid) && descendant.isAudited()) {
                    result.add(descendant);
                }
                guidsProcessed.add(descendantGuid);
            }
            guidsProcessed.add(itemGuid);
        }
        return result;
    }

    private static String prependCustodian(String key, Item item) {
        String custodian = item.getCustodian();
        if (custodian == null) {
            return key;
        }
        return custodian + "-" + key;
    }

    public static String getItemKeyOrGuid(Item item, CustomDeduplicationField customDeduplicationField) {
        String md5;
        String[] propertyNames;
        Map itemProperties = item.getProperties();
        if (customDeduplicationField == CustomDeduplicationField.MESSAGE_ID || customDeduplicationField == CustomDeduplicationField.MESSAGE_ID_MD5 || customDeduplicationField == CustomDeduplicationField.MESSAGE_ID_MD5_CUSTODIAN) {
            propertyNames = messageIdPropertyNames;
        } else if (customDeduplicationField == CustomDeduplicationField.MAPI_SEARCH_KEY) {
            propertyNames = mapiSearchKeyPropertyNames;
        } else {
            LOGGER.error("Unimplemented custom deduplication field " + String.valueOf((Object)customDeduplicationField));
            return null;
        }
        for (String propertyName : propertyNames) {
            Object itemKey;
            String itemKeyRepresentation;
            if (!itemProperties.containsKey(propertyName) || (itemKeyRepresentation = (itemKey = itemProperties.get(propertyName)) instanceof byte[] ? new String((byte[])itemKey, StandardCharsets.UTF_8) : itemProperties.get(propertyName).toString()).length() <= 0) continue;
            itemKeyRepresentation = itemKeyRepresentation.replaceAll("[^\\x20-\\x7e]", "");
            if (customDeduplicationField == CustomDeduplicationField.MESSAGE_ID_MD5_CUSTODIAN) {
                return ItemsUtils.prependCustodian(itemKeyRepresentation, item);
            }
            return itemKeyRepresentation;
        }
        if ((customDeduplicationField == CustomDeduplicationField.MESSAGE_ID_MD5 || customDeduplicationField == CustomDeduplicationField.MESSAGE_ID_MD5_CUSTODIAN) && (md5 = item.getDigests().getMd5()) != null) {
            String itemKeyRepresentation = item.getDigests().getMd5();
            if (customDeduplicationField == CustomDeduplicationField.MESSAGE_ID_MD5_CUSTODIAN) {
                return ItemsUtils.prependCustodian(itemKeyRepresentation, item);
            }
            return itemKeyRepresentation;
        }
        return item.getGuid();
    }

    public static Map<String, String> guidToKey(Collection<Item> items, CustomDeduplicationField customDeduplicationField, AtomicLong itemsProcessed) {
        stopRequested = false;
        itemsProcessed.set(0L);
        ConcurrentHashMap<String, String> guidToKey = new ConcurrentHashMap<String, String>();
        FixedSizeChunkPartitioner partitioner = new FixedSizeChunkPartitioner(items, ItemsUtils.getPartitionerChunkSize(1000, null));
        Parallel.forEachPartitioned((Partitioner)partitioner, iterator -> {
            if (stopRequested) {
                return;
            }
            while (iterator.hasNext()) {
                Item item = (Item)iterator.next();
                String guid = item.getGuid();
                String key = ItemsUtils.getItemKeyOrGuid(item, customDeduplicationField);
                guidToKey.put(guid, key);
                itemsProcessed.incrementAndGet();
            }
        }, (ThreadPoolExecutor)AdaptiveThreadPoolExecutorFactory.newAdaptiveThreadPoolExecutor());
        return guidToKey;
    }

    public static Set<Item> getItemsCustomDuplicates(Set<Item> originals, Set<Item> items, CustomDeduplicationField customDeduplicationField) {
        stopRequested = false;
        ConcurrentHashMap.KeySetView originalKeys = ConcurrentHashMap.newKeySet();
        FixedSizeChunkPartitioner partitioner = new FixedSizeChunkPartitioner(originals, ItemsUtils.getPartitionerChunkSize(1000, null));
        Parallel.forEachPartitioned((Partitioner)partitioner, iterator -> {
            while (iterator.hasNext()) {
                if (stopRequested) {
                    return;
                }
                Item item = (Item)iterator.next();
                String itemKey = ItemsUtils.getItemKeyOrGuid(item, customDeduplicationField);
                originalKeys.add(itemKey);
            }
        }, (ThreadPoolExecutor)AdaptiveThreadPoolExecutorFactory.newAdaptiveThreadPoolExecutor());
        ConcurrentHashMap.KeySetView duplicates = ConcurrentHashMap.newKeySet();
        partitioner = new FixedSizeChunkPartitioner(items, ItemsUtils.getPartitionerChunkSize(1000, null));
        Parallel.forEachPartitioned((Partitioner)partitioner, iterator -> {
            while (iterator.hasNext()) {
                if (stopRequested) {
                    return;
                }
                Item item = (Item)iterator.next();
                String itemKey = ItemsUtils.getItemKeyOrGuid(item, customDeduplicationField);
                if (!originalKeys.contains(itemKey) || originals.contains(item)) continue;
                duplicates.add(item);
            }
        }, (ThreadPoolExecutor)AdaptiveThreadPoolExecutorFactory.newAdaptiveThreadPoolExecutor());
        return duplicates;
    }

    public List<String> getPathNamesInsideFamily(Item item) {
        ArrayList<String> pathNamesInsideFamily = new ArrayList<String>();
        for (Item pathItem = item; pathItem != null && !pathItem.isTopLevel(); pathItem = (Item)pathItem.getParent()) {
            pathNamesInsideFamily.add(pathItem.getName());
        }
        return pathNamesInsideFamily;
    }

    public boolean hasPathNamesInsideFamily(Item item, List<String> customPathNames) {
        Item pathItem = item;
        for (String customPathName : customPathNames) {
            if (pathItem != null) {
                String name = pathItem.getName();
                if (name == null || !name.equals(customPathName)) {
                    return false;
                }
                pathItem = (Item)pathItem.getParent();
                continue;
            }
            return false;
        }
        return pathItem != null && pathItem.isTopLevel();
    }

    private long getItemAuditedSize(Item item) {
        long size;
        block2: {
            size = 0L;
            try {
                size = item.getAuditedSize();
            }
            catch (Exception e) {
                if (!LOGGER.isDebugEnabled()) break block2;
                LOGGER.debug("Cannot get audited size of item " + item.getGuid(), (Throwable)e);
            }
        }
        return size;
    }

    public long getItemsAuditedSize(Collection<Item> items) {
        LOGGER.info("Getting audited size for " + items.size() + " items");
        FixedSizeChunkPartitioner partitioner = new FixedSizeChunkPartitioner(items, ItemsUtils.getPartitionerChunkSize(1000, null));
        AtomicLong auditedSize = new AtomicLong();
        try {
            Parallel.forEachPartitioned((Partitioner)partitioner, iterator -> {
                while (iterator.hasNext()) {
                    Item item = (Item)iterator.next();
                    auditedSize.addAndGet(this.getItemAuditedSize(item));
                }
            }, (ThreadPoolExecutor)AdaptiveThreadPoolExecutorFactory.newAdaptiveThreadPoolExecutor());
        }
        catch (Exception e) {
            LOGGER.warn("Exception thrown while processing items", (Throwable)e);
        }
        return auditedSize.get();
    }

    public static int getPartitionerChunkSize(int defaultSize, Operation operation) {
        try {
            return Integer.parseInt(System.getProperty("nuix.automate.parallel." + operation.getOperationAlias().getAlias() + ".chunkSize"));
        }
        catch (Exception e) {
            return defaultSize;
        }
    }
}

