/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.nuix;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Set;
import nuix.Item;
import nuix.MetadataItem;

public class MetadataItemUtils {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(MetadataItemUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String evaluate(MetadataItem metadataItem, Item item, Set<String> rubyFieldNames) throws Exception {
        if (rubyFieldNames.contains(metadataItem.getName())) {
            Set<String> set = rubyFieldNames;
            synchronized (set) {
                String result = metadataItem.evaluate(item);
                if (result == null) {
                    result = "";
                }
                return result;
            }
        }
        String result = metadataItem.evaluate(item);
        if (result == null) {
            result = "";
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object evaluateUnformatted(MetadataItem metadataItem, Item item, Set<String> rubyFieldNames) throws Exception {
        if (rubyFieldNames.contains(metadataItem.getName())) {
            Set<String> set = rubyFieldNames;
            synchronized (set) {
                return metadataItem.evaluateUnformatted(item);
            }
        }
        return metadataItem.evaluateUnformatted(item);
    }

    public static boolean isRubyScript(MetadataItem metadataItem) {
        String scriptType = MetadataItemUtils.getScriptType(metadataItem);
        return scriptType != null && scriptType.equalsIgnoreCase("ruby");
    }

    private static String getScriptType(MetadataItem metadataItem) {
        return MetadataItemUtils.logObjectReflectionInfo("", metadataItem, metadataItem.getClass(), ObjectType.OBJECT, false);
    }

    /*
     * WARNING - void declaration
     */
    private static String logObjectReflectionInfo(String prefix, Object o, Class c, ObjectType objectType, boolean logEnabled) {
        String result;
        Class superClass;
        String result2;
        String fieldValue;
        Field[] fields;
        if (prefix.length() > 5) {
            return null;
        }
        if (logEnabled) {
            LOGGER.info(prefix + "==== Inspection " + String.valueOf((Object)objectType) + "\t" + c.toString() + " " + o.toString());
        }
        if (objectType == ObjectType.OBJECT) {
            Method[] methods = c.getDeclaredMethods();
            for (AccessibleObject accessibleObject : methods) {
                if (logEnabled) {
                    LOGGER.info(prefix + "Method: " + ((Method)accessibleObject).getName() + "\t" + String.valueOf(((Method)accessibleObject).getReturnType()) + "\t" + ((Method)accessibleObject).toString());
                }
                if (!((Method)accessibleObject).getName().equals("getInvocationHandler")) continue;
                try {
                    if (logEnabled) {
                        LOGGER.info(prefix + "Attempting to get invocation handler");
                    }
                    Object invocationHandlerO = ((Method)accessibleObject).invoke(o, o);
                    InvocationHandler invocationHandler = (InvocationHandler)invocationHandlerO;
                    String result22 = MetadataItemUtils.logObjectReflectionInfo(prefix + "\t", invocationHandlerO, invocationHandlerO.getClass(), ObjectType.INVOCATION_HANDLER, logEnabled);
                    if (result22 != null) {
                        return result22;
                    }
                }
                catch (Exception e) {
                    if (!logEnabled) continue;
                    LOGGER.info(prefix + " Cannot invoke method, " + e.getMessage());
                }
            }
        }
        if (objectType == ObjectType.INVOCATION_HANDLER) {
            fields = c.getDeclaredFields();
            for (AccessibleObject accessibleObject : fields) {
                block27: {
                    ((Field)accessibleObject).setAccessible(true);
                    fieldValue = "n/a";
                    try {
                        if (((Field)accessibleObject).get(o) == null) continue;
                        fieldValue = ((Field)accessibleObject).get(o).toString();
                    }
                    catch (IllegalAccessException e) {
                        if (!logEnabled) break block27;
                        LOGGER.info(prefix + " Cannot get field value, " + e.getMessage());
                    }
                }
                if (logEnabled) {
                    LOGGER.info(prefix + "Field: " + ((Field)accessibleObject).getName() + "\t" + String.valueOf(((Field)accessibleObject).getType()) + "\t" + fieldValue);
                }
                if (!fieldValue.contains("com.nuix.script.impl.metadata")) continue;
                try {
                    Object implementation = ((Field)accessibleObject).get(o);
                    result2 = MetadataItemUtils.logObjectReflectionInfo(prefix + "\t", implementation, implementation.getClass(), ObjectType.IMPLEMENTATION, logEnabled);
                    if (result2 == null) continue;
                    return result2;
                }
                catch (Exception e) {
                    if (!logEnabled) continue;
                    LOGGER.info(prefix + " Cannot case field value, " + e.getMessage());
                }
            }
        }
        if (objectType == ObjectType.IMPLEMENTATION) {
            void var9_16;
            Method[] methods;
            fields = c.getDeclaredFields();
            for (AccessibleObject accessibleObject : fields) {
                block28: {
                    ((Field)accessibleObject).setAccessible(true);
                    fieldValue = "n/a";
                    try {
                        if (((Field)accessibleObject).get(o) == null) continue;
                        fieldValue = ((Field)accessibleObject).get(o).toString();
                    }
                    catch (IllegalAccessException e) {
                        if (!logEnabled) break block28;
                        LOGGER.info(prefix + " Cannot get field value, " + e.getMessage());
                    }
                }
                if (logEnabled) {
                    LOGGER.info(prefix + "Field: " + ((Field)accessibleObject).getName() + "\t" + String.valueOf(((Field)accessibleObject).getType()) + "\t" + fieldValue);
                }
                if (c.getCanonicalName().contains("ScriptedExpression") && ((Field)accessibleObject).getName().equals("type")) {
                    return fieldValue;
                }
                try {
                    Object product = ((Field)accessibleObject).get(o);
                    result2 = MetadataItemUtils.logObjectReflectionInfo(prefix + "\t", product, product.getClass(), ObjectType.IMPLEMENTATION, logEnabled);
                    if (result2 == null) continue;
                    return result2;
                }
                catch (Exception e) {
                    if (!logEnabled) continue;
                    LOGGER.info(prefix + " Cannot case field value, " + String.valueOf(e));
                }
            }
            Method[] methodArray = methods = c.getDeclaredMethods();
            int n = methodArray.length;
            boolean bl = false;
            while (var9_16 < n) {
                Method method = methodArray[var9_16];
                if (logEnabled) {
                    LOGGER.info(prefix + "Method: " + method.getName() + "\t" + String.valueOf(method.getReturnType()) + "\t" + method.toString());
                }
                ++var9_16;
            }
        }
        if ((superClass = c.getSuperclass()) != null && superClass != c && (result = MetadataItemUtils.logObjectReflectionInfo(prefix, o, superClass, objectType, logEnabled)) != null) {
            return result;
        }
        return null;
    }

    static enum ObjectType {
        OBJECT,
        INVOCATION_HANDLER,
        IMPLEMENTATION,
        OTHER;

    }
}

