/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.nuix;

import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.nuix.ExecutionContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TreeSet;
import nuix.EvidenceContainer;
import nuix.locations.Location;
import nuix.locations.LocationFactory;
import nuix.locations.MicrosoftGraphLocation;
import org.joda.time.DateTime;

public class MicrosoftGraphUtils {
    protected static transient InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"WorkflowText");

    public static void addEvidence(ExecutionContext executionContext, Operation currentOperation, EvidenceContainer evidenceContainer) throws ParameterException {
        Integer ms_graph_version_limit;
        Boolean ms_graph_version_retrieval;
        String ms_graph_user_principal_names;
        String ms_graph_team_names;
        String ms_graph_mailbox_retrievals;
        MicrosoftGraphLocation graphLocation;
        LocationFactory locationFactory = executionContext.nuixUtilities.getLocationFactory();
        String ms_graph_tenant_id = executionContext.evalStringParameter("{ms_graph_tenant_id}", currentOperation);
        currentOperation.addExecutionLog(iu.getFormattedString("AddEvidenceOperation.Log.MsGraphTenantId", (Object)ms_graph_tenant_id));
        String ms_graph_client_id = executionContext.evalStringParameter("{ms_graph_client_id}", currentOperation);
        currentOperation.addExecutionLog(iu.getFormattedString("AddEvidenceOperation.Log.MsGraphClientId", (Object)ms_graph_client_id));
        String ms_graph_username = executionContext.evalStringParameter("{ms_graph_username}", currentOperation);
        if (ms_graph_username != null) {
            currentOperation.addExecutionLog(iu.getFormattedString("AddEvidenceOperation.Log.MsGraphUsername", (Object)ms_graph_username));
        }
        String ms_graph_password = executionContext.evalProtectedStringParameter("{ms_graph_password}", currentOperation);
        String ms_graph_client_secret_protected = executionContext.evalProtectedStringParameter("{ms_graph_client_secret_protected}", currentOperation);
        if (ms_graph_client_secret_protected != null) {
            currentOperation.addExecutionLog(iu.getString("AddEvidenceOperation.Log.MsGraphClientSecretAuthentication"));
            graphLocation = locationFactory.makeMicrosoftGraphLocation(ms_graph_tenant_id, ms_graph_client_id, ms_graph_client_secret_protected.toCharArray(), ms_graph_username, ms_graph_password != null ? ms_graph_password.toCharArray() : null);
        } else {
            String ms_graph_certificate_store_path = executionContext.evalStringParameter("{ms_graph_certificate_store_path}", currentOperation);
            currentOperation.addExecutionLog(iu.getFormattedString("AddEvidenceOperation.Log.MsGraphCertificateStorePath", (Object)ms_graph_certificate_store_path));
            String ms_graph_certificate_store_password = executionContext.evalProtectedStringParameter("{ms_graph_certificate_store_password}", currentOperation);
            graphLocation = locationFactory.makeMicrosoftGraphLocation(ms_graph_tenant_id, ms_graph_client_id, ms_graph_certificate_store_path, ms_graph_certificate_store_password.toCharArray(), ms_graph_username, ms_graph_password != null ? ms_graph_password.toCharArray() : null);
        }
        DateTime ms_graph_start_datetime = executionContext.evalDateTimeParameter("{ms_graph_start_datetime}", currentOperation);
        currentOperation.addExecutionLog(iu.getFormattedString("AddEvidenceOperation.Log.MsGraphStartTime", (Object)ms_graph_start_datetime));
        graphLocation = graphLocation.withStartDate(ms_graph_start_datetime);
        DateTime ms_graph_end_datetime = executionContext.evalDateTimeParameter("{ms_graph_end_datetime}", currentOperation);
        currentOperation.addExecutionLog(iu.getFormattedString("AddEvidenceOperation.Log.MsGraphEndTime", (Object)ms_graph_end_datetime));
        graphLocation = graphLocation.withEndDate(ms_graph_end_datetime);
        String ms_graph_retrievals = executionContext.evalStringParameter("{ms_graph_retrievals}", currentOperation);
        if (ms_graph_retrievals != null) {
            String[] retrievalSplits = ms_graph_retrievals.split(",");
            HashSet<String> retrievals = new HashSet<String>();
            for (String retrievalSplit : retrievalSplits) {
                retrievals.add(retrievalSplit.trim());
            }
            graphLocation = graphLocation.withRetrievals(retrievals);
            currentOperation.addExecutionLog(iu.getFormattedString("AddEvidenceOperation.Log.MsGraphRetriavals", (Object)String.join((CharSequence)", ", retrievals)));
        }
        if ((ms_graph_mailbox_retrievals = executionContext.evalStringParameter("{ms_graph_mailbox_retrievals}", currentOperation)) != null) {
            throw new ParameterException("Parameter {ms_graph_mailbox_retrievals} is not supported. Please use {ms_graph_mail_folder_retrievals} instead.");
        }
        String ms_graph_mail_folder_retrievals = executionContext.evalStringParameter("{ms_graph_mail_folder_retrievals}", currentOperation);
        if (ms_graph_mail_folder_retrievals != null) {
            String[] retrievalSplits = ms_graph_mail_folder_retrievals.split(",");
            HashSet<String> retrievals = new HashSet<String>();
            for (String retrievalSplit : retrievalSplits) {
                retrievals.add(retrievalSplit.trim());
            }
            graphLocation = graphLocation.withMailFolderRetrievals(retrievals);
            currentOperation.addExecutionLog(iu.getFormattedString("AddEvidenceOperation.Log.MsGraphMailFolderRetrievals", (Object)String.join((CharSequence)", ", retrievals)));
        }
        if ((ms_graph_team_names = executionContext.evalStringParameter("{ms_graph_team_names}", currentOperation)) != null) {
            String[] namesSplit = ms_graph_team_names.split(",");
            TreeSet<String> names = new TreeSet<String>();
            for (String retrievalSplit : namesSplit) {
                names.add(retrievalSplit.trim());
            }
            graphLocation = graphLocation.withTeamNames(new ArrayList(names));
            currentOperation.addExecutionLog(iu.getFormattedString("AddEvidenceOperation.Log.MsGraphTeamNames", (Object)String.join((CharSequence)", ", names)));
        }
        if ((ms_graph_user_principal_names = executionContext.evalStringParameter("{ms_graph_user_principal_names}", currentOperation)) != null) {
            String[] namesSplit = ms_graph_user_principal_names.split(",");
            TreeSet<String> names = new TreeSet<String>();
            for (String retrievalSplit : namesSplit) {
                names.add(retrievalSplit.trim());
            }
            graphLocation = graphLocation.withUserPrincipalNames(new ArrayList(names));
            currentOperation.addExecutionLog(iu.getFormattedString("AddEvidenceOperation.Log.MsGraphUserPrincipalNames", (Object)String.join((CharSequence)", ", names)));
        }
        if ((ms_graph_version_retrieval = executionContext.evalBooleanParameter("{ms_graph_version_retrieval}", currentOperation)) != null && (ms_graph_version_limit = executionContext.evalIntParameter("{ms_graph_version_limit}", currentOperation)) != null) {
            HashMap<String, Comparable<Boolean>> versionFilters = new HashMap<String, Comparable<Boolean>>();
            versionFilters.put("versionRetrievalEnabled", ms_graph_version_retrieval);
            versionFilters.put("versionRetrievalLimit", ms_graph_version_limit);
            graphLocation = graphLocation.withVersionFilters(versionFilters);
            currentOperation.addExecutionLog(iu.getFormattedString("AddEvidenceOperation.Log.MsGraphVersionRetrievalLimit", (Object)ms_graph_version_limit));
        }
        evidenceContainer.addLocation((Location)graphLocation);
    }
}

