/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.nuix;

import com.nuix.automate.utils.exceptions.InvalidCustomDigestSizeException;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.nuix.ProfileTypeNuix;
import com.nuix.automate.utils.nuix.Version;
import com.nuix.automate.workflow.core.nuix.ExecutionContext;
import com.nuix.automate.workflow.core.utils.general.ConfigurationParser;
import com.nuix.automate.workflow.core.utils.nuix.CaseFolders;
import com.nuix.filetype.MimeType;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import nuix.Case;
import nuix.CaseFactory;
import nuix.CompoundCase;
import nuix.DigestCollection;
import nuix.Item;
import nuix.MetadataItem;
import nuix.MetadataProfile;
import nuix.ProcessingJob;
import nuix.ProductionSet;
import nuix.ProductionSetItem;
import nuix.SimpleCase;
import nuix.UserDataStore;
import nuix.Utilities;
import nuix.profile.ImagingProfile;
import nuix.profile.ImagingProfileStore;
import nuix.profile.OcrProfile;
import nuix.profile.OcrProfileBuilder;
import nuix.profile.OcrProfileStore;
import nuix.profile.ProcessingProfile;
import nuix.profile.ProcessingProfileStore;
import nuix.profile.ProductionProfile;
import nuix.profile.ProductionProfileStore;
import nuix.profile.Profile;
import nuix.profile.ProfileBuilder;
import nuix.profile.Stamper;
import nuix.profile.StamperConfiguration;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class NuixUtils {
    private static final transient LoggerWrapper LOGGER = LogManagerUtils.getLogger(NuixUtils.class);
    private static final transient InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"WorkflowText");
    private static Collection<MimeType> mimeTypes;
    private static Boolean processingSettingsSetAsProfile;
    private static Map<ProfileTypeNuix, Set<? extends Profile>> caseProfiles;

    public static ProductionSetItem getProductionSetItem(Item item, ProductionSet productionSet) {
        for (ProductionSetItem productionSetItem : item.getProductionSetItems()) {
            if (!productionSetItem.getProductionSetGuid().equals(productionSet.getGuid())) continue;
            return productionSetItem;
        }
        return null;
    }

    public static boolean disablePreviousProcessingQueue(String caseLocation) throws IOException {
        try {
            Path processingQueuePath = Paths.get(caseLocation, "Stores", "PersistentQueue", "processing");
            File processingQueueFile = processingQueuePath.toFile();
            if (processingQueueFile.exists()) {
                File renameToFile = new File(processingQueueFile.getAbsolutePath() + ".disabled-" + FormattingUtils.dateTimeToInternationalDateTimeString((DateTime)DateTime.now((DateTimeZone)DateTimeZone.UTC)));
                LOGGER.warn("Remaining previous processing queue " + processingQueueFile.getAbsolutePath() + " to " + renameToFile.getAbsolutePath());
                Files.move(processingQueuePath, renameToFile.toPath(), new CopyOption[0]);
                return true;
            }
        }
        catch (Exception e) {
            LOGGER.error("Cannot handle previous processing queue", (Throwable)e);
        }
        return false;
    }

    public static boolean disablePreviousPersistentQueue(String caseLocation) {
        try {
            File[] persistentQueueFiles;
            Path persistentQueuePath = Paths.get(caseLocation, "Stores", "PersistentQueue");
            File persistentQueueFile = persistentQueuePath.toFile();
            if (persistentQueueFile.exists() && (persistentQueueFiles = persistentQueueFile.listFiles()).length == 1 && persistentQueueFiles[0].getName().startsWith("evidence-queue-")) {
                File renameToFile = new File(persistentQueueFile.getAbsolutePath() + ".disabled-" + FormattingUtils.dateTimeToInternationalDateTimeString((DateTime)DateTime.now((DateTimeZone)DateTimeZone.UTC)));
                LOGGER.warn("Remaining previous persistent queue folder " + persistentQueueFile.getAbsolutePath() + " to " + renameToFile.getAbsolutePath());
                Files.move(persistentQueuePath, renameToFile.toPath(), new CopyOption[0]);
                return true;
            }
        }
        catch (Exception e) {
            LOGGER.error("Cannot handle previous persistent queue folder", (Throwable)e);
        }
        return false;
    }

    public static boolean disableUnfinalizedRemoteStores(String caseLocation) throws IOException {
        boolean detectedRemoteStores = false;
        try {
            Path storesPath = Paths.get(caseLocation, "Stores");
            File[] storesFolders = new File(storesPath.toAbsolutePath().toString()).listFiles(File::isDirectory);
            if (storesFolders != null) {
                for (File storeFolder : storesFolders) {
                    if (!storeFolder.getName().toLowerCase().startsWith("remote-")) continue;
                    String renameName = "Disabled-" + FormattingUtils.dateTimeToInternationalDateTimeString((DateTime)DateTime.now((DateTimeZone)DateTimeZone.UTC)) + "-" + storeFolder.getName();
                    File renameFile = storesPath.resolve(renameName).toFile();
                    LOGGER.warn("Remaining previous remote store " + storeFolder.getAbsolutePath() + " to " + renameFile.getAbsolutePath());
                    Files.move(storeFolder.toPath(), renameFile.toPath(), new CopyOption[0]);
                    detectedRemoteStores = true;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Cannot handle previous processing queue", (Throwable)e);
        }
        return detectedRemoteStores;
    }

    public static boolean disableLocalStoresProcessingQueue(String caseLocation) throws IOException {
        boolean detectedUnfinalizedLocalStores = false;
        try {
            Path storesPath = Paths.get(caseLocation, "Stores");
            File[] storesFolders = new File(storesPath.toAbsolutePath().toString()).listFiles(File::isDirectory);
            if (storesFolders != null) {
                for (File storeFolder : storesFolders) {
                    Path processingQueuePath;
                    File processingQueueFile;
                    if (!storeFolder.getName().toLowerCase().startsWith("store-") || !(processingQueueFile = (processingQueuePath = storeFolder.toPath().resolve("processing")).toFile()).exists()) continue;
                    File renameToFile = new File(processingQueueFile.getAbsolutePath() + ".disabled-" + FormattingUtils.dateTimeToInternationalDateTimeString((DateTime)DateTime.now((DateTimeZone)DateTimeZone.UTC)));
                    LOGGER.warn("Remaining previous processing queue " + processingQueueFile.getAbsolutePath() + " to " + renameToFile.getAbsolutePath());
                    Files.move(processingQueuePath, renameToFile.toPath(), new CopyOption[0]);
                    detectedUnfinalizedLocalStores = true;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Cannot handle previous processing queue", (Throwable)e);
        }
        return detectedUnfinalizedLocalStores;
    }

    public static SimpleCase getSimpleCase(Case nuixCase) throws IOException {
        LOGGER.info("Attempting to get simple case from " + nuixCase.getClass().toString() + " " + nuixCase.getName());
        if (nuixCase instanceof SimpleCase) {
            return (SimpleCase)nuixCase;
        }
        if (nuixCase instanceof CompoundCase) {
            List cases = ((CompoundCase)nuixCase).getChildCases();
            if (cases.size() == 0) {
                LOGGER.error("Compound case " + nuixCase.getName() + " does not contain any child cases");
                throw new IOException("Compound case " + nuixCase.getName() + " does not contain any child cases");
            }
            return NuixUtils.getSimpleCase((Case)cases.get(0));
        }
        LOGGER.error("Case " + String.valueOf(nuixCase) + " is neither a Simple case nor a Complex case");
        throw new IOException("Case " + String.valueOf(nuixCase) + " is neither a Simple case nor a Complex case");
    }

    private static void buildCaseProfiles(Case nuixCase) {
        Path processingProfilesFolder;
        Path imagingProfilesFolder;
        caseProfiles = new HashMap<ProfileTypeNuix, Set<? extends Profile>>();
        if (nuixCase == null) {
            LOGGER.warn("Nuix case is not initialized");
            return;
        }
        Path userDataFolder = Paths.get(nuixCase.getLocation().toString(), "Stores", "User Data");
        if (!Files.isDirectory(userDataFolder, new LinkOption[0])) {
            LOGGER.warn("Nuix case user data folder does not exist");
            return;
        }
        Path ocrProfilesFolder = userDataFolder.resolve("OCR Profiles");
        if (Files.exists(ocrProfilesFolder, new LinkOption[0])) {
            HashSet ocrProfiles = new HashSet(NuixUtils.loadProfilesFromFolderPath(ocrProfilesFolder, nuixCase.getOcrProfileBuilder()));
            caseProfiles.put(ProfileTypeNuix.OCR, ocrProfiles);
        }
        if (Files.exists(imagingProfilesFolder = userDataFolder.resolve("Imaging Profiles"), new LinkOption[0])) {
            HashSet imagingProfiles = new HashSet(NuixUtils.loadProfilesFromFolderPath(imagingProfilesFolder, nuixCase.getImagingProfileBuilder()));
            caseProfiles.put(ProfileTypeNuix.IMAGING, imagingProfiles);
        }
        if (Files.exists(processingProfilesFolder = userDataFolder.resolve("Processing Profiles"), new LinkOption[0])) {
            HashSet processingProfiles = new HashSet(NuixUtils.loadProfilesFromFolderPath(processingProfilesFolder, nuixCase.getProcessingProfileBuilder()));
            caseProfiles.put(ProfileTypeNuix.PROCESSING, processingProfiles);
        }
    }

    private static Profile getProfile(ProfileTypeNuix profileType, String profileName) {
        if (caseProfiles != null && caseProfiles.get(profileType) != null) {
            for (Profile profile : caseProfiles.get(profileType)) {
                if (!profile.getName().equals(profileName)) continue;
                return profile;
            }
        }
        return null;
    }

    private static <T extends Profile> List<T> loadProfilesFromFolderPath(final Path folderPath, final ProfileBuilder<?, T> profileBuilder) {
        final ArrayList profiles = new ArrayList();
        try {
            Files.walkFileTree(folderPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    try {
                        Profile profile = profileBuilder.load(file.toAbsolutePath().toString());
                        profiles.add(profile);
                    }
                    catch (Exception e) {
                        LOGGER.error("Failed to load Nuix profile " + String.valueOf(file.getFileName()) + " from case folder " + String.valueOf(folderPath), (Throwable)e);
                    }
                    return super.visitFile(file, attrs);
                }
            });
        }
        catch (IOException e) {
            LOGGER.error("Error reading Nuix case OCR Profiles", (Throwable)e);
        }
        return profiles;
    }

    public static Map<String, Object> buildStamperOptionsFromStamperConfiguration(StamperConfiguration stamperConfiguration, Case nuixCase) {
        if (stamperConfiguration == null) {
            return null;
        }
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("increasePageSize", stamperConfiguration.isIncreasePageSize());
        config.put("headerLine", stamperConfiguration.isShowHeaderLine());
        config.put("footerLine", stamperConfiguration.isShowFooterLine());
        List metadataItems = nuixCase.getMetadataItems();
        NuixUtils.buildMapFromStamper(stamperConfiguration.getHeaderLeftStamper(), config, metadataItems, "headerLeft");
        NuixUtils.buildMapFromStamper(stamperConfiguration.getHeaderCentreStamper(), config, metadataItems, "headerCentre");
        NuixUtils.buildMapFromStamper(stamperConfiguration.getHeaderRightStamper(), config, metadataItems, "headerRight");
        NuixUtils.buildMapFromStamper(stamperConfiguration.getFooterLeftStamper(), config, metadataItems, "footerLeft");
        NuixUtils.buildMapFromStamper(stamperConfiguration.getFooterCentreStamper(), config, metadataItems, "footerCentre");
        NuixUtils.buildMapFromStamper(stamperConfiguration.getFooterRightStamper(), config, metadataItems, "footerRight");
        return config;
    }

    public static void buildMapFromStamper(Stamper stamper, Map<String, Object> config, List<MetadataItem> metadataItems, String key) {
        String type = stamper.getType();
        if (type == null || type.equals("")) {
            return;
        }
        HashMap<String, Object> stamperMap = new HashMap<String, Object>();
        stamperMap.put("type", type);
        if (type.equals("custom")) {
            stamperMap.put("customText", stamper.getCustomText());
        } else if (type.equals("metadata")) {
            MetadataItem customMetadataItem = null;
            for (MetadataItem metadataItem : metadataItems) {
                if (!metadataItem.getName().equals(stamper.getMetadataIdentifier())) continue;
                customMetadataItem = metadataItem;
                break;
            }
            if (customMetadataItem == null) {
                return;
            }
            stamperMap.put("metadataItem", customMetadataItem);
        }
        if (!stamper.isDefaultFont()) {
            HashMap<String, Object> fontOptions = new HashMap<String, Object>();
            fontOptions.put("family", stamper.getCustomFontFamilyName());
            fontOptions.put("size", stamper.getCustomFontSize());
            if (stamper.isCustomFontBold() || stamper.isCustomFontItalic()) {
                ArrayList<String> style = new ArrayList<String>();
                if (stamper.isCustomFontBold()) {
                    style.add("bold");
                }
                if (stamper.isCustomFontItalic()) {
                    style.add("italic");
                }
                fontOptions.put("style", style);
            } else {
                fontOptions.put("style", null);
            }
            stamperMap.put("font", fontOptions);
        }
        config.put(key, stamperMap);
    }

    public static ProductionProfile getProductionProfile(Case nuixCase, Utilities nuixUtilities, String productionProfileName) {
        ProductionProfile productionProfile = null;
        try {
            productionProfile = NuixUtils.getProductionProfile((UserDataStore)nuixCase, productionProfileName);
        }
        catch (Throwable t) {
            LOGGER.warn("Cannot resolve case profiles", t);
        }
        if (productionProfile == null) {
            if (nuixUtilities != null) {
                productionProfile = NuixUtils.getProductionProfile((UserDataStore)nuixUtilities, productionProfileName);
            } else {
                LOGGER.warn("# Nuix utilities not available");
            }
        }
        if (productionProfile != null) {
            LOGGER.info("Found production profile " + productionProfile.getName());
        } else {
            LOGGER.warn("Cannot find production profile " + productionProfileName);
        }
        return productionProfile;
    }

    public static MetadataProfile getMetadataProfile(Case nuixCase, Utilities nuixUtilities, String metadataProfileName) {
        MetadataProfile metadataProfile = null;
        try {
            metadataProfile = NuixUtils.getMetadataProfile((UserDataStore)nuixCase, metadataProfileName);
        }
        catch (Throwable t) {
            LOGGER.warn("Cannot resolve case profiles", t);
        }
        if (metadataProfile == null) {
            if (nuixUtilities != null) {
                metadataProfile = NuixUtils.getMetadataProfile((UserDataStore)nuixUtilities, metadataProfileName);
            } else {
                LOGGER.warn("# Nuix utilities not available");
            }
        }
        if (metadataProfile != null) {
            LOGGER.info("Found metadata profile " + metadataProfile.getName());
        } else {
            LOGGER.warn("Cannot find metadata profile " + metadataProfileName);
        }
        return metadataProfile;
    }

    public static ProductionProfile getProductionProfile(UserDataStore userDataStore, String profileName) {
        ProductionProfileStore productionProfileStore;
        if (userDataStore != null && (productionProfileStore = userDataStore.getProductionProfileStore()).getProfileNames().contains(profileName)) {
            return (ProductionProfile)productionProfileStore.getProfile(profileName);
        }
        return null;
    }

    public static MetadataProfile getMetadataProfile(UserDataStore userDataStore, String profileName) {
        if (userDataStore != null) {
            List metadataProfiles = userDataStore.getMetadataProfileStore().getMetadataProfiles();
            for (MetadataProfile metadataProfile : metadataProfiles) {
                if (!metadataProfile.getName().equals(profileName)) continue;
                return metadataProfile;
            }
        }
        return null;
    }

    public static String getDefaultMetadataProfileName() {
        ConfigurationParser configurationParser = new ConfigurationParser();
        String defaultMetadataProfileName = configurationParser.getDefaultMetadataProfileName();
        if (defaultMetadataProfileName == null) {
            return "Default";
        }
        return defaultMetadataProfileName;
    }

    public static ImagingProfile getImagingProfile(Case nuixCase, Utilities nuixUtilities, String imagingProfileName) {
        ImagingProfileStore imagingProfileStore;
        boolean profileFound;
        try {
            NuixUtils.buildCaseProfiles(nuixCase);
            Profile profile = NuixUtils.getProfile(ProfileTypeNuix.IMAGING, imagingProfileName);
            if (profile != null) {
                Path imagingProfilePath = NuixUtils.getCaseProfilePath(nuixCase, "Imaging Profiles", profile.getName());
                LOGGER.info("Found Nuix case imaging profile: " + String.valueOf(imagingProfilePath));
                return (ImagingProfile)profile;
            }
        }
        catch (Throwable t) {
            LOGGER.warn("Cannot resolve case profiles", t);
        }
        if (nuixUtilities != null && (profileFound = (imagingProfileStore = nuixUtilities.getImagingProfileStore()).getProfileNames().contains(imagingProfileName))) {
            return (ImagingProfile)imagingProfileStore.getProfile(imagingProfileName);
        }
        LOGGER.warn("Cannot find imaging profile " + imagingProfileName);
        return null;
    }

    public static OcrProfile getOcrProfile(Case nuixCase, Utilities nuixUtilities, String ocrProfileName) {
        OcrProfileStore ocrProfileStore;
        boolean profileFound;
        try {
            NuixUtils.buildCaseProfiles(nuixCase);
            Profile profile = NuixUtils.getProfile(ProfileTypeNuix.OCR, ocrProfileName);
            if (profile != null) {
                Path ocrProfilePath = NuixUtils.getCaseProfilePath(nuixCase, "OCR Profiles", profile.getName());
                LOGGER.info("Found Nuix case ocr profile: " + String.valueOf(ocrProfilePath));
                return (OcrProfile)profile;
            }
        }
        catch (Throwable t) {
            LOGGER.warn("Cannot resolve case profiles", t);
        }
        if (nuixUtilities != null && (profileFound = (ocrProfileStore = nuixUtilities.getOcrProfileStore()).getProfileNames().contains(ocrProfileName))) {
            return (OcrProfile)ocrProfileStore.getProfile(ocrProfileName);
        }
        LOGGER.warn("Cannot find ocr profile " + ocrProfileName);
        return null;
    }

    public static ProcessingProfile getProcessingProfile(Case nuixCase, Utilities nuixUtilities, String processingProfileName) {
        ProcessingProfileStore processingProfileStore;
        boolean profileFound;
        try {
            NuixUtils.buildCaseProfiles(nuixCase);
            Profile profile = NuixUtils.getProfile(ProfileTypeNuix.PROCESSING, processingProfileName);
            if (profile != null) {
                Path processingProfilePath = NuixUtils.getCaseProfilePath(nuixCase, "Processing Profiles", profile.getName());
                LOGGER.info("Found Nuix case processing profile: " + String.valueOf(processingProfilePath));
                return (ProcessingProfile)profile;
            }
        }
        catch (Throwable t) {
            LOGGER.warn("Cannot resolve case profiles", t);
        }
        if (nuixUtilities != null && (profileFound = (processingProfileStore = nuixUtilities.getProcessingProfileStore()).getProfileNames().contains(processingProfileName))) {
            return (ProcessingProfile)processingProfileStore.getProfile(processingProfileName);
        }
        LOGGER.warn("Cannot find processing profile " + processingProfileName);
        return null;
    }

    public static OcrProfile differentiateOcrProfile(OcrProfile ocrProfile, String suffix, Utilities nuixUtilities) {
        OcrProfileBuilder profileBuilder = nuixUtilities.getOcrProfileBuilder();
        profileBuilder = (OcrProfileBuilder)profileBuilder.copy((Profile)ocrProfile);
        profileBuilder = profileBuilder.withOutputDirectory(ocrProfile.getOutputDirectory() + suffix);
        return (OcrProfile)profileBuilder.build();
    }

    private static Path getCaseProfilePath(Case nuixCase, String profileFolderName, String profileName) {
        return Paths.get(nuixCase.getLocation().toString(), "Stores", "User Data", profileFolderName, profileName);
    }

    public static boolean caseContainsEvidenceContainer(Case nuixCase, String evidenceContainer) {
        LOGGER.info("Checking if case " + String.valueOf(nuixCase) + " contains evidence container " + evidenceContainer);
        try {
            List items = nuixCase.getRootItems();
            for (Item item : items) {
                if (!item.getName().equals(evidenceContainer)) continue;
                return true;
            }
        }
        catch (Exception e) {
            LOGGER.error("Error during caseContainsEvidenceContainer() ", (Throwable)e);
        }
        return false;
    }

    public static String addAndQuery(String queryLeft, String queryRight) {
        if (queryLeft == null || queryLeft.trim().length() == 0) {
            return queryRight;
        }
        if (queryRight == null || queryRight.trim().length() == 0) {
            return queryLeft;
        }
        return "(" + queryLeft + ") AND (" + queryRight + ")";
    }

    public static String addOrQueryString(String queryLeft, String queryRight) {
        if (queryLeft == null || queryLeft.trim().length() == 0) {
            return "";
        }
        if (queryRight == null || queryRight.trim().length() == 0) {
            return "";
        }
        return "(" + queryLeft + ") OR (" + queryRight + ")";
    }

    public static synchronized Collection<MimeType> getAllMimeTypes() {
        if (mimeTypes == null) {
            block11: {
                mimeTypes = new HashSet<MimeType>();
                try {
                    Class<?> c = Class.forName("com.nuix.filetype.MimeType");
                    if (c.isEnum()) {
                        for (Object enumConstant : c.getEnumConstants()) {
                            if (!(enumConstant instanceof MimeType)) continue;
                            mimeTypes.add((MimeType)enumConstant);
                        }
                    }
                }
                catch (ClassNotFoundException e) {
                    if (!LOGGER.isDebugEnabled()) break block11;
                    LOGGER.debug("Cannot find class com.nuix.filetype.MimeType");
                }
            }
            LOGGER.info("Discovered " + mimeTypes.size() + " mime types from enums");
            for (char className = 'a'; className <= 'z'; className = (char)(className + '\u0001')) {
                try {
                    Class<?> c = Class.forName("com.nuix.filetype.mimetype." + className);
                    for (Field field : c.getFields()) {
                        try {
                            if (field.get(null) == null) continue;
                            MimeType mimeType = (MimeType)field.get(null);
                            mimeTypes.add(mimeType);
                        }
                        catch (IllegalAccessException e) {
                            if (!LOGGER.isDebugEnabled()) continue;
                            LOGGER.debug("Cannot get field " + field.getName());
                        }
                    }
                    continue;
                }
                catch (ClassNotFoundException e) {
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug("Cannot find class com.nuix.automate.workflowfornuix.ui.operations." + className, (Throwable)e);
                }
            }
            LOGGER.info("Discovered " + mimeTypes.size() + " mime types from enums and subclasses");
        }
        return mimeTypes;
    }

    public static Set<String> getCaseMetadataProfileNamesFromFolder(Case nuixCase) throws IOException {
        HashSet<String> metadataProfileNames = new HashSet<String>();
        if (nuixCase != null) {
            Path metadataProfilesPath = nuixCase.getLocation().toPath().resolve("Stores/User Data/Metadata Profiles");
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(metadataProfilesPath);){
                for (Path metadataProfilePath : stream) {
                    metadataProfileNames.add(metadataProfilePath.getFileName().toString().split("\\.")[0]);
                }
            }
        }
        return metadataProfileNames;
    }

    public static boolean getProcessingSettingsSetAsProfile(ExecutionContext executionContext) {
        if (processingSettingsSetAsProfile != null) {
            return processingSettingsSetAsProfile;
        }
        if (executionContext.nuixVersion.compareTo(new Version("9.0.0")) >= 0) {
            processingSettingsSetAsProfile = true;
            return processingSettingsSetAsProfile;
        }
        try {
            for (String profileName : executionContext.nuixCase.getProcessingProfileStore().getProfileNames()) {
                ProcessingProfile profile = (ProcessingProfile)executionContext.nuixCase.getProcessingProfileStore().getProfile(profileName);
                Set disabledMimeTypes = profile.getDisabledMimeTypes();
                if (disabledMimeTypes == null) continue;
                processingSettingsSetAsProfile = disabledMimeTypes instanceof Set;
                return processingSettingsSetAsProfile;
            }
        }
        catch (Throwable e) {
            LOGGER.warn("Cannot determine disabled mime-types required format", e);
        }
        processingSettingsSetAsProfile = false;
        return processingSettingsSetAsProfile;
    }

    public static void waitForProcessingJobToComplete(ProcessingJob processingJob) {
        LOGGER.info("Waiting for Nuix Engine Job " + processingJob.getJobGuid() + " to finish (WaitToComplete1 and WaitToComplete2)");
        if (processingJob.hasFinished()) {
            LOGGER.info("Nuix Engine Job " + processingJob.getJobGuid() + " already finished");
            return;
        }
        Thread waitMethod2 = null;
        Thread[] waitMethod2Array = new Thread[1];
        Thread waitMethod1 = new Thread(() -> {
            try {
                processingJob.waitUntilFinished();
                LOGGER.info("WaitToComplete1 done");
            }
            catch (Exception e) {
                LOGGER.info("WaitToComplete1 interrupted", (Throwable)e);
            }
            if (waitMethod2Array[0] != null && waitMethod2Array[0].isAlive()) {
                LOGGER.info("WaitToComplete1 interrupting WaitToComplete2");
                waitMethod2Array[0].interrupt();
            }
        });
        waitMethod1.setName("Automate - ProcessingJob " + processingJob.getJobGuid() + " WaitToComplete1");
        waitMethod2 = new Thread(() -> {
            while (true) {
                if (processingJob.hasFinished()) {
                    LOGGER.info("WaitToComplete2 done");
                    break;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    LOGGER.info("WaitToComplete2 interrupted", (Throwable)e);
                    break;
                }
            }
            if (waitMethod1.isAlive()) {
                LOGGER.info("WaitToComplete2 interrupting WaitToComplete1");
                waitMethod1.interrupt();
            }
        });
        waitMethod2.setName("Automate - ProcessingJob " + processingJob.getJobGuid() + " WaitToComplete2");
        waitMethod2Array[0] = waitMethod2;
        waitMethod1.start();
        waitMethod2.start();
        try {
            waitMethod1.join();
            waitMethod2.join();
            LOGGER.info("Done waiting for Nuix Engine Job " + processingJob.getJobGuid() + " to finish (WaitToComplete1 and WaitToComplete2)");
        }
        catch (InterruptedException e) {
            LOGGER.info("Waiting for Nuix Engine Job " + processingJob.getJobGuid() + " interrupted", (Throwable)e);
            waitMethod1.interrupt();
            waitMethod2.interrupt();
        }
        if (processingJob != null && !processingJob.hasFinished()) {
            LOGGER.info("Aborting Nuix Engine Job " + processingJob.getJobGuid());
            processingJob.abort();
        }
    }

    public static long getItemDigestSize(Item item, String customDigestSizeMetadataFieldName) throws InvalidCustomDigestSizeException {
        try {
            Long size;
            if (customDigestSizeMetadataFieldName != null) {
                Object customDigestValue = item.getCustomMetadata().get((Object)customDigestSizeMetadataFieldName);
                if (customDigestValue != null) {
                    if (customDigestValue instanceof Long) {
                        return (Long)customDigestValue;
                    }
                    if (customDigestValue instanceof Integer) {
                        return ((Integer)customDigestValue).intValue();
                    }
                    try {
                        long digestSize = Long.parseLong(customDigestValue.toString());
                        return digestSize;
                    }
                    catch (NumberFormatException e) {
                        throw new InvalidCustomDigestSizeException((Exception)e);
                    }
                }
                throw new InvalidCustomDigestSizeException("Item does not have custom metadata " + customDigestSizeMetadataFieldName);
            }
            DigestCollection digest = item.getDigests();
            if (digest != null && (size = Long.valueOf(digest.getInputSize())) != null && size > 0L) {
                return size;
            }
            if (item.isFileData()) {
                return item.getFileSize();
            }
            return item.getAuditedSize();
        }
        catch (InvalidCustomDigestSizeException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.warn("Cannot get digest size of item " + item.getGuid(), (Throwable)e);
            return 0L;
        }
    }

    public static String anonymizedQuery(String query) {
        String result = query;
        String[] splits = result.split(":");
        if (splits.length > 0) {
            return splits[0] + ":...";
        }
        return result;
    }

    public static long getDigestSize(Case nuixCase, String query, String customDigestSizeMetadataFieldName) {
        AtomicLong digestSize = new AtomicLong(0L);
        try {
            HashSet itemsInScope = new HashSet();
            itemsInScope.addAll(nuixCase.searchUnsorted(query));
            LOGGER.info("Getting digest for " + itemsInScope.size() + " items for query " + NuixUtils.anonymizedQuery(query));
            long logInterval = 1000L;
            AtomicLong lastReportTime = new AtomicLong(new DateTime(DateTimeZone.UTC).getMillis());
            long startTime = new DateTime(DateTimeZone.UTC).getMillis();
            AtomicLong itemsProgress = new AtomicLong(0L);
            itemsInScope.parallelStream().forEach(item -> {
                block7: {
                    itemsProgress.incrementAndGet();
                    long currentTime = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
                    if (currentTime - lastReportTime.get() > logInterval) {
                        AtomicLong atomicLong = itemsProgress;
                        synchronized (atomicLong) {
                            if (currentTime - lastReportTime.get() > logInterval) {
                                lastReportTime.set(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis());
                                LOGGER.info("Progress " + itemsProgress.get() + " getting digest for " + itemsInScope.size() + " items");
                            }
                        }
                    }
                    try {
                        digestSize.addAndGet(NuixUtils.getItemDigestSize(item, customDigestSizeMetadataFieldName));
                    }
                    catch (InvalidCustomDigestSizeException e) {
                        if (!LOGGER.isDebugEnabled()) break block7;
                        LOGGER.debug("Cannot compute digest for item " + item.getGuid() + ", " + ExceptionUtils.getExceptionPrintableMessage((Throwable)e));
                    }
                }
            });
            long endTime = new DateTime(DateTimeZone.UTC).getMillis();
            LOGGER.info("Getting digest for " + itemsInScope.size() + " items took " + (endTime - startTime) + " ms");
        }
        catch (IOException e) {
            LOGGER.error("Cannot search for " + query, (Throwable)e);
        }
        return digestSize.get();
    }

    public static void reopenCase(ExecutionContext executionContext) throws IOException {
        File caseLocation = executionContext.nuixCase.getLocation();
        executionContext.closeNuixCase();
        CaseFactory caseFactory = executionContext.nuixUtilities.getCaseFactory();
        executionContext.nuixCase = caseFactory.open(caseLocation);
    }

    public static CaseFolders getCaseFolders(ExecutionContext executionContext) {
        return new CaseFolders(executionContext);
    }

    public static void createMetadataProfile(String nuixCaseLocation, String metadataProfileName, List<String> customMetadataNames) throws IOException {
        Path profilePath;
        String profileHeaderContents = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<metadata-profile xmlns=\"http://nuix.com/fbi/metadata-profile\">\n  <metadata-list>\n    <metadata type=\"SPECIAL\" name=\"Name\" />\n";
        String profileFooterContents = "  </metadata-list>\n</metadata-profile>\n";
        StringBuilder profileContents = new StringBuilder();
        profileContents.append(profileHeaderContents);
        for (String customMetadataName : customMetadataNames) {
            profileContents.append("    <metadata type=\"CUSTOM\" name=\"").append(FormattingUtils.encodeForHtml((String)customMetadataName)).append("\" />\n");
        }
        profileContents.append(profileFooterContents);
        Path profileFolderPath = Paths.get(nuixCaseLocation, "Stores", "User Data", "Metadata Profiles", "GenAI");
        if (!Files.exists(profileFolderPath, new LinkOption[0])) {
            Files.createDirectories(profileFolderPath, new FileAttribute[0]);
        }
        if (!Files.isSameFile((profilePath = profileFolderPath.resolve("GenAI " + metadataProfileName + ".profile")).getParent(), profileFolderPath)) {
            throw new IllegalArgumentException("Invalid metadata profile name: " + metadataProfileName);
        }
        try {
            LOGGER.info("Writing metadata profile " + String.valueOf(profilePath));
            FileUtils.writeToFile((StringBuilder)profileContents, (Path)profilePath);
        }
        catch (IOException e) {
            throw new IOException("Cannot write metadata profile", e);
        }
    }

    public static String getMetadataProfileFieldError(Case nuixCase, Utilities nuixUtilities, String metadataProfileName, String metadataProfileField) {
        MetadataProfile mp = NuixUtils.getMetadataProfile(nuixCase, nuixUtilities, metadataProfileName);
        if (mp == null) {
            return iu.getFormattedString("MetadataExportOperation.Warning.CannotFindMetadataProfile", (Object)metadataProfileName);
        }
        boolean foundField = false;
        for (MetadataItem metadataItem : mp.getMetadata()) {
            if (!metadataItem.getName().equals(metadataProfileField)) continue;
            foundField = true;
            break;
        }
        if (!foundField) {
            return iu.getFormattedString("GenAiPromptOnDocumentsOperation.Error.MetadataProfileMissingField", new Object[]{metadataProfileName, metadataProfileField});
        }
        return null;
    }

    static {
        processingSettingsSetAsProfile = null;
        caseProfiles = null;
    }
}

