/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.nuix;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import nuix.ProductionSet;
import org.joda.time.DateTime;
import org.joda.time.Instant;

public class ProductionSetUtils {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ProductionSetUtils.class);
    private static final boolean LOG_ENABLED = false;

    public static Instant getProductionSetCreation(ProductionSet productionSet) {
        return ProductionSetUtils.logObjectReflectionInfo("", productionSet, productionSet.getClass(), ObjectType.PROXY, productionSet.toString());
    }

    /*
     * WARNING - void declaration
     */
    private static Instant logObjectReflectionInfo(String prefix, Object o, Class c, ObjectType objectType, String expectedToString) {
        Instant result;
        Class superClass;
        String fieldValue;
        Field[] fields;
        if (objectType == ObjectType.PROXY) {
            Method[] methods = c.getDeclaredMethods();
            for (AccessibleObject accessibleObject : methods) {
                if (!((Method)accessibleObject).getName().equals("getInvocationHandler")) continue;
                try {
                    Object invocationHandlerO = ((Method)accessibleObject).invoke(o, o);
                    InvocationHandler invocationHandler = (InvocationHandler)invocationHandlerO;
                    Instant result2 = ProductionSetUtils.logObjectReflectionInfo(prefix + "\t", invocationHandlerO, invocationHandlerO.getClass(), ObjectType.INVOCATION_HANDLER, expectedToString);
                    if (result2 != null) {
                        return result2;
                    }
                }
                catch (Exception invocationHandlerO) {
                    // empty catch block
                }
            }
        }
        if (objectType == ObjectType.INVOCATION_HANDLER || objectType == ObjectType.IMPLEMENTATION_CONTAINER) {
            fields = c.getDeclaredFields();
            for (AccessibleObject accessibleObject : fields) {
                ((Field)accessibleObject).setAccessible(true);
                fieldValue = "n/a";
                try {
                    if (((Field)accessibleObject).get(o) == null) continue;
                    fieldValue = ((Field)accessibleObject).get(o).toString();
                }
                catch (IllegalAccessException invocationHandler) {
                    // empty catch block
                }
                if (!fieldValue.equals(expectedToString)) continue;
                try {
                    Object implementation = ((Field)accessibleObject).get(o);
                    ObjectType nextObjectType = objectType == ObjectType.IMPLEMENTATION_CONTAINER ? ObjectType.IMPLEMENTATION : ObjectType.IMPLEMENTATION_CONTAINER;
                    Instant result3 = ProductionSetUtils.logObjectReflectionInfo(prefix + "\t", implementation, implementation.getClass(), nextObjectType, expectedToString);
                    if (result3 == null) continue;
                    return result3;
                }
                catch (Exception implementation) {
                    // empty catch block
                }
            }
        }
        if (objectType == ObjectType.IMPLEMENTATION) {
            void var9_16;
            Method[] methods;
            fields = c.getDeclaredFields();
            for (AccessibleObject accessibleObject : fields) {
                ((Field)accessibleObject).setAccessible(true);
                fieldValue = "n/a";
                try {
                    if (((Field)accessibleObject).get(o) == null) continue;
                    fieldValue = ((Field)accessibleObject).get(o).toString();
                }
                catch (IllegalAccessException implementation) {
                    // empty catch block
                }
                if (!((Field)accessibleObject).getName().equals("created")) continue;
                try {
                    Object createdObject = ((Field)accessibleObject).get(o);
                    if (createdObject instanceof Instant) {
                        return (Instant)createdObject;
                    }
                    if (createdObject instanceof DateTime) {
                        return ((DateTime)createdObject).toInstant();
                    }
                    return DateTime.parse((String)createdObject.toString()).toInstant();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Method[] methodArray = methods = c.getDeclaredMethods();
            int n = methodArray.length;
            boolean bl = false;
            while (var9_16 < n) {
                Method method = methodArray[var9_16];
                ++var9_16;
            }
        }
        if ((superClass = c.getSuperclass()) != null && superClass != c && (result = ProductionSetUtils.logObjectReflectionInfo(prefix, o, superClass, objectType, expectedToString)) != null) {
            return result;
        }
        return null;
    }

    static enum ObjectType {
        PROXY,
        INVOCATION_HANDLER,
        IMPLEMENTATION_CONTAINER,
        IMPLEMENTATION;

    }
}

