/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.ocr;

import com.nuix.automate.workflow.core.utils.ocr.Consumption;
import java.util.ArrayList;
import java.util.List;

public class GenAiConsumption
extends Consumption {
    private Integer promptTokens;
    private Integer completionTokens;

    public GenAiConsumption(Integer promptTokens, Integer completionTokens) {
        this.promptTokens = promptTokens;
        this.completionTokens = completionTokens;
    }

    @Override
    public List<String> toStringList() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.promptTokens != null) {
            result.add(String.valueOf(this.promptTokens));
        } else {
            result.add("");
        }
        if (this.completionTokens != null) {
            result.add(String.valueOf(this.completionTokens));
        } else {
            result.add("");
        }
        return result;
    }

    @Override
    public void add(Consumption c) {
        if (c == null) {
            return;
        }
        if (c instanceof GenAiConsumption) {
            GenAiConsumption g = (GenAiConsumption)c;
            if (this.promptTokens == null) {
                this.promptTokens = g.getPromptTokens();
            } else if (g.getPromptTokens() != null) {
                this.promptTokens = this.promptTokens + g.getPromptTokens();
            }
            if (this.completionTokens == null) {
                this.completionTokens = g.getCompletionTokens();
            } else if (g.getCompletionTokens() != null) {
                this.completionTokens = this.completionTokens + g.getCompletionTokens();
            }
        } else {
            throw new IllegalArgumentException("Cannot add " + this.getClass().getSimpleName() + " with " + c.getClass().getSimpleName());
        }
    }

    public void setPromptTokens(Integer promptTokens) {
        this.promptTokens = promptTokens;
    }

    public void setCompletionTokens(Integer completionTokens) {
        this.completionTokens = completionTokens;
    }

    public Integer getPromptTokens() {
        return this.promptTokens;
    }

    public Integer getCompletionTokens() {
        return this.completionTokens;
    }
}

