/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.ocr;

import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.HashingUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.options.nativeocr.LogLevel;
import com.nuix.automate.workflow.core.execution.options.nativeocr.Rotation;
import com.nuix.automate.workflow.core.nuix.ExecutionContext;
import com.nuix.automate.workflow.core.utils.ocr.Consumption;
import com.nuix.automate.workflow.core.utils.ocr.ImageDeskew;
import com.nuix.automate.workflow.core.utils.ocr.ImageUtil;
import com.nuix.automate.workflow.core.utils.ocr.OcrResult;
import com.nuix.automate.workflow.core.utils.ocr.OcrStatus;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.apache.pdfbox.tools.imageio.ImageIOUtil;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public abstract class OcrUtils
implements AutoCloseable {
    protected static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(OcrUtils.class);
    protected transient InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"WorkflowText");
    protected static final int OCR_DEFAULT_TIMEOUT_S = 600;
    protected static final long CLEANUP_TIMEOUT_MS = 1000L;
    protected static final int DEFAULT_RASTERIZE_DPI = 300;
    private static final String PAGE_BREAK = "\f";
    protected boolean logLevelEnabled;
    protected LogLevel logLevel;
    private boolean rasterizePdfDpiEnabled;
    private Integer rasterizePdfDpi;
    protected boolean timeoutPerFileEnabled;
    protected Integer timeoutPerFile;
    private Path tempPath;
    protected boolean keepIncompleteFiles;
    protected boolean dontCleanUpOnClose;
    private boolean deskew;
    private Rotation rotation;
    protected transient int timeoutS;
    protected final Pattern rotationPattern = Pattern.compile("Rotate: (\\d+)");
    protected Consumption nullConsumption;

    public OcrUtils(ExecutionContext executionContext, Operation operation, Path defaultTempFolder, Consumption nullConsumption) throws IOException {
        this.nullConsumption = nullConsumption;
        try {
            this.rasterizePdfDpi = executionContext.evalIntParameter("{wfn_native_ocr_rasterize_pdf_dpi}", operation);
            if (this.rasterizePdfDpi != null) {
                this.rasterizePdfDpiEnabled = true;
            }
        }
        catch (ParameterException e) {
            LOGGER.warn("Cannot read rasterizePdfDpi from parameter", (Throwable)e);
        }
        try {
            this.timeoutPerFile = executionContext.evalIntParameter("{wfn_native_ocr_timeout_per_file}", operation);
            if (this.timeoutPerFile != null) {
                this.timeoutPerFileEnabled = true;
            }
        }
        catch (ParameterException e) {
            LOGGER.warn("Cannot read timeoutPerFile from parameter", (Throwable)e);
        }
        try {
            String ocrTempFolder = executionContext.evalStringParameter("{wfn_native_ocr_temp_folder}", operation);
            if (ocrTempFolder != null) {
                this.tempPath = Paths.get(ocrTempFolder + "/" + FormattingUtils.dateTimeToInternationalDateTimeMillisString((DateTime)DateTime.now((DateTimeZone)DateTimeZone.UTC)), new String[0]);
            }
        }
        catch (ParameterException e) {
            LOGGER.warn("Cannot read ocrTempFolder from parameter", (Throwable)e);
        }
        if (this.tempPath == null) {
            this.tempPath = defaultTempFolder;
        }
        try {
            Boolean dontCleanUpOnCloseBool = executionContext.evalBooleanParameter("{wfn_native_ocr_dont_clear_temp}", operation);
            if (dontCleanUpOnCloseBool != null) {
                this.dontCleanUpOnClose = dontCleanUpOnCloseBool;
            }
        }
        catch (ParameterException e) {
            LOGGER.warn("Cannot read dontCleanUpOnClose from parameter", (Throwable)e);
        }
        try {
            Boolean deskewBool = executionContext.evalBooleanParameter("{wfn_native_ocr_deskew}", operation);
            if (deskewBool != null) {
                this.deskew = deskewBool;
            }
        }
        catch (ParameterException e) {
            LOGGER.warn("Cannot read deskew from parameter", (Throwable)e);
        }
        try {
            String rotationString = executionContext.evalStringParameter("{wfn_native_ocr_rotate}", operation);
            this.rotation = rotationString != null && rotationString.length() > 0 ? Rotation.valueOf(rotationString) : null;
        }
        catch (ParameterException e) {
            LOGGER.warn("Cannot read rotation from parameter", (Throwable)e);
        }
        this.timeoutS = this.timeoutPerFileEnabled && this.timeoutPerFile != null ? this.timeoutPerFile : 600;
        this.logLevel = LogLevel.ERROR;
        try {
            String logLevelString = executionContext.evalStringParameter("{wfn_native_ocr_log_level}", operation);
            if (logLevelString != null) {
                this.logLevel = LogLevel.valueOf(logLevelString);
                this.logLevelEnabled = true;
            }
        }
        catch (ParameterException e) {
            LOGGER.warn("Cannot read logLevel from parameter", (Throwable)e);
        }
    }

    public boolean getKeepIncompleteFiles() {
        return this.keepIncompleteFiles;
    }

    public void setKeepIncompleteFiles(boolean keepIncompleteFiles) {
        this.keepIncompleteFiles = keepIncompleteFiles;
    }

    public boolean getDontCleanUpOnClose() {
        return this.dontCleanUpOnClose;
    }

    public void setDontCleanUpOnClose(boolean dontCleanUpOnClose) {
        this.dontCleanUpOnClose = dontCleanUpOnClose;
    }

    public abstract void test() throws IOException;

    public OcrResult ocrFile(Path sourceImage, Path destinationText, boolean createSearchablePdf, Path destinationPdf, Semaphore semaphore) {
        return this.ocrFile(sourceImage, destinationText, createSearchablePdf, destinationPdf, semaphore, new AtomicLong(0L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OcrResult ocrFile(Path sourceImage, Path destinationText, boolean createSearchablePdf, Path destinationPdf, Semaphore semaphore, AtomicLong pagesProcessed) {
        Path tempFolder = null;
        try {
            tempFolder = this.getTempFolder(sourceImage.getParent().toString(), destinationText.getFileName().toString());
        }
        catch (IOException e) {
            LOGGER.error("Cannot prepare temp folder", (Throwable)e);
        }
        try {
            OcrResult ocrResult = this.ocrFile(sourceImage, destinationText, createSearchablePdf, destinationPdf, semaphore, pagesProcessed, tempFolder);
            return ocrResult;
        }
        finally {
            if (tempFolder != null && !this.dontCleanUpOnClose) {
                try {
                    org.apache.commons.io.FileUtils.deleteDirectory((File)tempFolder.toFile());
                }
                catch (IOException e) {
                    LOGGER.error("Cannot delete temp folder", (Throwable)e);
                }
            }
        }
    }

    public OcrResult ocrFile(Path sourceImage, Path destinationText, boolean createSearchablePdf, Path destinationPdf, Semaphore semaphore, AtomicLong pagesProcessed, Path tempFolder) {
        long startEpoch = DateTime.now().getMillis();
        String fileNameWithoutExtension = FileUtils.getFileNameWithoutExtension((String)sourceImage.getFileName().toString());
        String fileExtension = FileUtils.getFileExtension((String)sourceImage.getFileName().toString()).toLowerCase();
        if (fileExtension.equals("pdf")) {
            return this.ocrPdfFile(startEpoch, sourceImage, destinationText, createSearchablePdf, destinationPdf, semaphore, pagesProcessed, tempFolder);
        }
        return this.ocrImageFile(startEpoch, sourceImage, destinationText, createSearchablePdf, destinationPdf, pagesProcessed, tempFolder);
    }

    public boolean isLogLevelError() {
        return !this.logLevelEnabled || this.logLevel.equals((Object)LogLevel.OFF) || this.logLevel.equals((Object)LogLevel.FATAL) || this.logLevel.equals((Object)LogLevel.ERROR);
    }

    public boolean isLogLevelOff() {
        return this.logLevelEnabled && this.logLevel.equals((Object)LogLevel.OFF);
    }

    public OcrResult ocrPdfFile(Path sourceImage, Path destinationText, boolean createSearchablePdf, Path destinationPdf, Semaphore semaphore) {
        return this.ocrPdfFile(DateTime.now().getMillis(), sourceImage, destinationText, createSearchablePdf, destinationPdf, semaphore, new AtomicLong(0L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OcrResult ocrPdfFile(long startEpoch, Path sourceImage, Path destinationText, boolean createSearchablePdf, Path destinationPdf, Semaphore semaphore, AtomicLong pagesProcessed) {
        Path tempFolder = null;
        try {
            tempFolder = this.getTempFolder(sourceImage.getParent().toString(), destinationText.getFileName().toString());
        }
        catch (IOException e) {
            LOGGER.error("Cannot prepare temp folder", (Throwable)e);
        }
        try {
            OcrResult ocrResult = this.ocrPdfFile(startEpoch, sourceImage, destinationText, createSearchablePdf, destinationPdf, semaphore, pagesProcessed, tempFolder);
            return ocrResult;
        }
        finally {
            if (tempFolder != null && !this.dontCleanUpOnClose) {
                try {
                    org.apache.commons.io.FileUtils.deleteDirectory((File)tempFolder.toFile());
                }
                catch (IOException e) {
                    LOGGER.error("Cannot delete temp folder", (Throwable)e);
                }
            }
        }
    }

    private boolean isDocumentXfa(PDDocument document) {
        return document.getDocumentCatalog() != null && document.getDocumentCatalog().getAcroForm() != null && document.getDocumentCatalog().getAcroForm().getXFA() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OcrResult ocrPdfFile(long startEpoch, Path sourceImage, Path destinationText, boolean createSearchablePdf, Path destinationPdf, Semaphore semaphore, AtomicLong pagesProcessed, Path tempFolder) {
        int rasterizeDpi = 300;
        if (this.rasterizePdfDpiEnabled) {
            rasterizeDpi = this.rasterizePdfDpi;
        }
        OcrStatus status = OcrStatus.SUCCESS;
        ArrayList<Object> messages = new ArrayList<Object>();
        AtomicBoolean failure = new AtomicBoolean(false);
        Integer documentPages = null;
        Consumption[] consumption = new Consumption[]{null};
        try {
            boolean threadInterrupted;
            PDDocument document = Loader.loadPDF((File)sourceImage.toFile());
            if (this.isDocumentXfa(document)) {
                LOGGER.warn("File " + String.valueOf(sourceImage) + " is PDF XFA");
                return new OcrResult("Unsupported PDF XFA format", this.nullConsumption, OcrStatus.FAILED, 1);
            }
            documentPages = document.getNumberOfPages();
            Semaphore internalSemaphone = new Semaphore(1);
            ConcurrentHashMap<Long, Thread> activeThreads = new ConcurrentHashMap<Long, Thread>();
            AtomicLong threadsCount = new AtomicLong();
            int pdfPagesCount = document.getNumberOfPages();
            block19: for (int pageId = 0; pageId < pdfPagesCount && !Thread.interrupted(); ++pageId) {
                boolean result;
                if ((long)(this.timeoutS * 1000) < DateTime.now().getMillis() - startEpoch) {
                    throw new TimeoutException("Timeout of " + this.timeoutS + " s exceeded");
                }
                PDPage documentPage = document.getPage(pageId);
                int finalPageId = pageId;
                float height = documentPage.getMediaBox().getHeight();
                float width = documentPage.getMediaBox().getWidth();
                float maxDimension = Math.max(height, width);
                double overScaledRatio = 1.0;
                if ((double)maxDimension > 1008.0) {
                    overScaledRatio = (double)maxDimension / 1008.0;
                }
                float normalizedDpi = (float)((double)rasterizeDpi / overScaledRatio);
                Path tempDestinationText = tempFolder.resolve(String.valueOf(destinationText.getFileName()) + "_page" + (pageId + 1));
                Long threadId = threadsCount.getAndIncrement();
                Path finalTempFolder = tempFolder;
                AtomicBoolean finalFailure = failure;
                Thread threadGlobal = new Thread(() -> {
                    OcrResult threadOcrResult = this.handlePage(sourceImage, finalPageId, normalizedDpi, startEpoch, tempDestinationText, createSearchablePdf, finalTempFolder, pagesProcessed, messages, finalFailure, semaphore, threadId, activeThreads);
                    if (threadOcrResult != null) {
                        OcrUtils ocrUtils = this;
                        synchronized (ocrUtils) {
                            if (consumption[0] == null) {
                                consumption[0] = threadOcrResult.getConsumption();
                            } else {
                                consumption[0].add(threadOcrResult.getConsumption());
                            }
                        }
                    }
                });
                Thread threadInternal = new Thread(() -> {
                    OcrResult threadOcrResult = this.handlePage(sourceImage, finalPageId, normalizedDpi, startEpoch, tempDestinationText, createSearchablePdf, finalTempFolder, pagesProcessed, messages, finalFailure, internalSemaphone, threadId, activeThreads);
                    if (threadOcrResult != null) {
                        OcrUtils ocrUtils = this;
                        synchronized (ocrUtils) {
                            if (consumption[0] == null) {
                                consumption[0] = threadOcrResult.getConsumption();
                            } else {
                                consumption[0].add(threadOcrResult.getConsumption());
                            }
                        }
                    }
                });
                activeThreads.put(threadId, threadInternal);
                do {
                    if (internalSemaphone.tryAcquire()) {
                        threadInternal.setName("OCR document handling");
                        threadInternal.start();
                        continue block19;
                    }
                    activeThreads.put(threadId, threadGlobal);
                    result = true;
                    if (semaphore == null) continue;
                    result = semaphore.tryAcquire(20L, TimeUnit.MILLISECONDS);
                } while (!result);
                threadGlobal.setName("OCR document handling");
                threadGlobal.start();
            }
            boolean timeoutEncountered = false;
            while (activeThreads.size() > 0) {
                if ((long)(this.timeoutS * 1000) < DateTime.now().getMillis() - startEpoch) {
                    timeoutEncountered = true;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                    break;
                }
            }
            if ((threadInterrupted = Thread.interrupted()) || timeoutEncountered) {
                for (Thread activeThread : activeThreads.values()) {
                    if (!activeThread.isAlive()) continue;
                    activeThread.interrupt();
                }
            }
            if (timeoutEncountered) {
                throw new TimeoutException("Timeout of " + this.timeoutS + " s exceeded");
            }
            document.close();
            boolean firstTextPage = true;
            Path destinationTextWithExtension = Paths.get(String.valueOf(destinationText.toAbsolutePath()) + ".txt", new String[0]);
            Path destinationPdfWithExtension = Paths.get(String.valueOf(destinationPdf.toAbsolutePath()) + ".pdf", new String[0]);
            long textSize = 0L;
            for (int pageId = 0; pageId < pdfPagesCount; ++pageId) {
                if ((long)(this.timeoutS * 1000) < DateTime.now().getMillis() - startEpoch) {
                    throw new TimeoutException("Timeout of " + this.timeoutS + " s exceeded");
                }
                Path tempDestinationTextWithExtension = tempFolder.resolve(String.valueOf(destinationText.getFileName()) + "_page" + (pageId + 1) + ".txt");
                Object pageText = "";
                if (Files.exists(tempDestinationTextWithExtension, new LinkOption[0])) {
                    pageText = FileUtils.readFileWithAutodetectEncoding((File)tempDestinationTextWithExtension.toFile());
                }
                textSize += (long)((String)pageText).length();
                if (!firstTextPage) {
                    pageText = (String)pageText + PAGE_BREAK;
                }
                if (!Files.exists(destinationTextWithExtension.getParent(), new LinkOption[0])) {
                    try {
                        Files.createDirectories(destinationTextWithExtension.getParent(), new FileAttribute[0]);
                    }
                    catch (IOException e) {
                        LOGGER.warn("Cannot create Text output folder", (Throwable)e);
                    }
                }
                Files.write(destinationTextWithExtension, ((String)pageText).getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
                firstTextPage = false;
            }
            if (createSearchablePdf) {
                PDFMergerUtility pdfMergerUtility = new PDFMergerUtility();
                pdfMergerUtility.setDestinationFileName(destinationPdfWithExtension.toString());
                Path pdfFolderParent = destinationPdfWithExtension.getParent();
                if (!Files.exists(pdfFolderParent, new LinkOption[0])) {
                    try {
                        Files.createDirectories(pdfFolderParent, new FileAttribute[0]);
                    }
                    catch (IOException e) {
                        LOGGER.warn("Cannot create PDF output folder", (Throwable)e);
                    }
                }
                for (int pageId = 0; pageId < pdfPagesCount; ++pageId) {
                    if ((long)(this.timeoutS * 1000) < DateTime.now().getMillis() - startEpoch) {
                        throw new TimeoutException("Timeout of " + this.timeoutS + " s exceeded");
                    }
                    Path tempDestinationPdfWithExtension = tempFolder.resolve(String.valueOf(destinationText.getFileName()) + "_page" + (pageId + 1) + ".pdf");
                    if (!Files.exists(tempDestinationPdfWithExtension, new LinkOption[0])) {
                        try (InputStream stream = this.getClass().getResourceAsStream("/templates/pageError.pdf");){
                            Files.copy(stream, tempDestinationPdfWithExtension, StandardCopyOption.REPLACE_EXISTING);
                        }
                        LOGGER.error("Cannot add document " + String.valueOf(sourceImage) + " page " + (pageId + 1) + " to searchable PDF");
                        failure.set(true);
                        ArrayList<Object> arrayList = messages;
                        synchronized (arrayList) {
                            messages.add("Cannot add page " + (pageId + 1) + " to searchable PDF");
                        }
                    }
                    pdfMergerUtility.addSource(tempDestinationPdfWithExtension.toFile());
                }
                pdfMergerUtility.mergeDocuments(null);
            }
            if (textSize == 0L) {
                failure.set(true);
                status = OcrStatus.FAILED;
            }
        }
        catch (Exception e) {
            failure.set(true);
            status = OcrStatus.FAILED;
            ArrayList<Object> internalSemaphone = messages;
            synchronized (internalSemaphone) {
                messages.add(ExceptionUtils.getExceptionPrintableMessage((Throwable)e, (boolean)true));
            }
        }
        String effectiveMessage = String.join((CharSequence)"\n", messages);
        long endEpoch = DateTime.now().getMillis();
        if (failure.get()) {
            status = OcrStatus.FAILED;
        } else if (this.isLogLevelError()) {
            effectiveMessage = "";
        }
        if (this.isLogLevelOff()) {
            effectiveMessage = "";
        }
        return new OcrResult(effectiveMessage.trim(), consumption[0], status, documentPages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OcrResult handlePage(Path sourceImage, int finalPageId, float normalizedDpi, long startEpoch, Path tempDestinationText, boolean createSearchablePdf, Path finalTempFolder, AtomicLong pagesProcessed, List<String> messages, AtomicBoolean finalFailure, Semaphore semaphore, Long threadId, Map<Long, Thread> activeThreads) {
        PDDocument localDocument = null;
        PDFRenderer localPdfRenderer = null;
        try {
            Object object;
            OcrResult result;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("File " + String.valueOf(sourceImage) + " page " + (finalPageId + 1) + " exporting");
            }
            if (Thread.interrupted()) {
                OcrResult ocrResult = null;
                return ocrResult;
            }
            localDocument = Loader.loadPDF((File)sourceImage.toFile());
            localPdfRenderer = new PDFRenderer(localDocument);
            BufferedImage bufferedImage = localPdfRenderer.renderImageWithDPI(finalPageId, normalizedDpi, ImageType.RGB);
            if (Thread.interrupted()) {
                OcrResult e = null;
                return e;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("File " + String.valueOf(sourceImage) + " page " + (finalPageId + 1) + " OCRing");
            }
            if ((result = this.ocrImageFile(startEpoch, null, bufferedImage, tempDestinationText, createSearchablePdf, tempDestinationText, finalTempFolder, pagesProcessed)).getMessage() != null && result.getMessage().length() > 0) {
                object = messages;
                synchronized (object) {
                    messages.add("Page " + (finalPageId + 1) + ": " + result.getMessage());
                }
            }
            object = result;
            return object;
        }
        catch (Throwable e) {
            LOGGER.error("File " + String.valueOf(sourceImage) + " page " + (finalPageId + 1) + " OCR error", e);
            finalFailure.set(true);
            List<String> list = messages;
            synchronized (list) {
                messages.add("Page " + (finalPageId + 1) + ": " + ExceptionUtils.getExceptionPrintableMessage((Throwable)e, (boolean)true));
            }
        }
        finally {
            try {
                if (localDocument != null) {
                    localDocument.close();
                }
            }
            catch (IOException e) {
                LOGGER.error("File " + String.valueOf(sourceImage) + " page " + (finalPageId + 1) + " cannot close PDF document", (Throwable)e);
            }
            if (semaphore != null) {
                semaphore.release();
            }
            activeThreads.remove(threadId);
        }
        return null;
    }

    protected String hashPrefix(String prefix) {
        byte[] prefixHashBytes = HashingUtils.digestSha256((byte[])prefix.getBytes(StandardCharsets.UTF_8));
        String encodedPrefix = Base64.getEncoder().encodeToString(prefixHashBytes).replace("/", "").replace("=", "").replace("+", "");
        return encodedPrefix;
    }

    public Path getTempFolder(String prefix, String name) throws IOException {
        Path tempSubfolder = this.tempPath.resolve(this.hashPrefix(prefix)).resolve(name);
        if (!Files.exists(tempSubfolder, new LinkOption[0])) {
            Files.createDirectories(tempSubfolder, new FileAttribute[0]);
        }
        return tempSubfolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OcrResult> ocrImageFiles(List<Path> sourceImages, Path destinationText, boolean createSearchablePdf, Path destinationPdf, Semaphore semaphore, AtomicLong pagesProcessed) {
        Path tempFolder = null;
        try {
            tempFolder = this.getTempFolder(destinationText.getParent().toString(), destinationText.getFileName().toString());
        }
        catch (IOException e) {
            LOGGER.error("Cannot prepare temp folder", (Throwable)e);
        }
        try {
            List<OcrResult> list = this.ocrImageFiles(sourceImages, destinationText, createSearchablePdf, destinationPdf, semaphore, pagesProcessed, tempFolder);
            return list;
        }
        finally {
            if (tempFolder != null && !this.dontCleanUpOnClose) {
                try {
                    org.apache.commons.io.FileUtils.deleteDirectory((File)tempFolder.toFile());
                }
                catch (IOException e) {
                    LOGGER.error("Cannot delete temp folder", (Throwable)e);
                }
            }
        }
    }

    public List<OcrResult> ocrImageFiles(List<Path> sourceImages, Path destinationText, boolean createSearchablePdf, Path destinationPdf, Semaphore semaphore, AtomicLong pagesProcessed, Path tempFolder) {
        return this.ocrImageFiles(DateTime.now().getMillis(), sourceImages, destinationText, createSearchablePdf, destinationPdf, semaphore, pagesProcessed, tempFolder);
    }

    public List<OcrResult> ocrImageFiles(long startEpoch, List<Path> sourceImages, Path destinationText, boolean createSearchablePdf, Path destinationPdf, Semaphore semaphore, AtomicLong pagesProcessed, Path tempFolder) {
        ConcurrentHashMap sourceImagesResults;
        block45: {
            sourceImagesResults = new ConcurrentHashMap();
            try {
                boolean threadInterrupted;
                Semaphore internalSemaphone = new Semaphore(1);
                ConcurrentHashMap<Long, Thread> activeThreads = new ConcurrentHashMap<Long, Thread>();
                AtomicLong threadsCount = new AtomicLong();
                block15: for (Path sourceImage : sourceImages) {
                    boolean result;
                    if (Thread.interrupted()) break;
                    if ((long)(this.timeoutS * 1000) < DateTime.now().getMillis() - startEpoch) {
                        throw new TimeoutException("Timeout of " + this.timeoutS + " s exceeded");
                    }
                    Path tempDestinationText = tempFolder.resolve(sourceImage.getFileName());
                    Long threadId = threadsCount.getAndIncrement();
                    Path finalTempFolder = tempFolder;
                    Thread threadGlobal = new Thread(() -> {
                        try {
                            OcrResult result = this.ocrImageFile(startEpoch, sourceImage, null, tempDestinationText, createSearchablePdf, tempDestinationText, finalTempFolder, pagesProcessed);
                            sourceImagesResults.put(sourceImage, result);
                        }
                        finally {
                            if (semaphore != null) {
                                semaphore.release();
                            }
                            activeThreads.remove(threadId);
                        }
                    });
                    Thread threadInternal = new Thread(() -> {
                        try {
                            OcrResult result = this.ocrImageFile(startEpoch, sourceImage, null, tempDestinationText, createSearchablePdf, tempDestinationText, finalTempFolder, pagesProcessed);
                            sourceImagesResults.put(sourceImage, result);
                        }
                        finally {
                            internalSemaphone.release();
                            activeThreads.remove(threadId);
                        }
                    });
                    activeThreads.put(threadId, threadInternal);
                    do {
                        if (internalSemaphone.tryAcquire()) {
                            threadInternal.setName("OCR document handling");
                            threadInternal.start();
                            continue block15;
                        }
                        activeThreads.put(threadId, threadGlobal);
                        result = true;
                        if (semaphore == null) continue;
                        result = semaphore.tryAcquire(20L, TimeUnit.MILLISECONDS);
                    } while (!result);
                    threadGlobal.setName("OCR document handling");
                    threadGlobal.start();
                }
                boolean timeoutEncountered = false;
                while (activeThreads.size() > 0) {
                    if ((long)(this.timeoutS * 1000) < DateTime.now().getMillis() - startEpoch) {
                        timeoutEncountered = true;
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                        break;
                    }
                }
                if ((threadInterrupted = Thread.interrupted()) || timeoutEncountered) {
                    for (Thread activeThread : activeThreads.values()) {
                        if (!activeThread.isAlive()) continue;
                        activeThread.interrupt();
                    }
                }
                if (timeoutEncountered) {
                    throw new TimeoutException("Timeout of " + this.timeoutS + " s exceeded");
                }
                boolean firstTextPage = true;
                Path destinationTextWithExtension = Paths.get(String.valueOf(destinationText.toAbsolutePath()) + ".txt", new String[0]);
                Path textParentFolder = destinationTextWithExtension.getParent();
                if (!Files.exists(textParentFolder, new LinkOption[0])) {
                    try {
                        Files.createDirectories(textParentFolder, new FileAttribute[0]);
                    }
                    catch (IOException e) {
                        LOGGER.warn("Cannot create PDF output folder", (Throwable)e);
                    }
                }
                Path destinationPdfWithExtension = Paths.get(String.valueOf(destinationPdf.toAbsolutePath()) + ".pdf", new String[0]);
                long textSize = 0L;
                for (Path sourceImage : sourceImages) {
                    if ((long)(this.timeoutS * 1000) < DateTime.now().getMillis() - startEpoch) {
                        throw new TimeoutException("Timeout of " + this.timeoutS + " s exceeded");
                    }
                    Path tempDestinationTextWithExtension = tempFolder.resolve(String.valueOf(sourceImage.getFileName()) + ".txt");
                    Object pageText = "";
                    if (Files.exists(tempDestinationTextWithExtension, new LinkOption[0])) {
                        pageText = FileUtils.readFileWithAutodetectEncoding((File)tempDestinationTextWithExtension.toFile());
                    }
                    textSize += (long)((String)pageText).length();
                    if (!firstTextPage) {
                        pageText = (String)pageText + PAGE_BREAK;
                    }
                    Files.write(destinationTextWithExtension, ((String)pageText).getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
                    firstTextPage = false;
                }
                if (createSearchablePdf) {
                    PDFMergerUtility pdfMergerUtility = new PDFMergerUtility();
                    pdfMergerUtility.setDestinationFileName(destinationPdfWithExtension.toString());
                    Path pdfFolderParent = destinationPdfWithExtension.getParent();
                    if (!Files.exists(pdfFolderParent, new LinkOption[0])) {
                        try {
                            Files.createDirectories(pdfFolderParent, new FileAttribute[0]);
                        }
                        catch (IOException e) {
                            LOGGER.warn("Cannot create PDF output folder", (Throwable)e);
                        }
                    }
                    for (Path sourceImage : sourceImages) {
                        if ((long)(this.timeoutS * 1000) < DateTime.now().getMillis() - startEpoch) {
                            throw new TimeoutException("Timeout of " + this.timeoutS + " s exceeded");
                        }
                        Path tempDestinationPdfWithExtension = tempFolder.resolve(String.valueOf(sourceImage.getFileName()) + ".pdf");
                        if (!Files.exists(tempDestinationPdfWithExtension, new LinkOption[0])) {
                            try {
                                PDDocument document = new PDDocument();
                                BufferedImage bufferedImage = ImageIO.read(sourceImage.toFile());
                                float imageWidth = bufferedImage.getWidth();
                                float imageHeight = bufferedImage.getHeight();
                                float drawWidth = imageWidth;
                                float drawHeight = imageHeight;
                                PDPage page = new PDPage(PDRectangle.LETTER);
                                float pageWidth = page.getMediaBox().getWidth();
                                float pageHeight = page.getMediaBox().getHeight();
                                float scale = 1.0f;
                                scale = imageWidth / pageWidth;
                                drawWidth = imageWidth / scale;
                                drawHeight = imageHeight / scale;
                                if (drawHeight > pageHeight) {
                                    scale = imageHeight / pageHeight;
                                    drawWidth = imageWidth / scale;
                                    drawHeight = imageHeight / scale;
                                }
                                document.addPage(page);
                                PDImageXObject image = PDImageXObject.createFromFile((String)sourceImage.toString(), (PDDocument)document);
                                PDPageContentStream contentStream = new PDPageContentStream(document, page);
                                contentStream.drawImage(image, 0.0f, 0.0f, drawWidth, drawHeight);
                                contentStream.close();
                                document.save(tempDestinationPdfWithExtension.toString());
                                document.close();
                            }
                            catch (Exception e) {
                                LOGGER.error("Cannot convert image to PDF", (Throwable)e);
                            }
                        }
                        if (!Files.exists(tempDestinationPdfWithExtension, new LinkOption[0])) {
                            try (InputStream stream = this.getClass().getResourceAsStream("/templates/pageError.pdf");){
                                Files.copy(stream, tempDestinationPdfWithExtension, StandardCopyOption.REPLACE_EXISTING);
                            }
                            LOGGER.error("Cannot add document " + String.valueOf(sourceImage) + " to searchable PDF");
                            OcrResult result = (OcrResult)sourceImagesResults.get(sourceImage);
                            if (result != null) {
                                result.setStatus(OcrStatus.FAILED);
                                Object existingMessage = result.getMessage();
                                if (existingMessage != null && ((String)existingMessage).length() > 0) {
                                    existingMessage = (String)existingMessage + ", ";
                                    existingMessage = (String)existingMessage + "Cannot add searchable PDF";
                                } else {
                                    existingMessage = "Cannot add searchable PDF";
                                }
                                result.setMessage((String)existingMessage);
                            }
                        }
                        pdfMergerUtility.addSource(tempDestinationPdfWithExtension.toFile());
                    }
                    pdfMergerUtility.mergeDocuments(null);
                }
                if (textSize == 0L) {
                    OcrResult result = (OcrResult)sourceImagesResults.get(sourceImages.get(0));
                    result.setStatus(OcrStatus.FAILED);
                }
            }
            catch (Exception e) {
                OcrResult result = (OcrResult)sourceImagesResults.get(sourceImages.get(0));
                if (result == null) break block45;
                result.setStatus(OcrStatus.FAILED);
                Object existingMessage = result.getMessage();
                if (existingMessage != null && ((String)existingMessage).length() > 0) {
                    existingMessage = (String)existingMessage + ", ";
                    existingMessage = (String)existingMessage + ExceptionUtils.getExceptionPrintableMessage((Throwable)e, (boolean)true);
                } else {
                    existingMessage = ExceptionUtils.getExceptionPrintableMessage((Throwable)e, (boolean)true);
                }
                result.setMessage((String)existingMessage);
            }
        }
        ArrayList<OcrResult> results = new ArrayList<OcrResult>();
        for (Path sourceImage : sourceImages) {
            OcrResult result = (OcrResult)sourceImagesResults.get(sourceImage);
            if (result == null) continue;
            results.add(result);
        }
        return results;
    }

    public OcrResult ocrImageFile(Path sourceImage, Path destinationText, boolean createSearchablePdf, Path destinationPdf) {
        return this.ocrImageFile(DateTime.now().getMillis(), sourceImage, destinationText, createSearchablePdf, destinationPdf, new AtomicLong(0L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OcrResult ocrImageFile(long startEpoch, Path sourceImage, Path destinationText, boolean createSearchablePdf, Path destinationPdf, AtomicLong pagesProcessed) {
        Path tempFolder = null;
        try {
            tempFolder = this.getTempFolder(sourceImage.getParent().toString(), destinationText.getFileName().toString());
        }
        catch (IOException e) {
            LOGGER.error("Cannot prepare temp folder", (Throwable)e);
        }
        try {
            OcrResult ocrResult = this.ocrImageFile(startEpoch, sourceImage, destinationText, createSearchablePdf, destinationPdf, pagesProcessed, tempFolder);
            return ocrResult;
        }
        finally {
            if (tempFolder != null && !this.dontCleanUpOnClose) {
                try {
                    org.apache.commons.io.FileUtils.deleteDirectory((File)tempFolder.toFile());
                }
                catch (IOException e) {
                    LOGGER.error("Cannot delete temp folder", (Throwable)e);
                }
            }
        }
    }

    public OcrResult ocrImageFile(long startEpoch, Path sourceImage, Path destinationText, boolean createSearchablePdf, Path destinationPdf, AtomicLong pagesProcessed, Path tempFolder) {
        return this.ocrImageFile(startEpoch, sourceImage, null, destinationText, createSearchablePdf, destinationPdf, tempFolder, pagesProcessed);
    }

    public OcrResult ocrImageFile(long startEpoch, Path sourceImagePath, BufferedImage sourceImageContent, Path destinationText, boolean createSearchablePdf, Path destinationPdf, Path tempFolder, AtomicLong pagesProcessed) {
        String fileExtension;
        if (sourceImagePath != null && (fileExtension = FileUtils.getFileExtension((String)sourceImagePath.getFileName().toString()).toLowerCase()).equals("bmp")) {
            try {
                sourceImageContent = ImageIO.read(sourceImagePath.toFile());
            }
            catch (IOException e) {
                LOGGER.warn("Cannot normalize BMP file", (Throwable)e);
            }
            if (sourceImageContent != null) {
                sourceImagePath = null;
            }
        }
        Path image = sourceImagePath;
        int rasterizeDpi = 300;
        if (this.rasterizePdfDpiEnabled) {
            rasterizeDpi = this.rasterizePdfDpi;
        }
        boolean autoRotation = Rotation.AUTO_DETECT.equals((Object)this.rotation);
        boolean angleRotation = Rotation.ROTATE_90_LEFT.equals((Object)this.rotation) || Rotation.ROTATE_90_RIGHT.equals((Object)this.rotation) || Rotation.ROTATE_180.equals((Object)this.rotation);
        BufferedImage rotatedImage = null;
        double totalAngle = 0.0;
        Object label = "";
        boolean rotationPerformed = false;
        if (angleRotation) {
            try {
                if (sourceImageContent == null) {
                    sourceImageContent = ImageIO.read(sourceImagePath.toFile());
                }
                LOGGER.info("Rotating image with " + (totalAngle += this.rotation.getAngle()) + " degrees");
                rotatedImage = ImageUtil.rotate(sourceImageContent, -totalAngle, sourceImageContent.getWidth() / 2, sourceImageContent.getHeight() / 2);
                label = (String)label + "_r" + Math.round(this.rotation.getAngle());
                rotationPerformed = true;
            }
            catch (Exception e) {
                LOGGER.warn("Cannot rotate image", (Throwable)e);
            }
        }
        boolean deskewError = false;
        if (this.deskew) {
            double deskewAngle = 0.0;
            try {
                if (sourceImageContent == null) {
                    sourceImageContent = ImageIO.read(sourceImagePath.toFile());
                }
                if (rotatedImage == null) {
                    rotatedImage = sourceImageContent;
                }
                int deskewSteps = 0;
                for (int i = 0; i < 6; ++i) {
                    if ((long)(this.timeoutS * 1000) < DateTime.now().getMillis() - startEpoch) {
                        throw new TimeoutException("Timeout of " + this.timeoutS + " s exceeded");
                    }
                    ImageDeskew imageDeskew = new ImageDeskew(rotatedImage, autoRotation);
                    double skewAngle = imageDeskew.getSkewAngle();
                    LOGGER.info("Run #" + i + " rotating image with " + skewAngle + " deg");
                    totalAngle += skewAngle;
                    if ((deskewAngle += skewAngle) > 180.0 || deskewAngle < -180.0) {
                        LOGGER.info("Run #" + i + " total rotating " + deskewAngle + ". Aborting deskew.");
                        deskewAngle = 0.0;
                        rotatedImage = sourceImageContent;
                        break;
                    }
                    if (!(Math.abs(skewAngle) > 0.5)) break;
                    rotatedImage = ImageUtil.rotate(sourceImageContent, -totalAngle, sourceImageContent.getWidth() / 2, sourceImageContent.getHeight() / 2);
                    ++deskewSteps;
                    rotationPerformed = true;
                }
                if (deskewSteps > 0) {
                    label = (String)label + "_d" + Math.round(deskewAngle) + "_s" + deskewSteps;
                }
            }
            catch (Exception e) {
                LOGGER.warn("Cannot deskew image", (Throwable)e);
                deskewError = true;
            }
        }
        try {
            if (rotatedImage != null && rotationPerformed) {
                image = tempFolder.resolve(String.valueOf(destinationText.getFileName()) + (String)label + ".png");
                ImageIOUtil.writeImage((BufferedImage)rotatedImage, (String)image.toString(), (int)rasterizeDpi);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Cannot write rotated / deskwed image", (Throwable)e);
        }
        if (autoRotation && !deskewError) {
            image = this.autoRotateImage(image, sourceImagePath, tempFolder, destinationText, sourceImageContent, rasterizeDpi, startEpoch, totalAngle, (String)label);
        }
        if (image == null) {
            try {
                image = tempFolder.resolve(String.valueOf(destinationText.getFileName()) + ".png");
                ImageIOUtil.writeImage((BufferedImage)sourceImageContent, (String)image.toString(), (int)rasterizeDpi);
            }
            catch (IOException e) {
                LOGGER.warn("Cannot write temp image", (Throwable)e);
            }
        }
        return this.ocrImageFile(startEpoch, image, destinationText, createSearchablePdf, destinationPdf, null, this.tempPath, pagesProcessed);
    }

    protected abstract Path autoRotateImage(Path var1, Path var2, Path var3, Path var4, BufferedImage var5, int var6, long var7, double var9, String var11);

    protected abstract OcrResult ocrImageFile(long var1, Path var3, Path var4, boolean var5, Path var6, Integer var7, Path var8, AtomicLong var9);

    protected void cleanUpIncompleteFile(Path filePath) throws InterruptedException {
        if (!this.keepIncompleteFiles) {
            long startCleanupEpoch = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
            while (Files.exists(filePath, new LinkOption[0])) {
                LOGGER.warn("Deleting incomplete OCR file " + String.valueOf(filePath));
                try {
                    Files.delete(filePath);
                }
                catch (IOException e) {
                    long currentEpoch;
                    long elapsedTime;
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Cannot delete incomplete OCR file " + String.valueOf(filePath), (Throwable)e);
                    }
                    if ((elapsedTime = (currentEpoch = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()) - startCleanupEpoch) > 1000L) break;
                    Thread.sleep(10L);
                }
            }
        }
    }

    protected void createFolderParentIfNotExists(Path filePath) {
        Path parentPath = filePath.getParent();
        if (!Files.exists(parentPath, new LinkOption[0])) {
            try {
                Files.createDirectories(parentPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                LOGGER.warn("Cannot create folder " + String.valueOf(parentPath), (Throwable)e);
            }
        }
    }

    @Override
    public void close() throws Exception {
        if (!this.dontCleanUpOnClose) {
            try {
                org.apache.commons.io.FileUtils.deleteDirectory((File)this.tempPath.toFile());
            }
            catch (IOException e) {
                LOGGER.error("Cannot delete temp folder", (Throwable)e);
            }
        }
    }
}

