/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.ocr;

import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.SystemUtils;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.options.nativeocr.OcrEngineModes;
import com.nuix.automate.workflow.core.execution.options.nativeocr.PageSegmentationMode;
import com.nuix.automate.workflow.core.nuix.ExecutionContext;
import com.nuix.automate.workflow.core.utils.ocr.ComputeConsumption;
import com.nuix.automate.workflow.core.utils.ocr.ImageUtil;
import com.nuix.automate.workflow.core.utils.ocr.OcrResult;
import com.nuix.automate.workflow.core.utils.ocr.OcrStatus;
import com.nuix.automate.workflow.core.utils.ocr.OcrUtils;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.apache.pdfbox.tools.imageio.ImageIOUtil;
import org.joda.time.DateTime;

public class TesseractOcrUtils
extends OcrUtils {
    private Path engineBinaries;
    private boolean userWordsFileEnabled;
    private String userWordsFile;
    private boolean userPatternsFileEnabled;
    private String userPatternsFile;
    private boolean dpiEnabled;
    private Integer dpi;
    private boolean languagesEnabled;
    private String languages;
    private boolean psmEnabled;
    private PageSegmentationMode psm;
    private boolean oemEnabled;
    private OcrEngineModes oem;
    private boolean ocrEngineConfigFileEnabled;
    private String ocrEngineConfigFile;

    public TesseractOcrUtils(ExecutionContext executionContext, Operation operation, Path defaultTempFolder) throws IOException {
        super(executionContext, operation, defaultTempFolder, new ComputeConsumption(0L));
        Object ocrEngineBinariesFolderString = null;
        try {
            ocrEngineBinariesFolderString = executionContext.evalStringParameter("{wfn_native_ocr_engine_binaries_folder}", operation);
        }
        catch (ParameterException e) {
            LOGGER.warn("Cannot read ocrEngineBinariesFolder from parameter", (Throwable)e);
        }
        if (ocrEngineBinariesFolderString == null) {
            ocrEngineBinariesFolderString = System.getProperty("os.name").contains("Windows") ? SystemUtils.getProgramFilesDir() + "\\Tesseract-OCR" : "/usr/bin";
        }
        this.engineBinaries = Paths.get((String)ocrEngineBinariesFolderString, new String[0]);
        this.logEngineVersion();
        try {
            this.userWordsFile = executionContext.evalStringParameter("{wfn_native_ocr_user_words_file}", operation);
            if (this.userWordsFile != null) {
                this.userWordsFileEnabled = true;
            }
        }
        catch (ParameterException e) {
            LOGGER.warn("Cannot read userWordsFile from parameter", (Throwable)e);
        }
        try {
            this.userPatternsFile = executionContext.evalStringParameter("{wfn_native_ocr_user_patterns_file}", operation);
            if (this.userPatternsFile != null) {
                this.userPatternsFileEnabled = true;
            }
        }
        catch (ParameterException e) {
            LOGGER.warn("Cannot read userPatternsFile from parameter", (Throwable)e);
        }
        try {
            this.dpi = executionContext.evalIntParameter("{wfn_native_ocr_dpi}", operation);
            if (this.dpi != null) {
                this.dpiEnabled = true;
            }
        }
        catch (ParameterException e) {
            LOGGER.warn("Cannot read dpi from parameter", (Throwable)e);
        }
        try {
            this.languages = executionContext.evalStringParameter("{wfn_native_ocr_languages}", operation);
            if (this.languages != null) {
                this.languagesEnabled = true;
            }
        }
        catch (ParameterException e) {
            LOGGER.warn("Cannot read languages from parameter", (Throwable)e);
        }
        try {
            String psmString = executionContext.evalStringParameter("{wfn_native_ocr_psm}", operation);
            if (psmString != null) {
                this.psm = PageSegmentationMode.valueOf(psmString);
                this.psmEnabled = true;
            }
        }
        catch (ParameterException e) {
            LOGGER.warn("Cannot read psm from parameter", (Throwable)e);
        }
        try {
            String oemString = executionContext.evalStringParameter("{wfn_native_ocr_oem}", operation);
            if (oemString != null) {
                this.oem = OcrEngineModes.valueOf(oemString);
                this.oemEnabled = true;
            }
        }
        catch (ParameterException e) {
            LOGGER.warn("Cannot read oem from parameter", (Throwable)e);
        }
        try {
            this.ocrEngineConfigFile = executionContext.evalStringParameter("{wfn_native_ocr_engine_config_file}", operation);
            if (this.ocrEngineConfigFile != null) {
                this.ocrEngineConfigFileEnabled = true;
            }
        }
        catch (ParameterException e) {
            LOGGER.warn("Cannot read ocrEngineConfigFile from parameter", (Throwable)e);
        }
        this.test();
    }

    private void readStandardErrorAsync(Process process, Set<String> messageLines) {
        Thread readStandardErrorThread = new Thread(() -> {
            try (BufferedReader errorReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));){
                this.readErrorStream(errorReader, messageLines);
            }
            catch (IOException e) {
                LOGGER.error("Cannot read standard error stream", (Throwable)e);
            }
        });
        readStandardErrorThread.setDaemon(true);
        readStandardErrorThread.setName("Automate OCR Stderr reader");
        readStandardErrorThread.start();
    }

    private void readStandardOutAsync(Process process, Set<String> messageLines) {
        Thread readStandardOutThread = new Thread(() -> {
            try (BufferedReader errorReader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                this.readErrorStream(errorReader, messageLines);
            }
            catch (IOException e) {
                LOGGER.error("Cannot read standard output stream", (Throwable)e);
            }
        });
        readStandardOutThread.setDaemon(true);
        readStandardOutThread.setName("Automate OCR Stdout reader");
        readStandardOutThread.start();
    }

    private void readErrorStream(BufferedReader reader, Set<String> errorLines) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            errorLines.add(line);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void test() throws IOException {
        if (!Files.exists(this.engineBinaries.resolve("tesseract.exe"), new LinkOption[0]) && !Files.exists(this.engineBinaries.resolve("tesseract"), new LinkOption[0])) {
            throw new IOException(this.iu.getFormattedString("ConfigureNativeOcrOperation.Error.EngineNotFound", (Object)this.engineBinaries.toString()));
        }
        try (InputStream stream = this.getClass().getResourceAsStream("/images/testOcr.png");){
            Path tempImageFile = FileUtils.createTempFilePath((String)"_test_ocr_image", (String)".png", (FileAttribute[])new FileAttribute[0]);
            Path tempOutputFolder = Files.createTempDirectory("_test_ocr_image", new FileAttribute[0]);
            Path tempOutputPath = tempOutputFolder.resolve("_test_ocr_image");
            try (FileOutputStream outStream = new FileOutputStream(tempImageFile.toFile());){
                int bytesRead;
                byte[] buffer = new byte[8192];
                while ((bytesRead = stream.read(buffer)) != -1) {
                    ((OutputStream)outStream).write(buffer, 0, bytesRead);
                }
                Semaphore semaphore = new Semaphore(1);
                OcrResult ocrResult = this.ocrFile(tempImageFile, tempOutputPath, true, tempOutputPath, semaphore);
                if (!ocrResult.getStatus().equals((Object)OcrStatus.SUCCESS)) {
                    throw new IOException("Cannot run OCR, " + ocrResult.getMessage());
                }
            }
            finally {
                try {
                    FileUtils.deleteRecursively((Path)tempImageFile);
                }
                catch (IOException e) {
                    LOGGER.warn("Cannot delete temp image", (Throwable)e);
                }
            }
            try {
                org.apache.commons.io.FileUtils.deleteDirectory((File)tempOutputFolder.toFile());
            }
            catch (IOException e) {
                LOGGER.warn("Cannot delete temp folder", (Throwable)e);
            }
            Path destinationTextFile = Paths.get(tempImageFile.toString() + ".txt", new String[0]);
            try {
                FileUtils.deleteRecursively((Path)destinationTextFile);
            }
            catch (IOException e) {
                LOGGER.warn("Cannot delete temp file", (Throwable)e);
            }
            Path destinationPdfFile = Paths.get(tempImageFile.toString() + ".pdf", new String[0]);
            try {
                FileUtils.deleteRecursively((Path)destinationPdfFile);
            }
            catch (IOException e) {
                LOGGER.warn("Cannot delete temp file", (Throwable)e);
            }
        }
    }

    public void logEngineVersion() {
        ArrayList<String> commandLine = new ArrayList<String>();
        LinkedHashSet<String> messageLines = new LinkedHashSet<String>();
        commandLine.add(this.engineBinaries.resolve("tesseract").toAbsolutePath().toString());
        commandLine.add("--version");
        ProcessBuilder builder = new ProcessBuilder(commandLine);
        Process process = null;
        try {
            LOGGER.info("Running: " + FormattingUtils.encodeCommandLineForPrinting(commandLine));
            process = builder.start();
            this.readStandardErrorAsync(process, messageLines);
            this.readStandardOutAsync(process, messageLines);
            try {
                process.waitFor(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                LOGGER.error("Cannot wait for process to complete");
            }
        }
        catch (IOException e) {
            LOGGER.error("Cannot get OCR Engine Version");
        }
        for (String line : messageLines) {
            LOGGER.info(line);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePage(Path sourceImage, int finalPageId, float normalizedDpi, long startEpoch, Path tempDestinationText, boolean createSearchablePdf, Path finalTempFolder, AtomicLong pagesProcessed, List<String> messages, AtomicBoolean finalFailure, Semaphore semaphore, Long threadId, Map<Long, Thread> activeThreads) {
        block28: {
            PDDocument localDocument = null;
            PDFRenderer localPdfRenderer = null;
            try {
                OcrResult result;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("File " + String.valueOf(sourceImage) + " page " + (finalPageId + 1) + " exporting");
                }
                if (Thread.interrupted()) {
                    return;
                }
                localDocument = Loader.loadPDF((File)sourceImage.toFile());
                localPdfRenderer = new PDFRenderer(localDocument);
                BufferedImage bufferedImage = localPdfRenderer.renderImageWithDPI(finalPageId, normalizedDpi, ImageType.RGB);
                if (Thread.interrupted()) {
                    return;
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("File " + String.valueOf(sourceImage) + " page " + (finalPageId + 1) + " OCRing");
                }
                if ((result = this.ocrImageFile(startEpoch, null, bufferedImage, tempDestinationText, createSearchablePdf, tempDestinationText, finalTempFolder, pagesProcessed)).getMessage() == null || result.getMessage().length() <= 0) break block28;
                List<String> list = messages;
                synchronized (list) {
                    messages.add("Page " + (finalPageId + 1) + ": " + result.getMessage());
                }
            }
            catch (Throwable e) {
                LOGGER.error("File " + String.valueOf(sourceImage) + " page " + (finalPageId + 1) + " OCR error", e);
                finalFailure.set(true);
                List<String> list = messages;
                synchronized (list) {
                    messages.add("Page " + (finalPageId + 1) + ": " + ExceptionUtils.getExceptionPrintableMessage((Throwable)e, (boolean)true));
                }
            }
            finally {
                try {
                    if (localDocument != null) {
                        localDocument.close();
                    }
                }
                catch (IOException e) {
                    LOGGER.error("File " + String.valueOf(sourceImage) + " page " + (finalPageId + 1) + " cannot close PDF document", (Throwable)e);
                }
                semaphore.release();
                activeThreads.remove(threadId);
            }
        }
    }

    @Override
    protected OcrResult ocrImageFile(long startEpoch, Path sourceImage, Path destinationText, boolean createSearchablePdf, Path destinationPdf, Integer expectedPages, Path tempPath, AtomicLong pagesProcessed) {
        return this.tesseractOcr(startEpoch, sourceImage, destinationText, createSearchablePdf, destinationPdf, expectedPages, tempPath, pagesProcessed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OcrResult tesseractOcr(long startEpoch, Path sourceImage, Path destinationText, boolean createSearchablePdf, Path destinationPdf, Integer expectedPages) {
        Path tempPath = null;
        try {
            tempPath = this.getTempFolder(sourceImage.getParent().toString(), destinationText.getFileName().toString());
        }
        catch (IOException e) {
            LOGGER.error("Cannot prepare temp path", (Throwable)e);
        }
        try {
            OcrResult ocrResult = this.tesseractOcr(startEpoch, sourceImage, destinationText, createSearchablePdf, destinationPdf, expectedPages, tempPath, new AtomicLong(0L));
            return ocrResult;
        }
        finally {
            if (tempPath != null && !this.dontCleanUpOnClose) {
                try {
                    org.apache.commons.io.FileUtils.deleteDirectory((File)tempPath.toFile());
                }
                catch (IOException e) {
                    LOGGER.error("Cannot delete temp folder", (Throwable)e);
                }
            }
        }
    }

    public OcrResult tesseractOcr(long startEpoch, Path sourceImage, Path destinationText, boolean createSearchablePdf, Path destinationPdf, Integer expectedPages, Path tempPath, AtomicLong pagesProcessed) {
        OcrStatus status = OcrStatus.SUCCESS;
        Object message = null;
        LinkedHashSet<String> messageLines = new LinkedHashSet<String>();
        try {
            boolean processExited;
            Path outputTempPath = tempPath.resolve(this.hashPrefix(sourceImage.getParent().toString())).resolve("out");
            Path tempDestinationWithoutExtension = outputTempPath.resolve(destinationText.getFileName().toString());
            Path tempDestinationTextWithExtension = outputTempPath.resolve(destinationText.getFileName().toString() + ".txt");
            this.createFolderParentIfNotExists(tempDestinationTextWithExtension);
            Path destinationTextWithExtension = Paths.get(String.valueOf(destinationText.toAbsolutePath()) + ".txt", new String[0]);
            Path tempDestinationPdfWithExtension = outputTempPath.resolve(destinationText.getFileName().toString() + ".pdf");
            Path destinationPdfWithExtension = Paths.get(String.valueOf(destinationPdf.toAbsolutePath()) + ".pdf", new String[0]);
            ArrayList<String> commandLine = new ArrayList<String>();
            commandLine.add(this.engineBinaries.resolve("tesseract").toAbsolutePath().toString());
            commandLine.add(sourceImage.toAbsolutePath().toString());
            commandLine.add(tempDestinationWithoutExtension.toAbsolutePath().toString());
            if (this.userWordsFileEnabled) {
                commandLine.add("--user-words");
                commandLine.add(this.userWordsFile);
            }
            if (this.userPatternsFileEnabled) {
                commandLine.add("--user-patterns");
                commandLine.add(this.userPatternsFile);
            }
            if (this.dpiEnabled) {
                commandLine.add("--dpi");
                commandLine.add("" + this.dpi);
            }
            if (this.logLevelEnabled) {
                commandLine.add("--loglevel");
                commandLine.add(this.logLevel.name());
            }
            if (this.languagesEnabled) {
                commandLine.add("-l");
                commandLine.add(this.languages);
            }
            if (this.psmEnabled) {
                commandLine.add("--psm");
                commandLine.add("" + this.psm.toTesseractOption());
            }
            if (this.oemEnabled) {
                commandLine.add("--oem");
                commandLine.add("" + this.oem.toTesseractOption());
            }
            if (this.ocrEngineConfigFileEnabled) {
                commandLine.add(this.ocrEngineConfigFile);
            }
            if (createSearchablePdf) {
                commandLine.add("-c");
                commandLine.add("tessedit_create_pdf=1");
                commandLine.add("-c");
                commandLine.add("tessedit_create_txt=1");
            }
            LOGGER.info("Running: " + FormattingUtils.encodeCommandLineForPrinting(commandLine));
            ProcessBuilder builder = new ProcessBuilder(commandLine).directory(sourceImage.toFile().getParentFile());
            Process process = builder.start();
            this.readStandardErrorAsync(process, messageLines);
            this.readStandardOutAsync(process, messageLines);
            Integer timeoutS = null;
            if (this.timeoutPerFileEnabled) {
                timeoutS = this.timeoutPerFile;
            }
            if (timeoutS == null) {
                timeoutS = 600;
            }
            try {
                long remainingWorkTime = (long)(timeoutS * 1000) - (DateTime.now().getMillis() - startEpoch);
                processExited = process.waitFor(remainingWorkTime, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                LOGGER.error("Cannot wait for process to finish", (Throwable)e);
                process.destroy();
                throw e;
            }
            if (!processExited) {
                process.destroyForcibly();
                status = OcrStatus.FAILED;
                messageLines.add("Timeout of " + timeoutS + " s exceeded");
                this.cleanUpIncompleteFile(tempDestinationTextWithExtension);
                this.cleanUpIncompleteFile(tempDestinationPdfWithExtension);
            }
            long textSize = 0L;
            if (Files.exists(tempDestinationTextWithExtension, new LinkOption[0])) {
                textSize = Files.size(tempDestinationTextWithExtension);
            }
            if (textSize == 0L) {
                status = OcrStatus.FAILED;
                messageLines.add("The OCR did not extract any text");
            } else if (expectedPages == null) {
                expectedPages = 1;
            }
            if (Files.exists(tempDestinationTextWithExtension, new LinkOption[0])) {
                try {
                    this.createFolderParentIfNotExists(destinationTextWithExtension);
                    FileUtils.deleteRecursively((Path)destinationTextWithExtension);
                    Files.move(tempDestinationTextWithExtension, destinationTextWithExtension, new CopyOption[0]);
                }
                catch (IOException e) {
                    status = OcrStatus.FAILED;
                    messageLines.add("Cannot move text file " + ExceptionUtils.getExceptionPrintableMessage((Throwable)e, (boolean)true));
                }
            }
            if (createSearchablePdf && Files.exists(tempDestinationPdfWithExtension, new LinkOption[0])) {
                try {
                    this.createFolderParentIfNotExists(destinationPdfWithExtension);
                    FileUtils.deleteRecursively((Path)destinationPdfWithExtension);
                    Files.move(tempDestinationPdfWithExtension, destinationPdfWithExtension, new CopyOption[0]);
                }
                catch (IOException e) {
                    status = OcrStatus.FAILED;
                    messageLines.add("Cannot move PDF file " + ExceptionUtils.getExceptionPrintableMessage((Throwable)e, (boolean)true));
                }
            }
            if (process.exitValue() != 0) {
                status = OcrStatus.FAILED;
                message = "Process exit code " + process.exitValue();
            }
            if (messageLines.size() > 0) {
                message = String.join((CharSequence)"\n", messageLines);
            }
        }
        catch (Exception e) {
            status = OcrStatus.FAILED;
            message = ExceptionUtils.getExceptionPrintableMessage((Throwable)e, (boolean)true);
        }
        Integer maxPage = expectedPages;
        if (!Thread.interrupted()) {
            Pattern pattern = Pattern.compile("Page (\\d+)");
            boolean page0Detected = false;
            for (String line : messageLines) {
                Matcher matcher = pattern.matcher(line);
                if (!matcher.find()) continue;
                String pageNumber = matcher.group(1);
                try {
                    Integer parsedPageNumber = Integer.parseInt(pageNumber);
                    if (parsedPageNumber == 0) {
                        page0Detected = true;
                    }
                    if (page0Detected) {
                        Integer n = parsedPageNumber;
                        parsedPageNumber = parsedPageNumber + 1;
                    }
                    if (maxPage == null) {
                        maxPage = parsedPageNumber;
                        continue;
                    }
                    maxPage = Math.max(maxPage, parsedPageNumber);
                }
                catch (NumberFormatException e) {
                    LOGGER.error("Cannot parse page number " + pageNumber, (Throwable)e);
                }
            }
            if (maxPage == null) {
                maxPage = 1;
            }
            pagesProcessed.addAndGet(maxPage.intValue());
        }
        if (this.isLogLevelOff()) {
            message = "";
        } else if (this.isLogLevelError() && status.equals((Object)OcrStatus.SUCCESS)) {
            message = "";
        }
        long endEpoch = DateTime.now().getMillis();
        return new OcrResult((String)message, new ComputeConsumption(endEpoch - startEpoch), status, maxPage);
    }

    public double tesseractDetectRotation(long startEpoch, Path sourceImage, Path destinationText, Path tempPath) throws IOException {
        try {
            boolean processExited;
            Path tempDestinationWithoutExtension = tempPath.resolve(destinationText.getFileName().toString() + "_ar");
            Path tempDestinationWithExtension = tempPath.resolve(destinationText.getFileName().toString() + "_ar.osd");
            ArrayList<String> commandLine = new ArrayList<String>();
            commandLine.add(this.engineBinaries.resolve("tesseract").toAbsolutePath().toString());
            commandLine.add(sourceImage.toAbsolutePath().toString());
            commandLine.add(tempDestinationWithoutExtension.toAbsolutePath().toString());
            if (this.logLevelEnabled) {
                commandLine.add("--loglevel");
                commandLine.add(this.logLevel.name());
            }
            commandLine.add("--psm");
            commandLine.add("0");
            LOGGER.info("Running: " + FormattingUtils.encodeCommandLineForPrinting(commandLine));
            ProcessBuilder builder = new ProcessBuilder(commandLine).directory(sourceImage.toFile().getParentFile());
            Process process = builder.start();
            Integer timeoutS = null;
            if (this.timeoutPerFileEnabled) {
                timeoutS = this.timeoutPerFile;
            }
            if (timeoutS == null) {
                timeoutS = 600;
            }
            try {
                long remainingWorkTime = (long)(timeoutS * 1000) - (DateTime.now().getMillis() - startEpoch);
                processExited = process.waitFor(remainingWorkTime, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                LOGGER.error("Cannot wait for process to finish", (Throwable)e);
                process.destroy();
                throw e;
            }
            if (!processExited) {
                process.destroyForcibly();
            }
            if (Files.exists(tempDestinationWithExtension, new LinkOption[0])) {
                String fileContents = FileUtils.readFileWithAutodetectEncoding((File)tempDestinationWithExtension.toFile());
                Matcher matcher = this.rotationPattern.matcher(fileContents);
                if (matcher.find()) {
                    String rotationString = matcher.group(1);
                    return Double.parseDouble(rotationString);
                }
                return 0.0;
            }
            throw new IOException("Tesseract OSD file not found");
        }
        catch (Exception e) {
            throw new IOException("Cannot detect rotation", e);
        }
    }

    @Override
    protected Path autoRotateImage(Path image, Path sourceImagePath, Path tempFolder, Path destinationText, BufferedImage sourceImageContent, int rasterizeDpi, long startEpoch, double totalAngle, String label) {
        if (image == null) {
            try {
                image = tempFolder.resolve(String.valueOf(destinationText.getFileName()) + ".png");
                ImageIOUtil.writeImage((BufferedImage)sourceImageContent, (String)image.toString(), (int)rasterizeDpi);
            }
            catch (IOException e) {
                LOGGER.warn("Cannot write temp image", (Throwable)e);
            }
        }
        try {
            if (sourceImageContent == null) {
                sourceImageContent = ImageIO.read(sourceImagePath.toFile());
            }
            double rotationAngle = this.tesseractDetectRotation(startEpoch, image, destinationText, tempFolder);
            totalAngle += rotationAngle;
            if (Math.abs(rotationAngle) > 0.5) {
                BufferedImage rotatedImage = ImageUtil.rotate(sourceImageContent, -totalAngle, sourceImageContent.getWidth() / 2, sourceImageContent.getHeight() / 2);
                label = (String)label + "_ar" + Math.round(rotationAngle);
                image = tempFolder.resolve(String.valueOf(destinationText.getFileName()) + (String)label + ".png");
                ImageIOUtil.writeImage((BufferedImage)rotatedImage, (String)image.toString(), (int)rasterizeDpi);
            }
        }
        catch (IOException e) {
            LOGGER.warn("Cannot auto-rotate image", (Throwable)e);
        }
        return image;
    }
}

