/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.utils.purview;

import com.nuix.automate.utils.api.response.TranslationResponseStatus;
import com.nuix.automate.utils.general.SystemUtils;
import com.nuix.automate.utils.models.api.thirdparty.ApiProxyRequest;
import com.nuix.automate.utils.models.internal.graphapi.MicrosoftGraphObject;
import com.nuix.automate.utils.models.internal.graphapi.Team;
import com.nuix.automate.utils.models.internal.graphapi.User;
import com.nuix.automate.utils.models.internal.purview.Custodian;
import com.nuix.automate.utils.models.internal.purview.DataSource;
import com.nuix.automate.utils.models.internal.purview.DataSourceType;
import com.nuix.automate.utils.models.internal.purview.EDiscoveryCase;
import com.nuix.automate.utils.models.internal.purview.EDiscoveryCaseSettings;
import com.nuix.automate.utils.models.internal.purview.EDiscoveryHoldPolicy;
import com.nuix.automate.utils.models.internal.purview.EDiscoveryReviewSet;
import com.nuix.automate.utils.models.internal.purview.EDiscoveryReviewSetExport;
import com.nuix.automate.utils.models.internal.purview.EDiscoveryReviewSetQuery;
import com.nuix.automate.utils.models.internal.purview.EDiscoverySearch;
import com.nuix.automate.utils.models.internal.purview.EDiscoverySearchExport;
import com.nuix.automate.utils.models.internal.purview.NonCustodialDataSource;
import com.nuix.automate.utils.models.internal.purview.operations.AddToReviewSetOperation;
import com.nuix.automate.utils.models.internal.purview.operations.CaseOperation;
import com.nuix.automate.utils.models.internal.purview.operations.EstimateOperation;
import com.nuix.automate.utils.models.internal.purview.operations.HoldOperation;
import com.nuix.automate.utils.models.internal.purview.operations.ReviewSetExportOperation;
import com.nuix.automate.utils.models.internal.purview.operations.SearchExportOperation;
import com.nuix.automate.utils.purview.PurviewUtils;
import com.nuix.automate.workflow.core.utils.general.ThirdPartyProxyRestClient;
import com.nuix.automate.workflow.core.utils.purview.PurviewObjectDoesNotExistException;
import com.nuix.automate.workflow.core.utils.purview.PurviewRestException;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;

public class PurviewRestClient
extends ThirdPartyProxyRestClient {
    public PurviewRestClient(String thirdPartyServiceId, String schedulerUrl, String bearerToken, Set<String> whitelistedCertFingerprints) throws GeneralSecurityException {
        super(thirdPartyServiceId, schedulerUrl, bearerToken, whitelistedCertFingerprints);
        this.setMaxAttempts(SystemUtils.getIntegerProperty((String)"automate.purview.maxAttempts", (Integer)3));
        this.setDelayFactorSeconds(SystemUtils.getIntegerProperty((String)"automate.purview.delayFactorSeconds", (Integer)30));
    }

    @Override
    public String getLogFileName() {
        return System.getProperty("automate.purview.log");
    }

    @Override
    public String getServiceName() {
        return "Microsoft Purview";
    }

    @Override
    protected boolean isResponseReattemptable(TranslationResponseStatus errorResponse) {
        return super.isResponseReattemptable(errorResponse) || errorResponse.getCode() == 409;
    }

    public User getDelegatedUser() throws IOException {
        String endpoint = "/me?$select=" + URLEncoder.encode("displayName,userPrincipalName,mail", StandardCharsets.UTF_8.name());
        return this.proxyApiGetRequest(endpoint, new GenericType<User>(){});
    }

    public String getTenant() throws IOException {
        String endpoint = "/tenant";
        return this.proxyApiGetRequest(endpoint, new GenericType<String>(){});
    }

    public List<EDiscoveryCase> getCases() throws IOException {
        return this.getCases(null);
    }

    public List<EDiscoveryCase> getCases(String filter) throws IOException {
        String endpoint = "/security/cases/eDiscoveryCases?$select=" + URLEncoder.encode("id,displayName,status", StandardCharsets.UTF_8.name());
        if (filter != null) {
            endpoint = endpoint + "&$filter=" + URLEncoder.encode(filter, StandardCharsets.UTF_8.name());
        }
        return this.proxyApiPagedGetRequest(endpoint, new GenericType<List<EDiscoveryCase>>(){});
    }

    public EDiscoveryCase getCaseForId(String caseId) throws IOException {
        String endpoint = "/security/cases/eDiscoveryCases/" + caseId;
        EDiscoveryCase eDiscoveryCase = this.proxyApiGetRequest(endpoint, new GenericType<EDiscoveryCase>(){});
        if (eDiscoveryCase == null) {
            throw new PurviewObjectDoesNotExistException();
        }
        return eDiscoveryCase;
    }

    public EDiscoveryCase getCaseForName(String caseName) throws IOException {
        List<EDiscoveryCase> eDiscoveryCases = this.getCases();
        eDiscoveryCases.removeIf(set -> !set.getDisplayName().equals(caseName));
        if (eDiscoveryCases.isEmpty()) {
            throw new PurviewObjectDoesNotExistException();
        }
        if (eDiscoveryCases.size() > 1) {
            String errorMessage = iu.getFormattedString("PurviewRestClient.Error.MultipleCasesWithName", new Object[]{eDiscoveryCases.size(), caseName});
            throw new PurviewRestException(errorMessage);
        }
        return eDiscoveryCases.get(0);
    }

    public EDiscoveryCase getCaseForNameRegex(String nameRegex) throws IOException {
        return PurviewRestClient.getObjectForNameRegex(nameRegex, this.getCases(), "PurviewRestClient.Error.MultipleCasesMatchingRegex");
    }

    public EDiscoveryCase createCase(EDiscoveryCase eDiscoveryCase) throws IOException {
        String endpoint = "/security/cases/eDiscoveryCases";
        return this.proxyApiRequest(endpoint, "POST", 201, eDiscoveryCase, new GenericType<EDiscoveryCase>(){});
    }

    public EDiscoveryCaseSettings updateCaseSettings(String caseId, EDiscoveryCaseSettings caseSettings) throws IOException {
        String endpoint = "/security/cases/eDiscoveryCases/" + caseId + "/settings";
        return this.proxyApiRequest(endpoint, "PATCH", 204, caseSettings, new GenericType<EDiscoveryCaseSettings>(){});
    }

    public void closeCase(String caseId) throws IOException {
        String endpoint = "/security/cases/eDiscoveryCases/" + caseId + "/close";
        this.proxyApiRequest(endpoint, "POST", 204);
    }

    public void reopenCase(String caseId) throws IOException {
        String endpoint = "/security/cases/eDiscoveryCases/" + caseId + "/reopen";
        this.proxyApiRequest(endpoint, "POST", 204);
    }

    public void deleteCase(String caseId) throws IOException {
        String endpoint = "/security/cases/eDiscoveryCases/" + caseId;
        this.proxyApiRequest(endpoint, "DELETE", 204);
    }

    public List<Custodian> getCustodians(String caseId) throws IOException {
        String endpoint = "/security/cases/eDiscoveryCases/" + caseId + "/custodians";
        return this.proxyApiPagedGetRequest(endpoint, new GenericType<List<Custodian>>(){});
    }

    public Custodian createCustodian(String caseId, Custodian custodian) throws IOException {
        String endpoint = "/security/cases/eDiscoveryCases/" + caseId + "/custodians";
        return this.proxyApiRequest(endpoint, "POST", 201, custodian, new GenericType<Custodian>(){});
    }

    public void activateCustodian(String caseId, String custodianId) throws IOException {
        String endpoint = "/security/cases/eDiscoveryCases/" + caseId + "/custodians/" + custodianId + "/activate";
        this.proxyApiRequest(endpoint, "POST", 202);
    }

    public void releaseCustodian(String caseId, String custodianId) throws IOException {
        String endpoint = "/security/cases/eDiscoveryCases/" + caseId + "/custodians/" + custodianId + "/release";
        this.proxyApiRequest(endpoint, "POST", 202);
    }

    public List<DataSource> getAllDataSourcesForCustodian(String caseId, String custodianId) throws IOException {
        ArrayList<DataSource> dataSources = new ArrayList<DataSource>(this.getUserSourcesForCustodian(caseId, custodianId));
        dataSources.addAll(this.getUnifiedGroupSourcesForCustodian(caseId, custodianId));
        dataSources.addAll(this.getSiteSourcesForCustodian(caseId, custodianId));
        return dataSources;
    }

    public List<DataSource> getUserSourcesForCustodian(String caseId, String custodianId) throws IOException {
        String endpoint = "/security/cases/eDiscoveryCases/" + caseId + "/custodians/" + custodianId + "/userSources";
        return this.getDataSourcesForCustodian(endpoint, DataSourceType.USER);
    }

    public DataSource createUserSourceForCustodian(String caseId, String custodianId, DataSource userSource) throws IOException {
        String endpoint = "/security/cases/eDiscoveryCases/" + caseId + "/custodians/" + custodianId + "/userSources";
        DataSource result = this.proxyApiRequest(endpoint, "POST", 201, userSource, new GenericType<DataSource>(){});
        result.setSourceType(DataSourceType.USER);
        result.setODataId(PurviewUtils.cleanODataContextForSearch((DataSource)result));
        return result;
    }

    public List<DataSource> getUnifiedGroupSourcesForCustodian(String caseId, String custodianId) throws IOException {
        String endpoint = "/security/cases/eDiscoveryCases/" + caseId + "/custodians/" + custodianId + "/unifiedGroupSources";
        return this.getDataSourcesForCustodian(endpoint, DataSourceType.UNIFIED_GROUP);
    }

    public DataSource createUnifiedGroupSourceForCustodian(String caseId, String custodianId, DataSource unifiedGroupSource) throws IOException {
        String endpoint = "/security/cases/eDiscoveryCases/" + caseId + "/custodians/" + custodianId + "/unifiedGroupSources";
        DataSource result = this.proxyApiRequest(endpoint, "POST", 201, unifiedGroupSource, new GenericType<DataSource>(){});
        result.setSourceType(DataSourceType.UNIFIED_GROUP);
        result.setODataId(PurviewUtils.cleanODataContextForSearch((DataSource)result));
        return result;
    }

    public List<DataSource> getSiteSourcesForCustodian(String caseId, String custodianId) throws IOException {
        String endpoint = "/security/cases/eDiscoveryCases/" + caseId + "/custodians/" + custodianId + "/siteSources";
        return this.getDataSourcesForCustodian(endpoint, DataSourceType.SITE);
    }

    public DataSource createSiteSourceForCustodian(String caseId, String custodianId, DataSource siteSource) throws IOException {
        String endpoint = "/security/cases/eDiscoveryCases/" + caseId + "/custodians/" + custodianId + "/siteSources";
        DataSource result = this.proxyApiRequest(endpoint, "POST", 201, siteSource, new GenericType<DataSource>(){});
        result.setSourceType(DataSourceType.SITE);
        result.setODataId(PurviewUtils.cleanODataContextForSearch((DataSource)result));
        return result;
    }

    private List<DataSource> getDataSourcesForCustodian(String endpoint, DataSourceType type) throws IOException {
        List<DataSource> dataSources = this.proxyApiPagedGetRequest(endpoint, new GenericType<List<DataSource>>(){});
        for (DataSource dataSource : dataSources) {
            dataSource.setSourceType(type);
        }
        return dataSources;
    }

    public List<NonCustodialDataSource> getNonCustodialDataSources(String caseId) throws IOException {
        String endpoint = "/security/cases/eDiscoveryCases/" + caseId + "/noncustodialDataSources?$expand=dataSource";
        return this.proxyApiPagedGetRequest(endpoint, new GenericType<List<NonCustodialDataSource>>(){});
    }

    public NonCustodialDataSource createNonCustodialDataSource(String caseId, NonCustodialDataSource nonCustodialDataSource) throws IOException {
        String endpoint = "/security/cases/eDiscoveryCases/" + caseId + "/nonCustodialDataSources";
        NonCustodialDataSource result = this.proxyApiRequest(endpoint, "POST", 201, nonCustodialDataSource, new GenericType<NonCustodialDataSource>(){});
        result.setODataId(PurviewUtils.cleanODataContextForSearch((NonCustodialDataSource)result));
        return result;
    }

    public void releaseNonCustodialDataSource(String caseId, String nonCustodialDataSourceId) throws IOException {
        String endpoint = "/security/cases/eDiscoveryCases/" + caseId + "/nonCustodialDataSources/" + nonCustodialDataSourceId + "/release";
        this.proxyApiRequest(endpoint, "POST", 202);
    }

    public HoldOperation applyHoldToCustodians(String caseId, Collection<String> custodianIds) throws IOException {
        String endpoint = "/security/cases/eDiscoveryCases/" + caseId + "/custodians/applyHold";
        return this.startHoldOperation(endpoint, custodianIds);
    }

    public HoldOperation removeHoldFromCustodians(String caseId, Collection<String> custodianIds) throws IOException {
        String endpoint = "/security/cases/eDiscoveryCases/" + caseId + "/custodians/removeHold";
        return this.startHoldOperation(endpoint, custodianIds);
    }

    public HoldOperation applyHoldToNonCustodialDataSources(String caseId, Collection<String> nonCustodialDataSourceIds) throws IOException {
        String endpoint = "/security/cases/eDiscoveryCases/" + caseId + "/noncustodialDataSources/applyHold";
        return this.startHoldOperation(endpoint, nonCustodialDataSourceIds);
    }

    public HoldOperation removeHoldFromNonCustodialDataSources(String caseId, Collection<String> nonCustodialDataSourceIds) throws IOException {
        String endpoint = "/security/cases/eDiscoveryCases/" + caseId + "/noncustodialDataSources/removeHold";
        return this.startHoldOperation(endpoint, nonCustodialDataSourceIds);
    }

    private HoldOperation startHoldOperation(String endpoint, Collection<String> ids) throws IOException {
        HashMap<String, Collection<String>> body = new HashMap<String, Collection<String>>();
        if (ids != null && !ids.isEmpty()) {
            body.put("ids", ids);
        }
        ApiProxyRequest apiProxyRequest = this.buildApiProxyRequest(endpoint, "POST", 202, body);
        apiProxyRequest.setProxyResponse(true);
        try (Response response = this.proxyApiRequest(apiProxyRequest);){
            URI uri = response.getLocation();
            if (uri != null) {
                HoldOperation holdOperation = this.proxyApiGetRequest(uri.toString(), new GenericType<HoldOperation>(){});
                return holdOperation;
            }
        }
        return null;
    }

    public List<EDiscoverySearch> getSearches(String caseId) throws IOException {
        return this.getSearches(caseId, null);
    }

    public List<EDiscoverySearch> getSearches(String caseId, String filter) throws IOException {
        String endpoint = "/security/cases/eDiscoveryCases/" + caseId + "/searches";
        if (filter != null) {
            endpoint = endpoint + "?$filter=" + URLEncoder.encode(filter, StandardCharsets.UTF_8.name());
        }
        return this.proxyApiPagedGetRequest(endpoint, new GenericType<List<EDiscoverySearch>>(){});
    }

    public EDiscoverySearch getSearchForId(String caseId, String searchId) throws IOException {
        String endpoint = "/security/cases/eDiscoveryCases/" + caseId + "/searches/" + searchId;
        EDiscoverySearch search = this.proxyApiGetRequest(endpoint, new GenericType<EDiscoverySearch>(){});
        if (search == null) {
            throw new PurviewObjectDoesNotExistException();
        }
        return search;
    }

    public EDiscoverySearch getSearchForName(String caseId, String searchName) throws IOException {
        List<EDiscoverySearch> searches = this.getSearches(caseId);
        searches.removeIf(search -> !search.getDisplayName().equals(searchName));
        if (searches.isEmpty()) {
            throw new PurviewObjectDoesNotExistException();
        }
        if (searches.size() > 1) {
            String errorMessage = iu.getFormattedString("PurviewRestClient.Error.MultipleSearchesWithName", new Object[]{searches.size(), searchName});
            throw new PurviewRestException(errorMessage);
        }
        return searches.get(0);
    }

    public EDiscoverySearch getSearchForNameRegex(String caseId, String nameRegex) throws IOException {
        return PurviewRestClient.getObjectForNameRegex(nameRegex, this.getSearches(caseId), "PurviewRestClient.Error.MultipleSearchesMatchingRegex");
    }

    public EDiscoverySearch createSearch(String caseId, EDiscoverySearch search) throws IOException {
        String endpoint = "/security/cases/eDiscoveryCases/" + caseId + "/searches";
        return this.proxyApiRequest(endpoint, "POST", 201, search, new GenericType<EDiscoverySearch>(){});
    }

    public void updateSearch(String caseId, EDiscoverySearch search) throws IOException {
        String endpoint = "/security/cases/eDiscoveryCases/" + caseId + "/searches/" + search.getId();
        this.proxyApiRequest(endpoint, "PATCH", 204, search);
    }

    public void deleteSearch(String caseId, String searchId) throws IOException {
        String endpoint = "/security/cases/eDiscoveryCases/" + caseId + "/searches/" + searchId;
        this.proxyApiRequest(endpoint, "DELETE", 204);
    }

    public List<DataSource> getSearchCustodialDataSources(String caseId, String searchId) throws IOException {
        String endpoint = "/security/cases/eDiscoveryCases/" + caseId + "/searches/" + searchId + "/custodianSources";
        return this.proxyApiPagedGetRequest(endpoint, new GenericType<List<DataSource>>(){});
    }

    public void addCustodialDataSourceToSearch(String caseId, String searchId, String dataSourceODataId) throws IOException {
        String endpoint = "/security/cases/eDiscoveryCases/" + caseId + "/searches/" + searchId + "/custodianSources";
        DataSource dataSource = new DataSource();
        dataSource.setODataId(dataSourceODataId);
        this.proxyApiRequest(endpoint, "POST", 204, dataSource);
    }

    public List<NonCustodialDataSource> getSearchNonCustodialDataSources(String caseId, String searchId) throws IOException {
        String endpoint = "/security/cases/eDiscoveryCases/" + caseId + "/searches/" + searchId + "/noncustodialSources";
        return this.proxyApiPagedGetRequest(endpoint, new GenericType<List<NonCustodialDataSource>>(){});
    }

    public void addNonCustodialDataSourceToSearch(String caseId, String searchId, String dataSourceODataId) throws IOException {
        String endpoint = "/security/cases/eDiscoveryCases/" + caseId + "/searches/" + searchId + "/noncustodialSources";
        NonCustodialDataSource nonCustodialDataSource = new NonCustodialDataSource();
        nonCustodialDataSource.setODataId(dataSourceODataId);
        this.proxyApiRequest(endpoint, "POST", 204, nonCustodialDataSource);
    }

    public EstimateOperation estimateSearchStatistics(String caseId, String searchId) throws IOException {
        String endpoint = "/security/cases/eDiscoveryCases/" + caseId + "/searches/" + searchId + "/estimateStatistics";
        ApiProxyRequest apiProxyRequest = this.buildApiProxyRequest(endpoint, "POST", 202);
        apiProxyRequest.setProxyResponse(true);
        try (Response response = this.proxyApiRequest(apiProxyRequest);){
            String locationUrl = response.getLocation().toString();
            EstimateOperation estimateOperation = this.proxyApiGetRequest(locationUrl, new GenericType<EstimateOperation>(){});
            return estimateOperation;
        }
    }

    public List<EDiscoveryReviewSet> getReviewSets(String caseId) throws IOException {
        return this.getReviewSets(caseId, null);
    }

    public List<EDiscoveryReviewSet> getReviewSets(String caseId, String filter) throws IOException {
        String endpoint = "/security/cases/eDiscoveryCases/" + caseId + "/reviewSets";
        if (filter != null) {
            endpoint = endpoint + "?$filter=" + URLEncoder.encode(filter, StandardCharsets.UTF_8.name());
        }
        return this.proxyApiPagedGetRequest(endpoint, new GenericType<List<EDiscoveryReviewSet>>(){});
    }

    public EDiscoveryReviewSet getReviewSetForId(String caseId, String reviewSetId) throws IOException {
        String endpoint = "/security/cases/eDiscoveryCases/" + caseId + "/reviewSets/" + reviewSetId;
        EDiscoveryReviewSet reviewSet = this.proxyApiGetRequest(endpoint, new GenericType<EDiscoveryReviewSet>(){});
        if (reviewSet == null) {
            throw new PurviewObjectDoesNotExistException();
        }
        return reviewSet;
    }

    public EDiscoveryReviewSet getReviewSetForName(String caseId, String reviewSetName) throws IOException {
        List<EDiscoveryReviewSet> reviewSets = this.getReviewSets(caseId);
        reviewSets.removeIf(set -> !set.getDisplayName().equals(reviewSetName));
        if (reviewSets.isEmpty()) {
            throw new PurviewObjectDoesNotExistException();
        }
        if (reviewSets.size() > 1) {
            String errorMessage = iu.getFormattedString("PurviewRestClient.Error.MultipleReviewSetsWithName", new Object[]{reviewSets.size(), reviewSetName});
            throw new PurviewRestException(errorMessage);
        }
        return reviewSets.get(0);
    }

    public EDiscoveryReviewSet getReviewSetForNameRegex(String caseId, String nameRegex) throws IOException {
        return PurviewRestClient.getObjectForNameRegex(nameRegex, this.getReviewSets(caseId), "PurviewRestClient.Error.MultipleReviewSetsMatchingRegex");
    }

    public EDiscoveryReviewSet createReviewSet(String caseId, EDiscoveryReviewSet reviewSet) throws IOException {
        String endpoint = "/security/cases/eDiscoveryCases/" + caseId + "/reviewSets";
        return this.proxyApiRequest(endpoint, "POST", 201, reviewSet, new GenericType<EDiscoveryReviewSet>(){});
    }

    public AddToReviewSetOperation addSearchToReviewSet(String caseId, String reviewSetId, final String searchId, String additionalDataOptions) throws IOException {
        String endpoint = "/security/cases/eDiscoveryCases/" + caseId + "/reviewSets/" + reviewSetId + "/addToReviewSet";
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("search", new HashMap<String, String>(){
            {
                this.put("id", searchId);
            }
        });
        if (additionalDataOptions != null) {
            body.put("additionalDataOptions", additionalDataOptions);
        }
        ApiProxyRequest apiProxyRequest = this.buildApiProxyRequest(endpoint, "POST", 202, body);
        apiProxyRequest.setProxyResponse(true);
        try (Response response = this.proxyApiRequest(apiProxyRequest);){
            String locationUrl = response.getLocation().toString();
            AddToReviewSetOperation addToReviewSetOperation = this.proxyApiGetRequest(locationUrl, new GenericType<AddToReviewSetOperation>(){});
            return addToReviewSetOperation;
        }
    }

    public ReviewSetExportOperation exportReviewSet(String caseId, String reviewSetId, EDiscoveryReviewSetExport export) throws IOException {
        String endpoint = "/security/cases/eDiscoveryCases/" + caseId + "/reviewSets/" + reviewSetId + "/export";
        ApiProxyRequest apiProxyRequest = this.buildApiProxyRequest(endpoint, "POST", 202, export);
        apiProxyRequest.setProxyResponse(true);
        try (Response response = this.proxyApiRequest(apiProxyRequest);){
            String locationUrl = response.getLocation().toString();
            ReviewSetExportOperation reviewSetExportOperation = this.proxyApiGetRequest(locationUrl, new GenericType<ReviewSetExportOperation>(){});
            return reviewSetExportOperation;
        }
    }

    public SearchExportOperation exportSearch(String caseId, String searchId, EDiscoverySearchExport export) throws IOException {
        String endpoint = "/security/cases/eDiscoveryCases/" + caseId + "/searches/" + searchId + "/exportResult";
        ApiProxyRequest apiProxyRequest = this.buildApiProxyRequest(endpoint, "POST", 202, export);
        apiProxyRequest.setProxyResponse(true);
        try (Response response = this.proxyApiRequest(apiProxyRequest);){
            String locationUrl = response.getLocation().toString();
            SearchExportOperation searchExportOperation = this.proxyApiGetRequest(locationUrl, new GenericType<SearchExportOperation>(){});
            return searchExportOperation;
        }
    }

    public List<EDiscoveryReviewSetQuery> getReviewSetQueries(String caseId, String reviewSetId) throws IOException {
        return this.getReviewSetQueries(caseId, reviewSetId, null);
    }

    public List<EDiscoveryReviewSetQuery> getReviewSetQueries(String caseId, String reviewSetId, String filter) throws IOException {
        String endpoint = "/security/cases/eDiscoveryCases/" + caseId + "/reviewSets/" + reviewSetId + "/queries";
        if (filter != null) {
            endpoint = endpoint + "?$filter=" + URLEncoder.encode(filter, StandardCharsets.UTF_8.name());
        }
        return this.proxyApiPagedGetRequest(endpoint, new GenericType<List<EDiscoveryReviewSetQuery>>(){});
    }

    public EDiscoveryReviewSetQuery getReviewSetQueryForId(String caseId, String reviewSetId, String reviewSetQueryId) throws IOException {
        String endpoint = "/security/cases/eDiscoveryCases/" + caseId + "/reviewSets/" + reviewSetId + "/queries/" + reviewSetQueryId;
        EDiscoveryReviewSetQuery reviewSetQuery = this.proxyApiGetRequest(endpoint, new GenericType<EDiscoveryReviewSetQuery>(){});
        if (reviewSetQuery == null) {
            throw new PurviewObjectDoesNotExistException();
        }
        return reviewSetQuery;
    }

    public EDiscoveryReviewSetQuery getReviewSetQueryForName(String caseId, String reviewSetId, String reviewSetQueryName) throws IOException {
        List<EDiscoveryReviewSetQuery> reviewSetQueries = this.getReviewSetQueries(caseId, reviewSetId);
        reviewSetQueries.removeIf(query -> !query.getDisplayName().equals(reviewSetQueryName));
        if (reviewSetQueries.isEmpty()) {
            throw new PurviewObjectDoesNotExistException();
        }
        if (reviewSetQueries.size() > 1) {
            String errorMessage = iu.getFormattedString("PurviewRestClient.Error.MultipleReviewSetQueriesWithName", new Object[]{reviewSetQueries.size(), reviewSetQueryName});
            throw new PurviewRestException(errorMessage);
        }
        return reviewSetQueries.get(0);
    }

    public EDiscoveryReviewSetQuery getReviewSetQueryForNameRegex(String caseId, String reviewSetId, String nameRegex) throws IOException {
        return PurviewRestClient.getObjectForNameRegex(nameRegex, this.getReviewSetQueries(caseId, reviewSetId), "PurviewRestClient.Error.MultipleReviewSetQueriesMatchingRegex");
    }

    public List<EDiscoveryReviewSetQuery> getReviewSetQueriesForNameRegex(String caseId, String reviewSetId, String nameRegex) throws IOException {
        return PurviewRestClient.getObjectsForNameRegex(nameRegex, this.getReviewSetQueries(caseId, reviewSetId));
    }

    public EDiscoveryReviewSetQuery createReviewSetQuery(String caseId, String reviewSetId, EDiscoveryReviewSetQuery reviewSetQuery) throws IOException {
        String endpoint = "/security/cases/eDiscoveryCases/" + caseId + "/reviewSets/" + reviewSetId + "/queries";
        return this.proxyApiRequest(endpoint, "POST", 201, reviewSetQuery, new GenericType<EDiscoveryReviewSetQuery>(){});
    }

    public void updateReviewSetQuery(String caseId, String reviewSetId, String reviewSetQueryId, EDiscoveryReviewSetQuery reviewSetQuery) throws IOException {
        String endpoint = "/security/cases/eDiscoveryCases/" + caseId + "/reviewSets/" + reviewSetId + "/queries/" + reviewSetQueryId;
        this.proxyApiRequest(endpoint, "PATCH", 204, reviewSetQuery);
    }

    public void deleteReviewSetQuery(String caseId, String reviewSetId, String reviewSetQueryId) throws IOException {
        String endpoint = "/security/cases/eDiscoveryCases/" + caseId + "/reviewSets/" + reviewSetId + "/queries/" + reviewSetQueryId;
        this.proxyApiRequest(endpoint, "DELETE", 204);
    }

    public ReviewSetExportOperation exportReviewSetQuery(String caseId, String reviewSetId, String reviewSetQueryId, EDiscoveryReviewSetExport export) throws IOException {
        String endpoint = "/security/cases/eDiscoveryCases/" + caseId + "/reviewSets/" + reviewSetId + "/queries/" + reviewSetQueryId + "/export";
        ApiProxyRequest apiProxyRequest = this.buildApiProxyRequest(endpoint, "POST", 202, export);
        apiProxyRequest.setProxyResponse(true);
        try (Response response = this.proxyApiRequest(apiProxyRequest);){
            String locationUrl = response.getLocation().toString();
            ReviewSetExportOperation reviewSetExportOperation = this.proxyApiGetRequest(locationUrl, new GenericType<ReviewSetExportOperation>(){});
            return reviewSetExportOperation;
        }
    }

    public List<EDiscoveryHoldPolicy> getHoldPolicies(String caseId) throws IOException {
        String endpoint = "/security/cases/eDiscoveryCases/" + caseId + "/legalHolds";
        ApiProxyRequest apiProxyRequest = this.buildApiProxyRequest(endpoint, "GET", 200);
        apiProxyRequest.setApiVersion("beta");
        apiProxyRequest.setPageRequests(true);
        return this.proxyApiRequest(apiProxyRequest, new GenericType<List<EDiscoveryHoldPolicy>>(){});
    }

    public void deleteHoldPolicy(String caseId, String holdPolicyId) throws IOException {
        String endpoint = "/security/cases/eDiscoveryCases/" + caseId + "/legalHolds/" + holdPolicyId;
        ApiProxyRequest apiProxyRequest = this.buildApiProxyRequest(endpoint, "DELETE", 204);
        apiProxyRequest.setApiVersion("beta");
        this.proxyApiRequest(apiProxyRequest).close();
    }

    public List<CaseOperation> getCaseOperations(String caseId) throws IOException {
        String endpoint = "/security/cases/eDiscoveryCases/" + caseId + "/operations";
        return this.proxyApiPagedGetRequest(endpoint, new GenericType<List<CaseOperation>>(){});
    }

    public <T extends CaseOperation> T getCaseOperation(String caseId, String operationId, Class<T> operationClass) throws IOException {
        String endpoint = "/security/cases/eDiscoveryCases/" + caseId + "/operations/" + operationId;
        return (T)((CaseOperation)this.proxyApiGetRequest(endpoint, new GenericType(operationClass)));
    }

    public String getPurviewDownloadToken() throws IOException {
        String endpoint = "/purviewDownloadToken";
        return this.proxyApiGetRequest(endpoint, new GenericType<String>(){});
    }

    public Map<String, String> normalizeUserEmails(Collection<String> userEmails) throws IOException {
        String endpoint = "/normalizeUserEmails";
        return this.proxyApiRequest(endpoint, "N/A", userEmails, new GenericType<Map<String, String>>(){});
    }

    public String getUserUpn(String email) throws IOException {
        String endpoint = "/upn?email=" + URLEncoder.encode(email, "UTF-8");
        return this.proxyApiGetRequest(endpoint, new GenericType<String>(){});
    }

    public String getUserPersonalSharePointSite(String email) throws IOException {
        String endpoint = "/userSharePoint?email=" + URLEncoder.encode(email, "UTF-8");
        return this.proxyApiGetRequest(endpoint, new GenericType<String>(){});
    }

    public String getGroupPersonalSharePointSite(String email) throws IOException {
        String endpoint = "/groupSharePoint?email=" + URLEncoder.encode(email, "UTF-8");
        return this.proxyApiGetRequest(endpoint, new GenericType<String>(){});
    }

    public List<Team> getUserAssociatedTeams(String email) throws IOException {
        String endpoint = "/userAssociatedTeams?email=" + URLEncoder.encode(email, "UTF-8");
        return this.proxyApiGetRequest(endpoint, new GenericType<List<Team>>(){});
    }

    public List<Team> getUserJoinedTeams(String email) throws IOException {
        String endpoint = "/userJoinedTeams?email=" + URLEncoder.encode(email, "UTF-8");
        return this.proxyApiGetRequest(endpoint, new GenericType<List<Team>>(){});
    }

    private static <T extends MicrosoftGraphObject> T getObjectForNameRegex(String nameRegex, List<T> graphObjects, String multipleMatchingErrorKey) throws PurviewRestException {
        return (T)((MicrosoftGraphObject)PurviewRestClient.getObjectsForNameRegex(nameRegex, graphObjects, multipleMatchingErrorKey).get(0));
    }

    private static <T extends MicrosoftGraphObject> List<T> getObjectsForNameRegex(String nameRegex, List<T> graphObjects) throws PurviewRestException {
        return PurviewRestClient.getObjectsForNameRegex(nameRegex, graphObjects, null);
    }

    private static <T extends MicrosoftGraphObject> List<T> getObjectsForNameRegex(String nameRegex, List<T> graphObjects, String multipleMatchingErrorKey) throws PurviewRestException {
        Pattern namePattern = Pattern.compile(nameRegex);
        ArrayList<MicrosoftGraphObject> matchingObjects = new ArrayList<MicrosoftGraphObject>();
        HashSet<CallSite> objectNamesWithIds = new HashSet<CallSite>();
        for (MicrosoftGraphObject graphObject : graphObjects) {
            Matcher matcher = namePattern.matcher(graphObject.getDisplayName());
            if (!matcher.find()) continue;
            matchingObjects.add(graphObject);
            objectNamesWithIds.add((CallSite)((Object)(graphObject.getDisplayName() + " (ID " + graphObject.getId() + ")")));
        }
        if (matchingObjects.isEmpty()) {
            throw new PurviewObjectDoesNotExistException();
        }
        if (matchingObjects.size() > 1 && multipleMatchingErrorKey != null) {
            String errorMessage = iu.getFormattedString(multipleMatchingErrorKey, new Object[]{objectNamesWithIds.size(), String.join((CharSequence)", ", objectNamesWithIds)});
            throw new PurviewRestException(errorMessage);
        }
        return matchingObjects;
    }

    private static final class StringResponse {
        private String value;

        private StringResponse() {
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

